/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Api;
import hudson.model.Computer;
import hudson.model.Failure;
import hudson.model.Messages;
import hudson.model.ModelObject;
import hudson.model.OneOffExecutor;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.Executables;
import hudson.model.queue.SubTask;
import hudson.model.queue.Tasks;
import hudson.model.queue.WorkUnit;
import hudson.security.ACL;
import hudson.util.InterceptingProxy;
import hudson.util.TimeUnit2;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.servlet.ServletException;
import jenkins.model.CauseOfInterruption;
import jenkins.model.InterruptedBuildAction;
import jenkins.model.Jenkins;
import jenkins.model.queue.AsynchronousExecution;
import org.acegisecurity.Authentication;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;

@ExportedBean
public class Executor
extends Thread
implements ModelObject {
    @Nonnull
    protected final Computer owner;
    private final Queue queue;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    @GuardedBy(value="lock")
    private long startTime;
    private final long creationTime = System.currentTimeMillis();
    private int number;
    @GuardedBy(value="lock")
    private Queue.Executable executable;
    @GuardedBy(value="lock")
    private AsynchronousExecution asynchronousExecution;
    @GuardedBy(value="lock")
    private WorkUnit workUnit;
    private Throwable causeOfDeath;
    private boolean induceDeath;
    @GuardedBy(value="lock")
    private boolean started;
    @GuardedBy(value="lock")
    private Result interruptStatus;
    @GuardedBy(value="lock")
    private final List<CauseOfInterruption> causes = new Vector<CauseOfInterruption>();
    private static final ThreadLocal<Executor> IMPERSONATION = new ThreadLocal();
    private static final Logger LOGGER = Logger.getLogger(Executor.class.getName());

    public Executor(@Nonnull Computer owner, int n) {
        super("Executor #" + n + " for " + owner.getDisplayName());
        this.owner = owner;
        this.queue = Jenkins.getInstance().getQueue();
        this.number = n;
    }

    @Override
    public void interrupt() {
        if (Thread.currentThread() == this) {
            super.interrupt();
        } else {
            this.interrupt(Result.ABORTED);
        }
    }

    void interruptForShutdown() {
        this.interrupt(Result.ABORTED, true);
    }

    public void interrupt(Result result) {
        this.interrupt(result, false);
    }

    private void interrupt(Result result, boolean forShutdown) {
        Authentication a = Jenkins.getAuthentication();
        if (a == ACL.SYSTEM) {
            this.interrupt(result, forShutdown, new CauseOfInterruption[0]);
        } else {
            this.interrupt(result, forShutdown, new CauseOfInterruption.UserInterruption(a.getName()));
        }
    }

    public void interrupt(Result result, CauseOfInterruption ... causes) {
        this.interrupt(result, false, causes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interrupt(Result result, boolean forShutdown, CauseOfInterruption ... causes) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, String.format("%s is interrupted(%s): %s", this.getDisplayName(), result, Util.join(Arrays.asList(causes), ",")), new InterruptedException());
        }
        this.lock.writeLock().lock();
        try {
            if (!this.started) {
                this.owner.removeExecutor(this);
                return;
            }
            this.interruptStatus = result;
            for (CauseOfInterruption c : causes) {
                if (this.causes.contains(c)) continue;
                this.causes.add(c);
            }
            if (this.asynchronousExecution != null) {
                this.asynchronousExecution.interrupt(forShutdown);
            } else {
                super.interrupt();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result abortResult() {
        Thread.interrupted();
        this.lock.writeLock().lock();
        try {
            Result r = this.interruptStatus;
            if (r == null) {
                r = Result.ABORTED;
            }
            Result result = r;
            return result;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordCauseOfInterruption(Run<?, ?> build, TaskListener listener) {
        ArrayList<CauseOfInterruption> r;
        this.lock.writeLock().lock();
        try {
            if (this.causes.isEmpty()) {
                return;
            }
            r = new ArrayList<CauseOfInterruption>(this.causes);
            this.causes.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        build.addAction(new InterruptedBuildAction(r));
        for (CauseOfInterruption c : r) {
            c.print(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetWorkUnit(String reason) {
        StringWriter writer = new StringWriter();
        try (PrintWriter pw = new PrintWriter(writer);){
            pw.printf("%s grabbed %s from queue but %s %s. ", this.getName(), this.workUnit, this.owner.getDisplayName(), reason);
            if (this.owner.getTerminatedBy().isEmpty()) {
                pw.print("No termination trace available.");
            } else {
                pw.println("Termination trace follows:");
                for (Computer.TerminationRequest request : this.owner.getTerminatedBy()) {
                    request.printStackTrace(pw);
                }
            }
        }
        LOGGER.log(Level.WARNING, writer.toString());
        this.lock.writeLock().lock();
        try {
            if (this.executable != null) {
                throw new IllegalStateException("Cannot reset the work unit after the executable has been created");
            }
            this.workUnit = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block55: {
            WorkUnit workUnit;
            if (!this.owner.isOnline()) {
                this.resetWorkUnit("went off-line before the task's worker thread started");
                this.owner.removeExecutor(this);
                this.queue.scheduleMaintenance();
                return;
            }
            if (this.owner.getNode() == null) {
                this.resetWorkUnit("was removed before the task's worker thread started");
                this.owner.removeExecutor(this);
                this.queue.scheduleMaintenance();
                return;
            }
            this.lock.writeLock().lock();
            try {
                this.startTime = System.currentTimeMillis();
                workUnit = this.workUnit;
            }
            finally {
                this.lock.writeLock().unlock();
            }
            ACL.impersonate(ACL.SYSTEM);
            try {
                boolean needFinish1;
                Queue.Executable executable;
                if (this.induceDeath) {
                    throw new ThreadDeath();
                }
                SubTask task = Queue.withLock(new Callable<SubTask>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public SubTask call() throws Exception {
                        if (!Executor.this.owner.isOnline()) {
                            Executor.this.resetWorkUnit("went off-line before the task's worker thread was ready to execute");
                            return null;
                        }
                        if (Executor.this.owner.getNode() == null) {
                            Executor.this.resetWorkUnit("was removed before the task's worker thread was ready to execute");
                            return null;
                        }
                        workUnit.setExecutor(Executor.this);
                        Executor.this.queue.onStartExecuting(Executor.this);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, Executor.this.getName() + " grabbed " + workUnit + " from queue");
                        }
                        SubTask task = workUnit.work;
                        Queue.Executable executable = task.createExecutable();
                        Executor.this.lock.writeLock().lock();
                        try {
                            Executor.this.executable = executable;
                        }
                        finally {
                            Executor.this.lock.writeLock().unlock();
                        }
                        workUnit.setExecutable(executable);
                        return task;
                    }
                });
                this.lock.readLock().lock();
                try {
                    if (this.workUnit == null) {
                        return;
                    }
                    executable = this.executable;
                }
                finally {
                    this.lock.readLock().unlock();
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, this.getName() + " is going to execute " + executable);
                }
                Throwable problems = null;
                workUnit.context.synchronizeStart();
                if (executable == null) {
                    throw new Error("The null Executable has been created for " + workUnit + ". The task cannot be executed");
                }
                if (executable instanceof Actionable) {
                    for (Action action : workUnit.context.actions) {
                        ((Actionable)((Object)executable)).addAction(action);
                    }
                }
                ACL.impersonate(workUnit.context.item.authenticate());
                this.setName(this.getName() + " : executing " + executable.toString());
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, this.getName() + " is now executing " + executable);
                }
                this.queue.execute(executable, task);
                this.lock.readLock().lock();
                try {
                    needFinish1 = this.asynchronousExecution == null;
                }
                finally {
                    this.lock.readLock().unlock();
                }
                if (needFinish1) {
                    this.finish1(problems);
                }
                break block55;
                catch (AsynchronousExecution x) {
                    this.lock.writeLock().lock();
                    try {
                        x.setExecutor(this);
                        this.asynchronousExecution = x;
                    }
                    finally {
                        this.lock.writeLock().unlock();
                    }
                    this.lock.readLock().lock();
                    try {
                        needFinish1 = this.asynchronousExecution == null;
                    }
                    finally {
                        this.lock.readLock().unlock();
                    }
                    if (needFinish1) {
                        this.finish1(problems);
                    }
                    break block55;
                }
                catch (Throwable e) {
                    problems = e;
                    this.lock.readLock().lock();
                    {
                        catch (Throwable throwable) {
                            boolean needFinish12;
                            this.lock.readLock().lock();
                            try {
                                needFinish12 = this.asynchronousExecution == null;
                            }
                            finally {
                                this.lock.readLock().unlock();
                            }
                            if (needFinish12) {
                                this.finish1(problems);
                            }
                            throw throwable;
                        }
                    }
                    try {
                        needFinish1 = this.asynchronousExecution == null;
                    }
                    finally {
                        this.lock.readLock().unlock();
                    }
                    if (needFinish1) {
                        this.finish1(problems);
                    }
                }
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.FINE, this.getName() + " interrupted", e);
            }
            catch (Exception e) {
                this.causeOfDeath = e;
                LOGGER.log(Level.SEVERE, "Unexpected executor death", e);
            }
            catch (Error e) {
                this.causeOfDeath = e;
                LOGGER.log(Level.SEVERE, "Unexpected executor death", e);
            }
            finally {
                if (this.asynchronousExecution == null) {
                    this.finish2();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish1(@CheckForNull Throwable problems) {
        if (problems != null) {
            LOGGER.log(Level.SEVERE, "Executor threw an exception", problems);
            this.workUnit.context.abort(problems);
        }
        long time = System.currentTimeMillis() - this.startTime;
        LOGGER.log(Level.FINE, "{0} completed {1} in {2}ms", new Object[]{this.getName(), this.executable, time});
        try {
            this.workUnit.context.synchronizeEnd(this, this.executable, problems, time);
        }
        catch (InterruptedException e) {
            this.workUnit.context.abort(e);
        }
        finally {
            this.workUnit.setExecutor(null);
        }
    }

    private void finish2() {
        for (RuntimeException runtimeException : this.owner.getTerminatedBy()) {
            LOGGER.log(Level.FINE, String.format("%s termination trace", this.getName()), runtimeException);
        }
        if (this.causeOfDeath == null) {
            this.owner.removeExecutor(this);
        }
        if (this instanceof OneOffExecutor) {
            this.owner.remove((OneOffExecutor)this);
        }
        this.queue.scheduleMaintenance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restricted(value={NoExternalUse.class})
    public void completedAsynchronous(@CheckForNull Throwable error) {
        try {
            this.finish1(error);
        }
        finally {
            this.finish2();
        }
        this.asynchronousExecution = null;
    }

    public void killHard() {
        this.induceDeath = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Exported
    @CheckForNull
    public Queue.Executable getCurrentExecutable() {
        this.lock.readLock().lock();
        try {
            Queue.Executable executable = this.executable;
            return executable;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Nonnull
    public Collection<CauseOfInterruption> getCausesOfInterruption() {
        return Collections.unmodifiableCollection(this.causes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Exported
    public WorkUnit getCurrentWorkUnit() {
        this.lock.readLock().lock();
        try {
            WorkUnit workUnit = this.workUnit;
            return workUnit;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilePath getCurrentWorkspace() {
        this.lock.readLock().lock();
        try {
            if (this.executable == null) {
                FilePath filePath = null;
                return filePath;
            }
            if (this.executable instanceof AbstractBuild) {
                AbstractBuild ab = (AbstractBuild)this.executable;
                FilePath filePath = ab.getWorkspace();
                return filePath;
            }
            FilePath filePath = null;
            return filePath;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public String getDisplayName() {
        return "Executor #" + this.getNumber();
    }

    @Exported
    public int getNumber() {
        return this.number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Exported
    public boolean isIdle() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.workUnit == null && this.executable == null;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBusy() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.workUnit != null || this.executable != null;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        this.lock.readLock().lock();
        try {
            boolean bl = !this.started || this.asynchronousExecution != null || this.isAlive();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public AsynchronousExecution getAsynchronousExecution() {
        this.lock.readLock().lock();
        try {
            AsynchronousExecution asynchronousExecution = this.asynchronousExecution;
            return asynchronousExecution;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isDisplayCell() {
        AsynchronousExecution asynchronousExecution = this.getAsynchronousExecution();
        return asynchronousExecution == null || asynchronousExecution.displayCell();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParking() {
        this.lock.readLock().lock();
        try {
            boolean bl = !this.started;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @CheckForNull
    public Throwable getCauseOfDeath() {
        return this.causeOfDeath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Exported
    public int getProgress() {
        long d;
        this.lock.readLock().lock();
        try {
            if (this.executable == null) {
                int n = -1;
                return n;
            }
            d = Executables.getEstimatedDurationFor(this.executable);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (d <= 0L) {
            return -1;
        }
        int num = (int)(this.getElapsedTime() * 100L / d);
        if (num >= 100) {
            num = 99;
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Exported
    public boolean isLikelyStuck() {
        long d;
        long elapsed;
        this.lock.readLock().lock();
        try {
            if (this.executable == null) {
                boolean bl = false;
                return bl;
            }
            elapsed = this.getElapsedTime();
            d = Executables.getEstimatedDurationFor(this.executable);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (d >= 0L) {
            return d * 10L < elapsed;
        }
        return TimeUnit2.MILLISECONDS.toHours(elapsed) > 24L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getElapsedTime() {
        this.lock.readLock().lock();
        try {
            long l = System.currentTimeMillis() - this.startTime;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeSpentInQueue() {
        this.lock.readLock().lock();
        try {
            long l = this.startTime - this.workUnit.context.item.buildableStartMilliseconds;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String getTimestampString() {
        return Util.getPastTimeString(this.getElapsedTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEstimatedRemainingTime() {
        long d;
        this.lock.readLock().lock();
        try {
            if (this.executable == null) {
                String string = Messages.Executor_NotAvailable();
                return string;
            }
            d = Executables.getEstimatedDurationFor(this.executable);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (d < 0L) {
            return Messages.Executor_NotAvailable();
        }
        long eta = d - this.getElapsedTime();
        if (eta <= 0L) {
            return Messages.Executor_NotAvailable();
        }
        return Util.getTimeSpanString(eta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEstimatedRemainingTimeMillis() {
        long d;
        this.lock.readLock().lock();
        try {
            if (this.executable == null) {
                long l = -1L;
                return l;
            }
            d = Executables.getEstimatedDurationFor(this.executable);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (d < 0L) {
            return -1L;
        }
        long eta = d - this.getElapsedTime();
        if (eta <= 0L) {
            return -1L;
        }
        return eta;
    }

    @Override
    public void start() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(WorkUnit task) {
        this.lock.writeLock().lock();
        try {
            this.workUnit = task;
            super.start();
            this.started = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @RequirePOST
    @Deprecated
    public void doStop(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.doStop().generateResponse(req, rsp, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequirePOST
    public HttpResponse doStop() {
        this.lock.writeLock().lock();
        try {
            if (this.executable != null) {
                Tasks.getOwnerTaskOf(Executables.getParentOf(this.executable)).checkAbortPermission();
                this.interrupt();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return HttpResponses.forwardToPreviousPage();
    }

    @RequirePOST
    public HttpResponse doYank() {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        if (this.isActive()) {
            throw new Failure("Can't yank a live executor");
        }
        this.owner.removeExecutor(this);
        return HttpResponses.redirectViaContextPath((String)"/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasStopPermission() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.executable != null && Tasks.getOwnerTaskOf(Executables.getParentOf(this.executable)).hasAbortPermission();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Nonnull
    public Computer getOwner() {
        return this.owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getIdleStartMilliseconds() {
        this.lock.readLock().lock();
        try {
            if (this.isIdle()) {
                long l = Math.max(this.creationTime, this.owner.getConnectTime());
                return l;
            }
            long l = Math.max(this.startTime + Math.max(0L, Executables.getEstimatedDurationFor(this.executable)), System.currentTimeMillis() + 15000L);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Api getApi() {
        return new Api(this);
    }

    public <T> T newImpersonatingProxy(Class<T> type, T core) {
        return new InterceptingProxy(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Object call(Object o, Method m, Object[] args) throws Throwable {
                Executor old = (Executor)IMPERSONATION.get();
                IMPERSONATION.set(Executor.this);
                try {
                    Object object = m.invoke(o, args);
                    return object;
                }
                finally {
                    IMPERSONATION.set(old);
                }
            }
        }.wrap(type, core);
    }

    @CheckForNull
    public static Executor currentExecutor() {
        Thread t = Thread.currentThread();
        if (t instanceof Executor) {
            return (Executor)t;
        }
        return IMPERSONATION.get();
    }

    @CheckForNull
    public static Executor of(Queue.Executable executable) {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            return null;
        }
        for (Computer computer : jenkins.getComputers()) {
            for (Executor executor : computer.getExecutors()) {
                if (executor.getCurrentExecutable() != executable) continue;
                return executor;
            }
            for (Executor executor : computer.getOneOffExecutors()) {
                if (executor.getCurrentExecutable() != executable) continue;
                return executor;
            }
        }
        return null;
    }

    @Deprecated
    public static long getEstimatedDurationFor(Queue.Executable e) {
        return Executables.getEstimatedDurationFor(e);
    }
}

