/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Extension;
import hudson.FilePath;
import hudson.cli.CLICommand;
import hudson.model.FileParameterValue;
import hudson.model.Messages;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload.FileItem;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class FileParameterDefinition
extends ParameterDefinition {
    @DataBoundConstructor
    public FileParameterDefinition(String name, String description) {
        super(name, description);
    }

    @Override
    public FileParameterValue createValue(StaplerRequest req, JSONObject jo) {
        FileParameterValue p = (FileParameterValue)req.bindJSON(FileParameterValue.class, jo);
        p.setLocation(this.getName());
        p.setDescription(this.getDescription());
        return p;
    }

    @Override
    public ParameterValue createValue(StaplerRequest req) {
        FileItem src;
        try {
            src = req.getFileItem(this.getName());
        }
        catch (ServletException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        if (src == null) {
            return null;
        }
        FileParameterValue p = new FileParameterValue(this.getName(), src, this.getFileName(src.getName()));
        p.setDescription(this.getDescription());
        p.setLocation(this.getName());
        return p;
    }

    private String getFileName(String possiblyPathName) {
        possiblyPathName = possiblyPathName.substring(possiblyPathName.lastIndexOf(47) + 1);
        possiblyPathName = possiblyPathName.substring(possiblyPathName.lastIndexOf(92) + 1);
        return possiblyPathName;
    }

    @Override
    public ParameterValue createValue(CLICommand command, String value) throws IOException, InterruptedException {
        FilePath src = new FilePath((VirtualChannel)command.checkChannel(), value);
        File local = File.createTempFile("jenkins", "parameter");
        src.copyTo(new FilePath(local));
        FileParameterValue p = new FileParameterValue(this.getName(), local, src.getName());
        p.setDescription(this.getDescription());
        p.setLocation(this.getName());
        return p;
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        @Override
        public String getDisplayName() {
            return Messages.FileParameterDefinition_DisplayName();
        }

        @Override
        public String getHelpFile() {
            return "/help/parameter/file.html";
        }
    }
}

