/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Util;
import hudson.XmlFile;
import hudson.model.Failure;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Messages;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.model.listeners.ItemListener;
import hudson.security.AccessControlled;
import hudson.util.CopyOnWriteMap;
import hudson.util.Function1;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jenkins.model.Jenkins;
import jenkins.security.NotReallyRoleSensitiveCallable;
import jenkins.util.xml.XMLUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.xml.sax.SAXException;

public abstract class ItemGroupMixIn {
    private final ItemGroup parent;
    private final AccessControlled acl;
    public static final Function1<String, Item> KEYED_BY_NAME = new Function1<String, Item>(){

        @Override
        public String call(Item item) {
            return item.getName();
        }
    };

    protected ItemGroupMixIn(ItemGroup parent, AccessControlled acl) {
        this.parent = parent;
        this.acl = acl;
    }

    protected abstract void add(TopLevelItem var1);

    protected abstract File getRootDirFor(String var1);

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <K, V extends Item> Map<K, V> loadChildren(ItemGroup parent, File modulesDir, Function1<? extends K, ? super V> key) {
        modulesDir.mkdirs();
        File[] subdirs = modulesDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File child) {
                return child.isDirectory();
            }
        });
        CopyOnWriteMap.Tree<K, void> configurations = new CopyOnWriteMap.Tree<K, void>();
        File[] arr$ = subdirs;
        int len$ = arr$.length;
        int i$ = 0;
        while (true) {
            block6: {
                if (i$ >= len$) {
                    return configurations;
                }
                File subdir = arr$[i$];
                try {
                    void var9_12;
                    block8: {
                        Object t;
                        block7: {
                            t = parent.getItem(subdir.getName());
                            if (t != null) break block7;
                            XmlFile xmlFile = Items.getConfigFile(subdir);
                            if (xmlFile.exists()) {
                                Item item = Items.load(parent, subdir);
                                break block8;
                            } else {
                                Logger.getLogger(ItemGroupMixIn.class.getName()).log(Level.WARNING, "could not find file " + xmlFile.getFile());
                                break block6;
                            }
                        }
                        t.onLoad(parent, subdir.getName());
                    }
                    configurations.put(key.call(var9_12), var9_12);
                }
                catch (Exception exception) {
                    Logger.getLogger(ItemGroupMixIn.class.getName()).log(Level.WARNING, "could not load " + subdir, exception);
                }
            }
            ++i$;
        }
    }

    public synchronized TopLevelItem createTopLevelItem(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        TopLevelItem result;
        this.acl.checkPermission(Item.CREATE);
        String requestContentType = req.getContentType();
        String mode = req.getParameter("mode");
        if (!(requestContentType != null || mode != null && mode.equals("copy"))) {
            throw new Failure("No Content-Type header set");
        }
        boolean isXmlSubmission = requestContentType != null && (requestContentType.startsWith("application/xml") || requestContentType.startsWith("text/xml"));
        String name = req.getParameter("name");
        if (name == null) {
            throw new Failure("Query parameter 'name' is required");
        }
        Jenkins.checkGoodName(name);
        name = name.trim();
        if (this.parent.getItem(name) != null) {
            throw new Failure(Messages.Hudson_JobAlreadyExists(name));
        }
        if (mode != null && mode.equals("copy")) {
            String from = req.getParameter("from");
            Item src = null;
            if (!from.startsWith("/")) {
                src = (Item)this.parent.getItem(from);
            }
            if (src == null) {
                src = Jenkins.getInstance().getItemByFullName(from);
            }
            if (src == null) {
                if (Util.fixEmpty(from) == null) {
                    throw new Failure("Specify which job to copy");
                }
                throw new Failure("No such job: " + from);
            }
            if (!(src instanceof TopLevelItem)) {
                throw new Failure(from + " cannot be copied");
            }
            result = this.copy((TopLevelItem)src, name);
        } else {
            if (isXmlSubmission) {
                TopLevelItem result2 = this.createProjectFromXML(name, (InputStream)req.getInputStream());
                rsp.setStatus(200);
                return result2;
            }
            if (mode == null) {
                throw new Failure("No mode given");
            }
            TopLevelItemDescriptor descriptor = Items.all().findByName(mode);
            if (descriptor == null) {
                throw new Failure("No item type \u2018" + mode + "\u2019 is known");
            }
            descriptor.checkApplicableIn(this.parent);
            this.acl.getACL().checkCreatePermission(this.parent, descriptor);
            result = this.createProject(descriptor, name, true);
        }
        rsp.sendRedirect2(this.redirectAfterCreateItem(req, result));
        return result;
    }

    protected String redirectAfterCreateItem(StaplerRequest req, TopLevelItem result) throws IOException {
        return req.getContextPath() + '/' + result.getUrl() + "configure";
    }

    public synchronized <T extends TopLevelItem> T copy(T src, String name) throws IOException {
        this.acl.checkPermission(Item.CREATE);
        src.checkPermission(Item.EXTENDED_READ);
        src.getDescriptor().checkApplicableIn(this.parent);
        this.acl.getACL().checkCreatePermission(this.parent, src.getDescriptor());
        TopLevelItem result = this.createProject(src.getDescriptor(), name, false);
        Util.copyFile(Items.getConfigFile(src).getFile(), Items.getConfigFile(result).getFile());
        final File rootDir = result.getRootDir();
        result = (TopLevelItem)Items.whileUpdatingByXml(new NotReallyRoleSensitiveCallable<T, IOException>(){

            public T call() throws IOException {
                return (TopLevelItem)Items.load(ItemGroupMixIn.this.parent, rootDir);
            }
        });
        result.onCopiedFrom(src);
        this.add(result);
        ItemListener.fireOnCopied(src, result);
        Jenkins.getInstance().rebuildDependencyGraphAsync();
        return (T)result;
    }

    public synchronized TopLevelItem createProjectFromXML(String name, InputStream xml) throws IOException {
        this.acl.checkPermission(Item.CREATE);
        Jenkins.getInstance().getProjectNamingStrategy().checkName(name);
        if (this.parent.getItem(name) != null) {
            throw new IllegalArgumentException(this.parent.getDisplayName() + " already contains an item '" + name + "'");
        }
        File configXml = Items.getConfigFile(this.getRootDirFor(name)).getFile();
        final File dir = configXml.getParentFile();
        dir.mkdirs();
        boolean success = false;
        try {
            XMLUtils.safeTransform(new StreamSource(xml), new StreamResult(configXml));
            TopLevelItem result = Items.whileUpdatingByXml(new NotReallyRoleSensitiveCallable<TopLevelItem, IOException>(){

                public TopLevelItem call() throws IOException {
                    return (TopLevelItem)Items.load(ItemGroupMixIn.this.parent, dir);
                }
            });
            success = this.acl.getACL().hasCreatePermission(Jenkins.getAuthentication(), this.parent, result.getDescriptor()) && result.getDescriptor().isApplicableIn(this.parent);
            this.add(result);
            ItemListener.fireOnCreated(result);
            Jenkins.getInstance().rebuildDependencyGraphAsync();
            TopLevelItem topLevelItem = result;
            return topLevelItem;
        }
        catch (TransformerException e) {
            success = false;
            throw new IOException("Failed to persist config.xml", e);
        }
        catch (SAXException e) {
            success = false;
            throw new IOException("Failed to persist config.xml", e);
        }
        catch (IOException e) {
            success = false;
            throw e;
        }
        catch (RuntimeException e) {
            success = false;
            throw e;
        }
        finally {
            if (!success) {
                Util.deleteRecursive(dir);
            }
        }
    }

    public synchronized TopLevelItem createProject(TopLevelItemDescriptor type, String name, boolean notify) throws IOException {
        this.acl.checkPermission(Item.CREATE);
        type.checkApplicableIn(this.parent);
        this.acl.getACL().checkCreatePermission(this.parent, type);
        Jenkins.getInstance().getProjectNamingStrategy().checkName(name);
        if (this.parent.getItem(name) != null) {
            throw new IllegalArgumentException("Project of the name " + name + " already exists");
        }
        TopLevelItem item = type.newInstance(this.parent, name);
        try {
            this.callOnCreatedFromScratch(item);
        }
        catch (AbstractMethodError e) {
            // empty catch block
        }
        item.save();
        this.add(item);
        Jenkins.getInstance().rebuildDependencyGraphAsync();
        if (notify) {
            ItemListener.fireOnCreated(item);
        }
        return item;
    }

    private void callOnCreatedFromScratch(TopLevelItem item) {
        item.onCreatedFromScratch();
    }
}

