/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Extension;
import hudson.model.Api;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Label;
import hudson.model.Messages;
import hudson.model.MultiStageTimeSeries;
import hudson.model.Node;
import hudson.model.PeriodicWork;
import hudson.model.Queue;
import hudson.model.queue.SubTask;
import hudson.model.queue.Tasks;
import hudson.util.ColorPalette;
import hudson.util.NoOverlapCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class LoadStatistics {
    private final boolean modern;
    @Exported
    public final MultiStageTimeSeries definedExecutors;
    @Exported
    public final MultiStageTimeSeries onlineExecutors;
    @Exported
    public final MultiStageTimeSeries connectingExecutors;
    @Exported
    public final MultiStageTimeSeries busyExecutors;
    @Exported
    public final MultiStageTimeSeries idleExecutors;
    @Exported
    public final MultiStageTimeSeries availableExecutors;
    @Exported
    @Deprecated
    public final MultiStageTimeSeries totalExecutors;
    @Exported
    public final MultiStageTimeSeries queueLength;
    public static final float DECAY = Float.parseFloat(System.getProperty(LoadStatistics.class.getName() + ".decay", "0.9"));
    public static int CLOCK = Integer.getInteger(LoadStatistics.class.getName() + ".clock", 10000);

    protected LoadStatistics(int initialOnlineExecutors, int initialBusyExecutors) {
        this.definedExecutors = new MultiStageTimeSeries(Messages._LoadStatistics_Legends_DefinedExecutors(), ColorPalette.YELLOW, initialOnlineExecutors, DECAY);
        this.onlineExecutors = new MultiStageTimeSeries(Messages._LoadStatistics_Legends_OnlineExecutors(), ColorPalette.BLUE, initialOnlineExecutors, DECAY);
        this.connectingExecutors = new MultiStageTimeSeries(Messages._LoadStatistics_Legends_ConnectingExecutors(), ColorPalette.YELLOW, 0.0f, DECAY);
        this.busyExecutors = new MultiStageTimeSeries(Messages._LoadStatistics_Legends_BusyExecutors(), ColorPalette.RED, initialBusyExecutors, DECAY);
        this.idleExecutors = new MultiStageTimeSeries(Messages._LoadStatistics_Legends_IdleExecutors(), ColorPalette.YELLOW, initialOnlineExecutors - initialBusyExecutors, DECAY);
        this.availableExecutors = new MultiStageTimeSeries(Messages._LoadStatistics_Legends_AvailableExecutors(), ColorPalette.YELLOW, initialOnlineExecutors - initialBusyExecutors, DECAY);
        this.queueLength = new MultiStageTimeSeries(Messages._LoadStatistics_Legends_QueueLength(), ColorPalette.GREY, 0.0f, DECAY);
        this.totalExecutors = this.onlineExecutors;
        this.modern = LoadStatistics.isModern(this.getClass());
    }

    static boolean isModern(Class<? extends LoadStatistics> clazz) {
        boolean hasGetNodes = false;
        boolean hasMatches = false;
        while (!(clazz == LoadStatistics.class || clazz == null || hasGetNodes && hasMatches)) {
            Method getNodes;
            if (!hasGetNodes) {
                try {
                    getNodes = clazz.getDeclaredMethod("getNodes", new Class[0]);
                    hasGetNodes = !Modifier.isAbstract(getNodes.getModifiers());
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            if (!hasMatches) {
                try {
                    getNodes = clazz.getDeclaredMethod("matches", Queue.Item.class, SubTask.class);
                    hasMatches = !Modifier.isAbstract(getNodes.getModifiers());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (hasGetNodes && hasMatches || !LoadStatistics.class.isAssignableFrom(clazz.getSuperclass())) continue;
            clazz = clazz.getSuperclass();
        }
        return hasGetNodes && hasMatches;
    }

    @Deprecated
    public float getLatestIdleExecutors(MultiStageTimeSeries.TimeScale timeScale) {
        return this.idleExecutors.pick(timeScale).getLatest();
    }

    @Deprecated
    public abstract int computeIdleExecutors();

    @Deprecated
    public abstract int computeTotalExecutors();

    @Deprecated
    public abstract int computeQueueLength();

    public JFreeChart createChart(CategoryDataset ds) {
        JFreeChart chart = ChartFactory.createLineChart(null, null, null, (CategoryDataset)ds, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseStroke((Stroke)new BasicStroke(3.0f));
        this.configureRenderer(renderer);
        NoOverlapCategoryAxis domainAxis = new NoOverlapCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }

    protected void configureRenderer(LineAndShapeRenderer renderer) {
        renderer.setSeriesPaint(0, (Paint)ColorPalette.BLUE);
        renderer.setSeriesPaint(1, (Paint)ColorPalette.RED);
        renderer.setSeriesPaint(2, (Paint)ColorPalette.GREY);
        renderer.setSeriesPaint(3, (Paint)ColorPalette.YELLOW);
    }

    public MultiStageTimeSeries.TrendChart createTrendChart(MultiStageTimeSeries.TimeScale timeScale) {
        return MultiStageTimeSeries.createTrendChart(timeScale, this.onlineExecutors, this.busyExecutors, this.queueLength, this.availableExecutors);
    }

    public MultiStageTimeSeries.TrendChart doGraph(@QueryParameter String type) throws IOException {
        return this.createTrendChart(MultiStageTimeSeries.TimeScale.parse(type));
    }

    public Api getApi() {
        return new Api(this);
    }

    @Deprecated
    protected void updateExecutorCounts() {
        this.updateCounts(this.computeSnapshot());
    }

    protected void updateCounts(LoadStatisticsSnapshot current) {
        this.definedExecutors.update(current.getDefinedExecutors());
        this.onlineExecutors.update(current.getOnlineExecutors());
        this.connectingExecutors.update(current.getConnectingExecutors());
        this.busyExecutors.update(current.getBusyExecutors());
        this.idleExecutors.update(current.getIdleExecutors());
        this.availableExecutors.update(current.getAvailableExecutors());
        this.queueLength.update(current.getQueueLength());
    }

    protected abstract Iterable<Node> getNodes();

    protected abstract boolean matches(Queue.Item var1, SubTask var2);

    public LoadStatisticsSnapshot computeSnapshot() {
        if (this.modern) {
            return this.computeSnapshot(Jenkins.getInstance().getQueue().getBuildableItems());
        }
        int t = this.computeTotalExecutors();
        int i = this.computeIdleExecutors();
        return new LoadStatisticsSnapshot(t, t, Math.max(i - t, 0), Math.max(t - i, 0), i, i, this.computeQueueLength());
    }

    protected LoadStatisticsSnapshot computeSnapshot(Iterable<Queue.BuildableItem> queue) {
        LoadStatisticsSnapshot.Builder builder = LoadStatisticsSnapshot.builder();
        Iterable<Node> nodes = this.getNodes();
        if (nodes != null) {
            for (Node node : nodes) {
                builder.with(node);
            }
        }
        int q = 0;
        if (queue != null) {
            for (Queue.BuildableItem item : queue) {
                for (SubTask subTask : item.task.getSubTasks()) {
                    if (!this.matches(item, subTask)) continue;
                    ++q;
                }
            }
        }
        return builder.withQueueLength(q).build();
    }

    @ExportedBean
    public static class LoadStatisticsSnapshot
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int definedExecutors;
        private final int onlineExecutors;
        private final int connectingExecutors;
        private final int busyExecutors;
        private final int idleExecutors;
        private final int availableExecutors;
        private final int queueLength;

        private LoadStatisticsSnapshot(int definedExecutors, int onlineExecutors, int connectingExecutors, int busyExecutors, int idleExecutors, int availableExecutors, int queueLength) {
            this.definedExecutors = definedExecutors;
            this.onlineExecutors = onlineExecutors;
            this.connectingExecutors = connectingExecutors;
            this.busyExecutors = busyExecutors;
            this.idleExecutors = idleExecutors;
            this.availableExecutors = availableExecutors;
            this.queueLength = queueLength;
        }

        @Exported
        public int getDefinedExecutors() {
            return this.definedExecutors;
        }

        @Exported
        public int getOnlineExecutors() {
            return this.onlineExecutors;
        }

        @Exported
        public int getConnectingExecutors() {
            return this.connectingExecutors;
        }

        @Exported
        public int getBusyExecutors() {
            return this.busyExecutors;
        }

        @Exported
        public int getIdleExecutors() {
            return this.idleExecutors;
        }

        @Exported
        public int getAvailableExecutors() {
            return this.availableExecutors;
        }

        @Exported
        public int getQueueLength() {
            return this.queueLength;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LoadStatisticsSnapshot that = (LoadStatisticsSnapshot)o;
            if (this.availableExecutors != that.availableExecutors) {
                return false;
            }
            if (this.busyExecutors != that.busyExecutors) {
                return false;
            }
            if (this.connectingExecutors != that.connectingExecutors) {
                return false;
            }
            if (this.definedExecutors != that.definedExecutors) {
                return false;
            }
            if (this.idleExecutors != that.idleExecutors) {
                return false;
            }
            if (this.onlineExecutors != that.onlineExecutors) {
                return false;
            }
            return this.queueLength == that.queueLength;
        }

        public int hashCode() {
            int result = this.definedExecutors;
            result = 31 * result + this.onlineExecutors;
            result = 31 * result + this.connectingExecutors;
            result = 31 * result + this.busyExecutors;
            result = 31 * result + this.idleExecutors;
            result = 31 * result + this.availableExecutors;
            result = 31 * result + this.queueLength;
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("LoadStatisticsSnapshot{");
            sb.append("definedExecutors=").append(this.definedExecutors);
            sb.append(", onlineExecutors=").append(this.onlineExecutors);
            sb.append(", connectingExecutors=").append(this.connectingExecutors);
            sb.append(", busyExecutors=").append(this.busyExecutors);
            sb.append(", idleExecutors=").append(this.idleExecutors);
            sb.append(", availableExecutors=").append(this.availableExecutors);
            sb.append(", queueLength=").append(this.queueLength);
            sb.append('}');
            return sb.toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private int definedExecutors;
            private int onlineExecutors;
            private int connectingExecutors;
            private int busyExecutors;
            private int idleExecutors;
            private int availableExecutors;
            private int queueLength;

            public LoadStatisticsSnapshot build() {
                return new LoadStatisticsSnapshot(this.definedExecutors, this.onlineExecutors, this.connectingExecutors, this.busyExecutors, this.idleExecutors, this.availableExecutors, this.queueLength);
            }

            public Builder withQueueLength(int queueLength) {
                this.queueLength = queueLength;
                return this;
            }

            public Builder with(@CheckForNull Node node) {
                if (node != null) {
                    return this.with(node.toComputer());
                }
                return this;
            }

            public Builder with(@CheckForNull Computer computer) {
                if (computer == null) {
                    return this;
                }
                if (computer.isOnline()) {
                    List<Executor> executors = computer.getExecutors();
                    boolean acceptingTasks = computer.isAcceptingTasks();
                    for (Executor e : executors) {
                        ++this.definedExecutors;
                        ++this.onlineExecutors;
                        if (e.getCurrentWorkUnit() != null) {
                            ++this.busyExecutors;
                            continue;
                        }
                        ++this.idleExecutors;
                        if (!acceptingTasks) continue;
                        ++this.availableExecutors;
                    }
                } else {
                    int numExecutors = computer.getNumExecutors();
                    this.definedExecutors += numExecutors;
                    if (computer.isConnecting()) {
                        this.connectingExecutors += numExecutors;
                    }
                }
                return this;
            }
        }
    }

    @Extension
    public static class LoadStatisticsUpdater
    extends PeriodicWork {
        @Override
        public long getRecurrencePeriod() {
            return CLOCK;
        }

        @Override
        protected void doRun() {
            Jenkins j = Jenkins.getInstance();
            List<Queue.BuildableItem> bis = j.getQueue().getBuildableItems();
            for (Label l : j.getLabels()) {
                l.loadStatistics.updateCounts(l.loadStatistics.computeSnapshot(bis));
            }
            j.unlabeledLoad.updateCounts(j.unlabeledLoad.computeSnapshot(bis));
            j.overallLoad.updateCounts(j.overallLoad.computeSnapshot(bis));
        }

        private int count(List<Queue.BuildableItem> bis, Label l) {
            int q = 0;
            for (Queue.BuildableItem bi : bis) {
                for (SubTask subTask : Tasks.getSubTasksOf(bi.task)) {
                    if (bi.getAssignedLabelFor(subTask) != l) continue;
                    ++q;
                }
            }
            return q;
        }
    }
}

