/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import hudson.EnvVars;
import hudson.Util;
import hudson.diagnosis.OldDataMonitor;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.EnvironmentContributingAction;
import hudson.model.Label;
import hudson.model.Messages;
import hudson.model.ParameterValue;
import hudson.model.Queue;
import hudson.model.labels.LabelAssignmentAction;
import hudson.model.queue.SubTask;
import hudson.tasks.BuildWrapper;
import hudson.util.VariableResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class ParametersAction
implements Action,
Iterable<ParameterValue>,
Queue.QueueAction,
EnvironmentContributingAction,
LabelAssignmentAction {
    private final List<ParameterValue> parameters;
    @Deprecated
    private transient AbstractBuild<?, ?> build;

    public ParametersAction(List<ParameterValue> parameters) {
        this.parameters = parameters;
    }

    public ParametersAction(ParameterValue ... parameters) {
        this(Arrays.asList(parameters));
    }

    public void createBuildWrappers(AbstractBuild<?, ?> build, Collection<? super BuildWrapper> result) {
        for (ParameterValue p : this.parameters) {
            BuildWrapper w;
            if (p == null || (w = p.createBuildWrapper(build)) == null) continue;
            result.add(w);
        }
    }

    @Override
    public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
        for (ParameterValue p : this.parameters) {
            if (p == null) continue;
            p.buildEnvironment(build, env);
        }
    }

    public String substitute(AbstractBuild<?, ?> build, String text) {
        return Util.replaceMacro(text, this.createVariableResolver(build));
    }

    public VariableResolver<String> createVariableResolver(AbstractBuild<?, ?> build) {
        VariableResolver[] resolvers = new VariableResolver[this.parameters.size() + 1];
        int i = 0;
        for (ParameterValue p : this.parameters) {
            if (p == null) continue;
            resolvers[i++] = p.createVariableResolver(build);
        }
        resolvers[i] = build.getBuildVariableResolver();
        return new VariableResolver.Union<String>(resolvers);
    }

    @Override
    public Iterator<ParameterValue> iterator() {
        return this.parameters.iterator();
    }

    @Exported(visibility=2)
    public List<ParameterValue> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public ParameterValue getParameter(String name) {
        for (ParameterValue p : this.parameters) {
            if (p == null || !p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    @Override
    public Label getAssignedLabel(SubTask task) {
        for (ParameterValue p : this.parameters) {
            Label l;
            if (p == null || (l = p.getAssignedLabel(task)) == null) continue;
            return l;
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        return Messages.ParameterAction_DisplayName();
    }

    @Override
    public String getIconFileName() {
        return "document-properties.png";
    }

    @Override
    public String getUrlName() {
        return "parameters";
    }

    @Override
    public boolean shouldSchedule(List<Action> actions) {
        List<ParametersAction> others = Util.filter(actions, ParametersAction.class);
        if (others.isEmpty()) {
            return !this.parameters.isEmpty();
        }
        HashSet<ParameterValue> params = new HashSet<ParameterValue>();
        for (ParametersAction other : others) {
            params.addAll(other.parameters);
        }
        return !params.equals(new HashSet<ParameterValue>(this.parameters));
    }

    @Nonnull
    public ParametersAction createUpdated(Collection<? extends ParameterValue> overrides) {
        if (overrides == null) {
            return new ParametersAction(this.parameters);
        }
        ArrayList combinedParameters = Lists.newArrayList(overrides);
        HashSet names = Sets.newHashSet();
        for (ParameterValue parameterValue : overrides) {
            if (parameterValue == null) continue;
            names.add(parameterValue.getName());
        }
        for (ParameterValue parameterValue : this.parameters) {
            if (parameterValue == null || names.contains(parameterValue.getName())) continue;
            combinedParameters.add(parameterValue);
        }
        return new ParametersAction(combinedParameters);
    }

    @Nonnull
    public ParametersAction merge(@CheckForNull ParametersAction overrides) {
        if (overrides == null) {
            return new ParametersAction(this.parameters);
        }
        return this.createUpdated(overrides.getParameters());
    }

    private Object readResolve() {
        if (this.build != null) {
            OldDataMonitor.report(this.build, "1.283");
        }
        return this;
    }
}

