/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Extension;
import hudson.Indenter;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.ModifiableItemGroup;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewDescriptor;
import hudson.model.ViewGroup;
import hudson.util.CaseInsensitiveComparator;
import hudson.views.ViewsTabBar;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class TreeView
extends View
implements ViewGroup {
    private final Set<String> jobNames = new TreeSet<String>(CaseInsensitiveComparator.INSTANCE);
    private final CopyOnWriteArrayList<View> views = new CopyOnWriteArrayList();

    @DataBoundConstructor
    public TreeView(String name) {
        super(name);
    }

    public Indenter createFixedIndenter(String d) {
        final int depth = Integer.parseInt(d);
        return new Indenter(){

            protected int getNestLevel(Job job) {
                return depth;
            }
        };
    }

    public synchronized List<TopLevelItem> getItems() {
        return Jenkins.getInstance().getItems();
    }

    @Override
    public boolean contains(TopLevelItem item) {
        return true;
    }

    @Override
    @RequirePOST
    public TopLevelItem doCreateItem(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        ItemGroup<? extends TopLevelItem> ig = this.getOwnerItemGroup();
        if (ig instanceof ModifiableItemGroup) {
            TopLevelItem item = (TopLevelItem)((ModifiableItemGroup)ig).doCreateItem(req, rsp);
            if (item != null) {
                this.jobNames.add(item.getName());
                this.owner.save();
            }
            return item;
        }
        return null;
    }

    @Override
    protected void submit(StaplerRequest req) throws IOException, ServletException, Descriptor.FormException {
    }

    @Override
    public boolean canDelete(View view) {
        return true;
    }

    @Override
    public void deleteView(View view) throws IOException {
        this.views.remove(view);
    }

    @Override
    public Collection<View> getViews() {
        return Collections.unmodifiableList(this.views);
    }

    @Override
    public View getView(String name) {
        for (View v : this.views) {
            if (!v.getViewName().equals(name)) continue;
            return v;
        }
        return null;
    }

    @Override
    public View getPrimaryView() {
        return null;
    }

    @Override
    public void onViewRenamed(View view, String oldName, String newName) {
    }

    public void doCreateView(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        this.checkPermission(View.CREATE);
        this.views.add(View.create(req, rsp, this));
        this.save();
    }

    @Extension
    public static ViewDescriptor register() {
        if (Boolean.getBoolean("hudson.TreeView")) {
            return new DescriptorImpl();
        }
        return null;
    }

    @Override
    public ViewsTabBar getViewsTabBar() {
        return Jenkins.getInstance().getViewsTabBar();
    }

    @Override
    public ItemGroup<? extends TopLevelItem> getItemGroup() {
        return this.getOwnerItemGroup();
    }

    @Override
    public List<Action> getViewActions() {
        return this.owner.getViewActions();
    }

    public static final class DescriptorImpl
    extends ViewDescriptor {
        @Override
        public String getDisplayName() {
            return "Tree View";
        }
    }
}

