/*
 * Decompiled with CFR 0.152.
 */
package hudson.node_monitors;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.node_monitors.AbstractAsyncNodeMonitorDescriptor;
import hudson.node_monitors.Messages;
import hudson.node_monitors.NodeMonitor;
import hudson.remoting.Callable;
import java.io.IOException;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public class ArchitectureMonitor
extends NodeMonitor {

    private static class GetArchTask
    extends MasterToSlaveCallable<String, IOException> {
        private static final long serialVersionUID = 1L;

        private GetArchTask() {
        }

        public String call() {
            String os = System.getProperty("os.name");
            String arch = System.getProperty("os.arch");
            return os + " (" + arch + ')';
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractAsyncNodeMonitorDescriptor<String> {
        @Override
        protected Callable<String, IOException> createCallable(Computer c) {
            return new GetArchTask();
        }

        @Override
        public String getDisplayName() {
            return Messages.ArchitectureMonitor_DisplayName();
        }

        @Override
        public NodeMonitor newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new ArchitectureMonitor();
        }
    }
}

