/*
 * Decompiled with CFR 0.152.
 */
package hudson.os.solaris;

import hudson.Extension;
import hudson.FilePath;
import hudson.FileSystemProvisioner;
import hudson.FileSystemProvisionerDescriptor;
import hudson.WorkspaceSnapshot;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import jenkins.MasterToSlaveFileCallable;
import org.jvnet.solaris.libzfs.LibZFS;
import org.jvnet.solaris.libzfs.ZFSFileSystem;

public class ZFSProvisioner
extends FileSystemProvisioner
implements Serializable {
    private static final LibZFS libzfs = new LibZFS();
    private final String rootDataset;
    private static final long serialVersionUID = 1L;

    public ZFSProvisioner(Node node) throws IOException, InterruptedException {
        this.rootDataset = node.getRootPath().act(new MasterToSlaveFileCallable<String>(){
            private static final long serialVersionUID = -2142349338699797436L;

            @Override
            public String invoke(File f, VirtualChannel channel) throws IOException {
                ZFSFileSystem fs = libzfs.getFileSystemByMountPoint(f);
                if (fs != null) {
                    return fs.getName();
                }
                throw new IOException("Not on ZFS");
            }
        });
    }

    @Override
    public void prepareWorkspace(AbstractBuild<?, ?> build, FilePath ws, final TaskListener listener) throws IOException, InterruptedException {
        final String name = ((AbstractItem)build.getProject()).getFullName();
        ws.act(new MasterToSlaveFileCallable<Void>(){
            private static final long serialVersionUID = 2129531727963121198L;

            @Override
            public Void invoke(File f, VirtualChannel channel) throws IOException {
                ZFSFileSystem fs = libzfs.getFileSystemByMountPoint(f);
                if (fs != null) {
                    return null;
                }
                String fullName = ZFSProvisioner.this.rootDataset + '/' + name;
                listener.getLogger().println("Creating a ZFS file system " + fullName + " at " + f);
                fs = (ZFSFileSystem)libzfs.create(fullName, ZFSFileSystem.class);
                fs.setMountPoint(f);
                fs.mount();
                return null;
            }
        });
    }

    @Override
    public void discardWorkspace(AbstractProject<?, ?> project, FilePath ws) throws IOException, InterruptedException {
        ws.act(new MasterToSlaveFileCallable<Void>(){
            private static final long serialVersionUID = 1916618107019257530L;

            @Override
            public Void invoke(File f, VirtualChannel channel) throws IOException {
                ZFSFileSystem fs = libzfs.getFileSystemByMountPoint(f);
                if (fs != null) {
                    fs.destory(true);
                }
                return null;
            }
        });
    }

    @Deprecated
    public WorkspaceSnapshot snapshot(AbstractBuild<?, ?> build, FilePath ws, TaskListener listener) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public WorkspaceSnapshot snapshot(AbstractBuild<?, ?> build, FilePath ws, String glob, TaskListener listener) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Extension
    public static final class DescriptorImpl
    extends FileSystemProvisionerDescriptor {
        @Override
        public boolean discard(FilePath ws, TaskListener listener) throws IOException, InterruptedException {
            return false;
        }

        @Override
        public String getDisplayName() {
            return "ZFS";
        }
    }
}

