/*
 * Decompiled with CFR 0.152.
 */
package hudson.scheduler;

import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.ParserSharedInputState;
import antlr.SemanticException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import hudson.scheduler.Hash;
import hudson.scheduler.Messages;

abstract class BaseParser
extends LLkParser {
    static final int[] LOWER_BOUNDS = new int[]{0, 0, 1, 1, 0};
    static final int[] UPPER_BOUNDS = new int[]{59, 23, 31, 12, 7};
    protected Hash hash = Hash.zero();
    public static boolean HASH_TOKENS = !"false".equals(System.getProperty(BaseParser.class.getName() + ".hash"));
    public static final int NO_STEP = 1;

    protected BaseParser(int i) {
        super(i);
    }

    protected BaseParser(ParserSharedInputState parserSharedInputState, int i) {
        super(parserSharedInputState, i);
    }

    protected BaseParser(TokenBuffer tokenBuffer, int i) {
        super(tokenBuffer, i);
    }

    protected BaseParser(TokenStream tokenStream, int i) {
        super(tokenStream, i);
    }

    public void setHash(Hash hash) {
        if (hash == null) {
            hash = Hash.zero();
        }
        this.hash = hash;
    }

    protected long doRange(int start, int end, int step, int field) throws ANTLRException {
        this.rangeCheck(start, field);
        this.rangeCheck(end, field);
        if (step <= 0) {
            this.error(Messages.BaseParser_MustBePositive(step));
        }
        if (start > end) {
            this.error(Messages.BaseParser_StartEndReversed(end, start));
        }
        long bits = 0L;
        for (int i = start; i <= end; i += step) {
            bits |= 1L << i;
        }
        return bits;
    }

    protected long doRange(int step, int field) throws ANTLRException {
        return this.doRange(LOWER_BOUNDS[field], UPPER_BOUNDS[field], step, field);
    }

    protected long doHash(int step, int field) throws ANTLRException {
        int u = UPPER_BOUNDS[field];
        if (field == 2) {
            u = 28;
        }
        if (field == 4) {
            u = 6;
        }
        return this.doHash(LOWER_BOUNDS[field], u, step, field);
    }

    protected long doHash(int s, int e, int step, int field) throws ANTLRException {
        this.rangeCheck(s, field);
        this.rangeCheck(e, field);
        if (step > e - s + 1) {
            this.error(Messages.BaseParser_OutOfRange(step, 1, e - s + 1));
            throw new AssertionError();
        }
        if (step > 1) {
            long bits = 0L;
            for (int i = this.hash.next(step) + s; i <= e; i += step) {
                bits |= 1L << i;
            }
            assert (bits != 0L);
            return bits;
        }
        if (step <= 0) {
            this.error(Messages.BaseParser_MustBePositive(step));
            throw new AssertionError();
        }
        assert (step == 1);
        return 1L << s + this.hash.next(e + 1 - s);
    }

    protected void rangeCheck(int value, int field) throws ANTLRException {
        if (value < LOWER_BOUNDS[field] || UPPER_BOUNDS[field] < value) {
            this.error(Messages.BaseParser_OutOfRange(value, LOWER_BOUNDS[field], UPPER_BOUNDS[field]));
        }
    }

    private void error(String msg) throws TokenStreamException, SemanticException {
        Token token = this.LT(0);
        throw new SemanticException(msg, token.getFilename(), token.getLine(), token.getColumn());
    }

    protected Hash getHashForTokens() {
        return HASH_TOKENS ? this.hash : Hash.zero();
    }
}

