/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import hudson.model.User;
import hudson.security.ContainerAuthentication;
import hudson.util.Scrambler;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.Jenkins;
import jenkins.security.ApiTokenProperty;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;

public class BasicAuthenticationFilter
implements Filter {
    private ServletContext servletContext;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse rsp = (HttpServletResponse)response;
        String authorization = req.getHeader("Authorization");
        String path = req.getServletPath();
        if (authorization == null || req.getUserPrincipal() != null || path.startsWith("/secured/") || !Jenkins.getInstance().isUseSecurity()) {
            if (req.getUserPrincipal() != null) {
                SecurityContextHolder.getContext().setAuthentication((Authentication)new ContainerAuthentication(req));
            }
            try {
                chain.doFilter(request, response);
            }
            finally {
                SecurityContextHolder.clearContext();
            }
            return;
        }
        String username = null;
        String password = null;
        String uidpassword = Scrambler.descramble(authorization.substring(6));
        int idx = uidpassword.indexOf(58);
        if (idx >= 0) {
            username = uidpassword.substring(0, idx);
            password = uidpassword.substring(idx + 1);
        }
        if (username == null) {
            rsp.setStatus(401);
            rsp.setHeader("WWW-Authenticate", "Basic realm=\"Jenkins user\"");
            return;
        }
        User u = User.get(username);
        ApiTokenProperty t = u.getProperty(ApiTokenProperty.class);
        if (t != null && t.matchesPassword(password)) {
            SecurityContextHolder.getContext().setAuthentication(u.impersonate());
            try {
                chain.doFilter(request, response);
            }
            finally {
                SecurityContextHolder.clearContext();
            }
            return;
        }
        path = req.getContextPath() + "/secured" + path;
        String q = req.getQueryString();
        if (q != null) {
            path = path + '?' + q;
        }
        rsp.setStatus(302);
        rsp.setHeader("Location", path);
        RequestDispatcher d = this.servletContext.getRequestDispatcher("/j_security_check?j_username=" + URLEncoder.encode(username, "UTF-8") + "&j_password=" + URLEncoder.encode(password, "UTF-8"));
        d.include((ServletRequest)req, (ServletResponse)rsp);
    }

    public void destroy() {
    }
}

