/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import hudson.security.AuthenticationManagerProxy;
import hudson.security.RememberMeServicesProxy;
import hudson.security.SecurityRealm;
import hudson.security.UserDetailsServiceProxy;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.Jenkins;

public class HudsonFilter
implements Filter {
    private volatile Filter filter;
    private FilterConfig filterConfig;
    @Deprecated
    public static final AuthenticationManagerProxy AUTHENTICATION_MANAGER = new AuthenticationManagerProxy();
    @Deprecated
    public static final UserDetailsServiceProxy USER_DETAILS_SERVICE_PROXY = new UserDetailsServiceProxy();
    @Deprecated
    public static final RememberMeServicesProxy REMEMBER_ME_SERVICES_PROXY = new RememberMeServicesProxy();
    private static final Logger LOGGER = Logger.getLogger(HudsonFilter.class.getName());

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        filterConfig.getServletContext().setAttribute(HudsonFilter.class.getName(), (Object)this);
        try {
            Jenkins hudson = Jenkins.getInstance();
            if (hudson != null) {
                LOGGER.fine("Security wasn't initialized; Initializing it...");
                SecurityRealm securityRealm = hudson.getSecurityRealm();
                this.reset(securityRealm);
                LOGGER.fine("securityRealm is " + securityRealm);
                LOGGER.fine("Security initialized");
            }
        }
        catch (ExceptionInInitializerError e) {
            LOGGER.log(Level.SEVERE, "Failed to initialize Jenkins", e);
        }
    }

    public static HudsonFilter get(ServletContext context) {
        return (HudsonFilter)context.getAttribute(HudsonFilter.class.getName());
    }

    public void reset(SecurityRealm securityRealm) throws ServletException {
        if (securityRealm != null) {
            SecurityRealm.SecurityComponents sc = securityRealm.getSecurityComponents();
            AUTHENTICATION_MANAGER.setDelegate(sc.manager);
            USER_DETAILS_SERVICE_PROXY.setDelegate(sc.userDetails);
            REMEMBER_ME_SERVICES_PROXY.setDelegate(sc.rememberMe);
            Filter oldf = this.filter;
            Filter newf = securityRealm.createFilter(this.filterConfig);
            newf.init(this.filterConfig);
            this.filter = newf;
            if (oldf != null) {
                oldf.destroy();
            }
        } else {
            AUTHENTICATION_MANAGER.setDelegate(null);
            USER_DETAILS_SERVICE_PROXY.setDelegate(null);
            REMEMBER_ME_SERVICES_PROXY.setDelegate(null);
            this.filter = null;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        LOGGER.entering(HudsonFilter.class.getName(), "doFilter");
        ((HttpServletResponse)response).setHeader("X-Content-Type-Options", "nosniff");
        Filter f = this.filter;
        if (f == null) {
            chain.doFilter(request, response);
        } else {
            f.doFilter(request, response, chain);
        }
    }

    public void destroy() {
        if (this.filter != null) {
            this.filter.destroy();
        }
    }
}

