/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import com.google.common.collect.ImmutableSet;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Run;
import java.util.Set;
import jenkins.model.Jenkins;

public final class PermissionScope {
    public final Class modelClass;
    private final Set<PermissionScope> containers;
    public static final PermissionScope JENKINS = new PermissionScope(Jenkins.class, new PermissionScope[0]);
    public static final PermissionScope ITEM_GROUP = new PermissionScope(ItemGroup.class, JENKINS);
    public static final PermissionScope ITEM = new PermissionScope(Item.class, ITEM_GROUP);
    public static final PermissionScope RUN = new PermissionScope(Run.class, ITEM);
    public static final PermissionScope COMPUTER = new PermissionScope(Computer.class, JENKINS);

    public PermissionScope(Class modelClass, PermissionScope ... containers) {
        this.modelClass = modelClass;
        this.containers = ImmutableSet.copyOf((Object[])containers);
    }

    public boolean isContainedBy(PermissionScope s) {
        if (this == s) {
            return true;
        }
        for (PermissionScope c : this.containers) {
            if (!c.isContainedBy(s)) continue;
            return true;
        }
        return false;
    }
}

