/*
 * Decompiled with CFR 0.152.
 */
package hudson.security.csrf;

import hudson.security.csrf.CrumbExclusion;
import hudson.security.csrf.CrumbIssuer;
import hudson.security.csrf.CrumbIssuerDescriptor;
import hudson.util.MultipartFormDataParser;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.Jenkins;

public class CrumbFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(CrumbFilter.class.getName());

    public CrumbIssuer getCrumbIssuer() {
        Jenkins h = Jenkins.getInstance();
        if (h == null) {
            return null;
        }
        return h.getCrumbIssuer();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        CrumbIssuer crumbIssuer = this.getCrumbIssuer();
        if (crumbIssuer == null || !(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if ("POST".equals(httpRequest.getMethod())) {
            for (CrumbExclusion e : CrumbExclusion.all()) {
                if (!e.process(httpRequest, httpResponse, chain)) continue;
                return;
            }
            String crumbFieldName = ((CrumbIssuerDescriptor)crumbIssuer.getDescriptor()).getCrumbRequestField();
            String crumbSalt = ((CrumbIssuerDescriptor)crumbIssuer.getDescriptor()).getCrumbSalt();
            String crumb = httpRequest.getHeader(crumbFieldName);
            boolean valid = false;
            if (crumb == null) {
                Enumeration paramNames = request.getParameterNames();
                while (paramNames.hasMoreElements()) {
                    String paramName = (String)paramNames.nextElement();
                    if (!crumbFieldName.equals(paramName)) continue;
                    crumb = request.getParameter(paramName);
                    break;
                }
            }
            if (crumb != null) {
                if (crumbIssuer.validateCrumb((ServletRequest)httpRequest, crumbSalt, crumb)) {
                    valid = true;
                } else {
                    LOGGER.log(Level.WARNING, "Found invalid crumb {0}.  Will check remaining parameters for a valid one...", crumb);
                }
            }
            if (valid) {
                chain.doFilter(request, response);
            } else {
                LOGGER.log(Level.WARNING, "No valid crumb was included in request for {0}. Returning {1}.", new Object[]{httpRequest.getRequestURI(), 403});
                httpResponse.sendError(403, "No valid crumb was included in the request");
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    protected static boolean isMultipart(HttpServletRequest request) {
        if (request == null) {
            return false;
        }
        return MultipartFormDataParser.isMultiPartForm(request.getContentType());
    }

    public void destroy() {
    }
}

