/*
 * Decompiled with CFR 0.152.
 */
package hudson.security.csrf;

import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.init.Initializer;
import hudson.model.Api;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.security.csrf.CrumbIssuerDescriptor;
import hudson.util.MultipartFormDataParser;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class CrumbIssuer
implements Describable<CrumbIssuer>,
ExtensionPoint {
    private static final String CRUMB_ATTRIBUTE = CrumbIssuer.class.getName() + "_crumb";

    @Exported
    public String getCrumbRequestField() {
        return ((CrumbIssuerDescriptor)this.getDescriptor()).getCrumbRequestField();
    }

    @Exported
    public String getCrumb() {
        return this.getCrumb((ServletRequest)Stapler.getCurrentRequest());
    }

    public String getCrumb(ServletRequest request) {
        String crumb = null;
        if (request != null) {
            crumb = (String)request.getAttribute(CRUMB_ATTRIBUTE);
        }
        if (crumb == null) {
            crumb = this.issueCrumb(request, ((CrumbIssuerDescriptor)this.getDescriptor()).getCrumbSalt());
            if (request != null) {
                if (crumb != null && crumb.length() > 0) {
                    request.setAttribute(CRUMB_ATTRIBUTE, (Object)crumb);
                } else {
                    request.removeAttribute(CRUMB_ATTRIBUTE);
                }
            }
        }
        return crumb;
    }

    protected abstract String issueCrumb(ServletRequest var1, String var2);

    public boolean validateCrumb(ServletRequest request) {
        Descriptor desc = this.getDescriptor();
        String crumbField = ((CrumbIssuerDescriptor)desc).getCrumbRequestField();
        String crumbSalt = ((CrumbIssuerDescriptor)desc).getCrumbSalt();
        return this.validateCrumb(request, crumbSalt, request.getParameter(crumbField));
    }

    public boolean validateCrumb(ServletRequest request, MultipartFormDataParser parser) {
        Descriptor desc = this.getDescriptor();
        String crumbField = ((CrumbIssuerDescriptor)desc).getCrumbRequestField();
        String crumbSalt = ((CrumbIssuerDescriptor)desc).getCrumbSalt();
        return this.validateCrumb(request, crumbSalt, parser.get(crumbField));
    }

    public abstract boolean validateCrumb(ServletRequest var1, String var2, String var3);

    @Override
    public CrumbIssuerDescriptor<CrumbIssuer> getDescriptor() {
        return (CrumbIssuerDescriptor)Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    public static DescriptorExtensionList<CrumbIssuer, Descriptor<CrumbIssuer>> all() {
        return Jenkins.getInstance().getDescriptorList(CrumbIssuer.class);
    }

    public Api getApi() {
        return new RestrictedApi(this);
    }

    @Initializer
    public static void initStaplerCrumbIssuer() {
        WebApp.get((ServletContext)Jenkins.getInstance().servletContext).setCrumbIssuer(new org.kohsuke.stapler.CrumbIssuer(){

            public String issueCrumb(StaplerRequest request) {
                CrumbIssuer ci = Jenkins.getInstance().getCrumbIssuer();
                return ci != null ? ci.getCrumb((ServletRequest)request) : DEFAULT.issueCrumb(request);
            }

            public void validateCrumb(StaplerRequest request, String submittedCrumb) {
                CrumbIssuer ci = Jenkins.getInstance().getCrumbIssuer();
                if (ci == null) {
                    DEFAULT.validateCrumb(request, submittedCrumb);
                } else if (!ci.validateCrumb((ServletRequest)request, ((CrumbIssuerDescriptor)ci.getDescriptor()).getCrumbSalt(), submittedCrumb)) {
                    throw new SecurityException("Crumb didn't match");
                }
            }
        });
    }

    @Restricted(value={NoExternalUse.class})
    public static class RestrictedApi
    extends Api {
        RestrictedApi(CrumbIssuer instance) {
            super(instance);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doXml(StaplerRequest req, StaplerResponse rsp, @QueryParameter String xpath, @QueryParameter String wrapper, @QueryParameter String tree, @QueryParameter int depth) throws IOException, ServletException {
            CrumbIssuer ci = (CrumbIssuer)this.bean;
            String text = "/*/crumbRequestField/text()".equals(xpath) ? ci.getCrumbRequestField() : ("/*/crumb/text()".equals(xpath) ? ci.getCrumb() : ("concat(//crumbRequestField,\":\",//crumb)".equals(xpath) ? ci.getCrumbRequestField() + ':' + ci.getCrumb() : ("concat(//crumbRequestField,'=',//crumb)".equals(xpath) ? (ci.getCrumbRequestField().startsWith(".") ? ci.getCrumbRequestField() + '=' + ci.getCrumb() : null) : null)));
            if (text != null) {
                try (OutputStream o = rsp.getCompressedOutputStream((HttpServletRequest)req);){
                    rsp.setContentType("text/plain;charset=UTF-8");
                    o.write(text.getBytes("UTF-8"));
                }
            } else {
                super.doXml(req, rsp, xpath, wrapper, tree, depth);
            }
        }
    }
}

