/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.PingThread;
import hudson.slaves.ComputerListener;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.MasterToSlaveCallable;
import jenkins.slaves.PingFailureAnalyzer;

@Extension
public class ChannelPinger
extends ComputerListener {
    private static final Logger LOGGER = Logger.getLogger(ChannelPinger.class.getName());
    private static final String SYS_PROPERTY_NAME = ChannelPinger.class.getName() + ".pingInterval";
    private int pingInterval = 5;

    public ChannelPinger() {
        String interval = System.getProperty(SYS_PROPERTY_NAME);
        if (interval != null) {
            try {
                this.pingInterval = Integer.valueOf(interval);
            }
            catch (NumberFormatException e) {
                LOGGER.warning("Ignoring invalid " + SYS_PROPERTY_NAME + "=" + interval);
            }
        }
    }

    @Override
    public void preOnline(Computer c, Channel channel, FilePath root, TaskListener listener) {
        this.install(channel);
    }

    public void install(Channel channel) {
        if (this.pingInterval < 1) {
            LOGGER.fine("Slave ping is disabled");
            return;
        }
        try {
            channel.call((Callable)new SetUpRemotePing(this.pingInterval));
            LOGGER.fine("Set up a remote ping for " + channel.getName());
        }
        catch (Exception e) {
            LOGGER.severe("Failed to set up a ping for " + channel.getName());
        }
        ChannelPinger.setUpPingForChannel(channel, this.pingInterval);
    }

    private static void setUpPingForChannel(final Channel channel, int interval) {
        final AtomicBoolean isInClosed = new AtomicBoolean(false);
        final PingThread t = new PingThread(channel, interval * 60 * 1000){

            protected void onDead(Throwable cause) {
                try {
                    for (PingFailureAnalyzer pfa : PingFailureAnalyzer.all()) {
                        pfa.onPingFailure(channel, cause);
                    }
                    if (isInClosed.get()) {
                        LOGGER.log(Level.FINE, "Ping failed after the channel " + channel.getName() + " is already partially closed.", cause);
                    } else {
                        LOGGER.log(Level.INFO, "Ping failed. Terminating the channel " + channel.getName() + ".", cause);
                        channel.close(cause);
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Failed to terminate the channel " + channel.getName(), e);
                }
            }

            protected void onDead() {
                this.onDead(null);
            }
        };
        channel.addListener(new Channel.Listener(){

            public void onClosed(Channel channel, IOException cause) {
                LOGGER.fine("Terminating ping thread for " + channel.getName());
                isInClosed.set(true);
                t.interrupt();
            }
        });
        t.start();
        LOGGER.fine("Ping thread started for " + channel + " with a " + interval + " minute interval");
    }

    private static class SetUpRemotePing
    extends MasterToSlaveCallable<Void, IOException> {
        private static final long serialVersionUID = -2702219700841759872L;
        private int pingInterval;

        public SetUpRemotePing(int pingInterval) {
            this.pingInterval = pingInterval;
        }

        public Void call() throws IOException {
            ChannelPinger.setUpPingForChannel(Channel.current(), this.pingInterval);
            return null;
        }
    }
}

