/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Computer;
import hudson.model.Label;
import hudson.model.LoadStatistics;
import hudson.model.MultiStageTimeSeries;
import hudson.model.Node;
import hudson.model.PeriodicWork;
import hudson.model.Queue;
import hudson.slaves.Cloud;
import hudson.slaves.CloudProvisioningListener;
import hudson.slaves.Messages;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import jenkins.model.Jenkins;

public class NodeProvisioner {
    private final LoadStatistics stat;
    private final Label label;
    private final AtomicReference<List<PlannedNode>> pendingLaunches = new AtomicReference(new ArrayList());
    private final Lock provisioningLock = new ReentrantLock();
    @GuardedBy(value="provisioningLock")
    private StrategyState provisioningState = null;
    private volatile transient long lastSuggestedReview;
    private final MultiStageTimeSeries plannedCapacitiesEMA = new MultiStageTimeSeries(Messages._NodeProvisioner_EmptyString(), Color.WHITE, 0.0f, LoadStatistics.DECAY);
    private static final Logger LOGGER = Logger.getLogger(NodeProvisioner.class.getName());
    private static final float MARGIN = (float)Integer.getInteger(NodeProvisioner.class.getName() + ".MARGIN", 10).intValue() / 100.0f;
    private static final float MARGIN0 = Math.max(MARGIN, NodeProvisioner.getFloatSystemProperty(NodeProvisioner.class.getName() + ".MARGIN0", 0.5f));
    private static final float MARGIN_DECAY = NodeProvisioner.getFloatSystemProperty(NodeProvisioner.class.getName() + ".MARGIN_DECAY", 0.5f);
    private static final MultiStageTimeSeries.TimeScale TIME_SCALE = MultiStageTimeSeries.TimeScale.SEC10;

    public NodeProvisioner(Label label, LoadStatistics loadStatistics) {
        this.label = label;
        this.stat = loadStatistics;
    }

    public List<PlannedNode> getPendingLaunches() {
        return new ArrayList<PlannedNode>((Collection)this.pendingLaunches.get());
    }

    public void suggestReviewNow() {
        if (System.currentTimeMillis() > this.lastSuggestedReview + TimeUnit.SECONDS.toMillis(1L)) {
            this.lastSuggestedReview = System.currentTimeMillis();
            Computer.threadPoolForRemoting.submit(new Runnable(){

                @Override
                public void run() {
                    NodeProvisioner.this.update();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        block4: {
            this.provisioningLock.lock();
            try {
                this.lastSuggestedReview = System.currentTimeMillis();
                Queue.withLock(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Jenkins jenkins = Jenkins.getInstance();
                        int plannedCapacitySnapshot = 0;
                        ArrayList snapPendingLaunches = new ArrayList((Collection)NodeProvisioner.this.pendingLaunches.get());
                        for (PlannedNode f : snapPendingLaunches) {
                            if (f.future.isDone()) {
                                try {
                                    Node node = f.future.get();
                                    for (CloudProvisioningListener cl : CloudProvisioningListener.all()) {
                                        cl.onComplete(f, node);
                                    }
                                    jenkins.addNode(node);
                                    LOGGER.log(Level.INFO, "{0} provisioning successfully completed. We have now {1,number,integer} computer(s)", new Object[]{f.displayName, jenkins.getComputers().length});
                                    continue;
                                }
                                catch (InterruptedException e) {
                                    throw new AssertionError((Object)e);
                                }
                                catch (ExecutionException e) {
                                    LOGGER.log(Level.WARNING, "Provisioned slave " + f.displayName + " failed to launch", e.getCause());
                                    for (CloudProvisioningListener cl : CloudProvisioningListener.all()) {
                                        cl.onFailure(f, e.getCause());
                                    }
                                    continue;
                                }
                                catch (IOException e) {
                                    LOGGER.log(Level.WARNING, "Provisioned slave " + f.displayName + " failed to launch", e);
                                    for (CloudProvisioningListener cl : CloudProvisioningListener.all()) {
                                        cl.onFailure(f, e);
                                    }
                                    continue;
                                }
                                catch (Error e) {
                                    throw e;
                                }
                                catch (Throwable e) {
                                    LOGGER.log(Level.SEVERE, "Unexpected uncaught exception encountered while processing provisioned slave " + f.displayName, e);
                                    continue;
                                }
                                finally {
                                    ArrayList repl;
                                    List orig;
                                    boolean changed;
                                    block15: do {
                                        orig = (List)NodeProvisioner.this.pendingLaunches.get();
                                        repl = new ArrayList(orig);
                                        changed = false;
                                        Iterator iterator = repl.iterator();
                                        while (iterator.hasNext()) {
                                            PlannedNode p = (PlannedNode)iterator.next();
                                            if (p != f) continue;
                                            iterator.remove();
                                            changed = true;
                                            continue block15;
                                        }
                                    } while (changed && !NodeProvisioner.this.pendingLaunches.compareAndSet(orig, repl));
                                    f.spent();
                                    continue;
                                }
                            }
                            plannedCapacitySnapshot += f.numExecutors;
                        }
                        float plannedCapacity = plannedCapacitySnapshot;
                        NodeProvisioner.this.plannedCapacitiesEMA.update(plannedCapacity);
                        LoadStatistics.LoadStatisticsSnapshot snapshot = NodeProvisioner.this.stat.computeSnapshot();
                        int availableSnapshot = snapshot.getAvailableExecutors();
                        int queueLengthSnapshot = snapshot.getQueueLength();
                        if (queueLengthSnapshot <= availableSnapshot) {
                            LOGGER.log(Level.FINER, "Queue length {0} is less than the available capacity {1}. No provisioning strategy required", new Object[]{queueLengthSnapshot, availableSnapshot});
                            NodeProvisioner.this.provisioningState = null;
                        } else {
                            NodeProvisioner.this.provisioningState = new StrategyState(snapshot, NodeProvisioner.this.label, plannedCapacitySnapshot);
                        }
                    }
                });
                if (this.provisioningState == null) break block4;
                ExtensionList<Strategy> strategies = Jenkins.getInstance().getExtensionList(Strategy.class);
                for (Strategy strategy : strategies.isEmpty() ? Arrays.asList(new StandardStrategyImpl()) : strategies) {
                    LOGGER.log(Level.FINER, "Consulting {0} provisioning strategy with state {1}", new Object[]{strategy, this.provisioningState});
                    if (StrategyDecision.PROVISIONING_COMPLETED != strategy.apply(this.provisioningState)) continue;
                    LOGGER.log(Level.FINER, "Provisioning strategy {0} declared provisioning complete", strategy);
                    break;
                }
            }
            finally {
                this.provisioningLock.unlock();
            }
        }
    }

    private static float getFloatSystemProperty(String propName, float defaultValue) {
        String v = System.getProperty(propName);
        if (v != null) {
            try {
                return Float.parseFloat(v);
            }
            catch (NumberFormatException e) {
                LOGGER.warning("Failed to parse a float value from system property " + propName + ". value was " + v);
            }
        }
        return defaultValue;
    }

    @Extension
    public static class NodeProvisionerInvoker
    extends PeriodicWork {
        public static int INITIALDELAY = Integer.getInteger(NodeProvisioner.class.getName() + ".initialDelay", LoadStatistics.CLOCK * 10);
        public static int RECURRENCEPERIOD = Integer.getInteger(NodeProvisioner.class.getName() + ".recurrencePeriod", LoadStatistics.CLOCK);

        @Override
        public long getInitialDelay() {
            return INITIALDELAY;
        }

        @Override
        public long getRecurrencePeriod() {
            return RECURRENCEPERIOD;
        }

        @Override
        protected void doRun() {
            Jenkins h = Jenkins.getInstance();
            h.unlabeledNodeProvisioner.update();
            for (Label l : h.getLabels()) {
                l.nodeProvisioner.update();
            }
        }
    }

    @Extension
    public static class StandardStrategyImpl
    extends Strategy {
        @Override
        @Nonnull
        public StrategyDecision apply(@Nonnull StrategyState state) {
            LoadStatistics.LoadStatisticsSnapshot snapshot = state.getSnapshot();
            boolean needSomeWhenNoneAtAll = snapshot.getAvailableExecutors() + snapshot.getConnectingExecutors() == 0 && snapshot.getOnlineExecutors() + state.getPlannedCapacitySnapshot() + state.getAdditionalPlannedCapacity() == 0 && snapshot.getQueueLength() > 0;
            float available = Math.max((float)snapshot.getAvailableExecutors(), state.getAvailableExecutorsLatest());
            if (available < MARGIN || needSomeWhenNoneAtAll) {
                float m;
                float qlen = Math.min(state.getQueueLengthLatest(), (float)snapshot.getQueueLength());
                float connectingCapacity = Math.min(state.getConnectingExecutorsLatest(), (float)snapshot.getConnectingExecutors());
                float plannedCapacity = Math.max(state.getPlannedCapacityLatest(), (float)state.getPlannedCapacitySnapshot()) + (float)state.getAdditionalPlannedCapacity();
                float excessWorkload = qlen - plannedCapacity - connectingCapacity;
                if (needSomeWhenNoneAtAll && excessWorkload < 1.0f) {
                    excessWorkload = 1.0f;
                }
                if (excessWorkload > 1.0f - (m = this.calcThresholdMargin(state.getTotalSnapshot()))) {
                    LOGGER.log(Level.FINE, "Excess workload {0,number,#.###} detected. (planned capacity={1,number,#.###},connecting capacity={7,number,#.###},Qlen={2,number,#.###},available={3,number,#.###}&{4,number,integer},online={5,number,integer},m={6,number,#.###})", new Object[]{Float.valueOf(excessWorkload), Float.valueOf(plannedCapacity), Float.valueOf(qlen), Float.valueOf(available), snapshot.getAvailableExecutors(), snapshot.getOnlineExecutors(), Float.valueOf(m), snapshot.getConnectingExecutors()});
                    block0: for (Cloud c : Jenkins.getInstance().clouds) {
                        if (excessWorkload < 0.0f) break;
                        if (!c.canProvision(state.getLabel())) continue;
                        int workloadToProvision = (int)Math.round(Math.floor(excessWorkload + m));
                        for (CloudProvisioningListener cl : CloudProvisioningListener.all()) {
                            if (cl.canProvision(c, state.getLabel(), workloadToProvision) == null) continue;
                            continue block0;
                        }
                        Collection<PlannedNode> additionalCapacities = c.provision(state.getLabel(), workloadToProvision);
                        for (CloudProvisioningListener cl : CloudProvisioningListener.all()) {
                            cl.onStarted(c, state.getLabel(), additionalCapacities);
                        }
                        for (PlannedNode ac : additionalCapacities) {
                            LOGGER.log(Level.INFO, "Started provisioning {0} from {1} with {2,number,integer} executors. Remaining excess workload: {3,number,#.###}", new Object[]{ac.displayName, c.name, ac.numExecutors, Float.valueOf(excessWorkload -= (float)ac.numExecutors)});
                        }
                        state.recordPendingLaunches(additionalCapacities);
                    }
                    return excessWorkload > 1.0f - m ? StrategyDecision.CONSULT_REMAINING_STRATEGIES : StrategyDecision.PROVISIONING_COMPLETED;
                }
            }
            return StrategyDecision.CONSULT_REMAINING_STRATEGIES;
        }

        private float calcThresholdMargin(int totalSnapshot) {
            float f = (float)((double)MARGIN + (double)(MARGIN0 - MARGIN) * Math.pow(MARGIN_DECAY, totalSnapshot));
            f = Math.max(f, 0.0f);
            f = Math.min(f, 1.0f);
            return f;
        }
    }

    public final class StrategyState {
        private final Label label;
        private final int plannedCapacitySnapshot;
        private final LoadStatistics.LoadStatisticsSnapshot snapshot;
        @GuardedBy(value="this")
        private int additionalPlannedCapacity;

        private StrategyState(LoadStatistics.LoadStatisticsSnapshot snapshot, Label label, int plannedCapacitySnapshot) {
            this.snapshot = snapshot;
            this.label = label;
            this.plannedCapacitySnapshot = plannedCapacitySnapshot;
        }

        public Label getLabel() {
            return this.label;
        }

        public LoadStatistics.LoadStatisticsSnapshot getSnapshot() {
            return this.snapshot;
        }

        @Deprecated
        public int getQueueLengthSnapshot() {
            return this.snapshot.getQueueLength();
        }

        public int getPlannedCapacitySnapshot() {
            return this.plannedCapacitySnapshot;
        }

        @Deprecated
        public int getIdleSnapshot() {
            return this.snapshot.getAvailableExecutors();
        }

        @Deprecated
        public int getTotalSnapshot() {
            return this.snapshot.getOnlineExecutors();
        }

        public synchronized int getAdditionalPlannedCapacity() {
            return this.additionalPlannedCapacity;
        }

        public float getQueueLengthLatest() {
            return ((NodeProvisioner)NodeProvisioner.this).stat.queueLength.getLatest(TIME_SCALE);
        }

        public float getPlannedCapacityLatest() {
            return NodeProvisioner.this.plannedCapacitiesEMA.getLatest(TIME_SCALE);
        }

        @Deprecated
        public float getIdleLatest() {
            return this.getAvailableExecutorsLatest();
        }

        @Deprecated
        public float getTotalLatest() {
            return this.getOnlineExecutorsLatest();
        }

        public float getDefinedExecutorsLatest() {
            return ((NodeProvisioner)NodeProvisioner.this).stat.definedExecutors.getLatest(TIME_SCALE);
        }

        public float getOnlineExecutorsLatest() {
            return ((NodeProvisioner)NodeProvisioner.this).stat.onlineExecutors.getLatest(TIME_SCALE);
        }

        public float getConnectingExecutorsLatest() {
            return ((NodeProvisioner)NodeProvisioner.this).stat.connectingExecutors.getLatest(TIME_SCALE);
        }

        public float getBusyExecutorsLatest() {
            return ((NodeProvisioner)NodeProvisioner.this).stat.busyExecutors.getLatest(TIME_SCALE);
        }

        public float getIdleExecutorsLatest() {
            return ((NodeProvisioner)NodeProvisioner.this).stat.idleExecutors.getLatest(TIME_SCALE);
        }

        public float getAvailableExecutorsLatest() {
            return ((NodeProvisioner)NodeProvisioner.this).stat.availableExecutors.getLatest(TIME_SCALE);
        }

        public void recordPendingLaunches(PlannedNode ... plannedNodes) {
            this.recordPendingLaunches(Arrays.asList(plannedNodes));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recordPendingLaunches(Collection<PlannedNode> plannedNodes) {
            int additionalPlannedCapacity = 0;
            for (PlannedNode f : plannedNodes) {
                if (f.future.isDone()) {
                    try {
                        Node node = f.future.get();
                        if (node == null) continue;
                        additionalPlannedCapacity += node.getNumExecutors();
                    }
                    catch (InterruptedException e) {
                    }
                    catch (ExecutionException e) {}
                    continue;
                }
                additionalPlannedCapacity += f.numExecutors;
            }
            while (!plannedNodes.isEmpty()) {
                List orig = (List)NodeProvisioner.this.pendingLaunches.get();
                ArrayList<PlannedNode> repl = new ArrayList<PlannedNode>(orig);
                repl.addAll(plannedNodes);
                if (!NodeProvisioner.this.pendingLaunches.compareAndSet(orig, repl)) continue;
                if (additionalPlannedCapacity <= 0) break;
                StrategyState strategyState = this;
                synchronized (strategyState) {
                    this.additionalPlannedCapacity += additionalPlannedCapacity;
                    break;
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("StrategyState{");
            sb.append("label=").append(this.label);
            sb.append(", snapshot=").append(this.snapshot);
            sb.append(", plannedCapacitySnapshot=").append(this.plannedCapacitySnapshot);
            sb.append(", additionalPlannedCapacity=").append(this.additionalPlannedCapacity);
            sb.append('}');
            return sb.toString();
        }
    }

    public static abstract class Strategy
    implements ExtensionPoint {
        @Nonnull
        @GuardedBy(value="NodeProvisioner.this")
        public abstract StrategyDecision apply(@Nonnull StrategyState var1);
    }

    public static enum StrategyDecision {
        CONSULT_REMAINING_STRATEGIES,
        PROVISIONING_COMPLETED;

    }

    public static class PlannedNode {
        public final String displayName;
        public final Future<Node> future;
        public final int numExecutors;

        public PlannedNode(String displayName, Future<Node> future, int numExecutors) {
            if (displayName == null || future == null || numExecutors < 1) {
                throw new IllegalArgumentException();
            }
            this.displayName = displayName;
            this.future = future;
            this.numExecutors = numExecutors;
        }

        public void spent() {
        }
    }
}

