/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import hudson.FilePath;
import hudson.Functions;
import java.io.Closeable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public final class WorkspaceList {
    private final Map<FilePath, Entry> inUse = new HashMap<FilePath, Entry>();
    private static final Logger LOGGER = Logger.getLogger(WorkspaceList.class.getName());
    private static final String COMBINATOR = System.getProperty(WorkspaceList.class.getName(), "@");

    public synchronized Lease allocate(@Nonnull FilePath base) throws InterruptedException {
        return this.allocate(base, new Object());
    }

    public synchronized Lease allocate(@Nonnull FilePath base, Object context) throws InterruptedException {
        int i = 1;
        FilePath candidate;
        Entry e;
        while ((e = this.inUse.get(candidate = i == 1 ? base : base.withSuffix(COMBINATOR + i))) != null && !e.quick && e.context != context) {
            ++i;
        }
        return this.acquire(candidate, false, context);
    }

    public synchronized Lease record(@Nonnull FilePath p) {
        Entry old;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "recorded " + p, new Throwable("from " + this));
        }
        if ((old = this.inUse.put(p, new Entry(p, false))) != null) {
            throw new AssertionError((Object)("Tried to record a workspace already owned: " + old));
        }
        return this.lease(p);
    }

    private synchronized void _release(@Nonnull FilePath p) {
        Entry old = this.inUse.get(p);
        if (old == null) {
            throw new AssertionError((Object)("Releasing unallocated workspace " + p));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "releasing " + p + " with lock count " + old.lockCount, new Throwable("from " + this));
        }
        --old.lockCount;
        if (old.lockCount == 0) {
            this.inUse.remove(p);
        }
        this.notifyAll();
    }

    public synchronized Lease acquire(@Nonnull FilePath p) throws InterruptedException {
        return this.acquire(p, false);
    }

    public synchronized Lease acquire(@Nonnull FilePath p, boolean quick) throws InterruptedException {
        return this.acquire(p, quick, new Object());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Lease acquire(@Nonnull FilePath p, boolean quick, Object context) throws InterruptedException {
        Entry e;
        Thread t = Thread.currentThread();
        String oldName = t.getName();
        t.setName("Waiting to acquire " + p + " : " + t.getName());
        try {
            while ((e = this.inUse.get(p)) != null) {
                if (e.context == context) {
                    break;
                }
                this.wait();
            }
        }
        finally {
            t.setName(oldName);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "acquired " + p + (e == null ? "" : " with lock count " + e.lockCount), new Throwable("from " + this));
        }
        if (e != null) {
            ++e.lockCount;
        } else {
            this.inUse.put(p, new Entry(p, quick, context));
        }
        return this.lease(p);
    }

    private Lease lease(@Nonnull FilePath p) {
        return new Lease(p){
            final AtomicBoolean released;
            {
                this.released = new AtomicBoolean();
            }

            @Override
            public void release() {
                WorkspaceList.this._release(this.path);
            }

            @Override
            public void close() {
                if (this.released.compareAndSet(false, true)) {
                    this.release();
                }
            }
        };
    }

    public static abstract class Lease
    implements Closeable {
        @Nonnull
        public final FilePath path;

        protected Lease(@Nonnull FilePath path) {
            path.getRemote();
            this.path = path;
        }

        public abstract void release();

        @Override
        public void close() {
            this.release();
        }

        public static Lease createDummyLease(@Nonnull FilePath p) {
            return new Lease(p){

                @Override
                public void release() {
                }
            };
        }

        public static Lease createLinkedDummyLease(@Nonnull FilePath p, final Lease parent) {
            return new Lease(p){

                @Override
                public void release() {
                    parent.release();
                }
            };
        }
    }

    public static final class Entry {
        public final Thread holder = Thread.currentThread();
        public final long time = System.currentTimeMillis();
        public final Exception source = new AllocationAt();
        public final boolean quick;
        @Nonnull
        public final FilePath path;
        public final Object context;
        public int lockCount = 1;

        private Entry(@Nonnull FilePath path, boolean quick) {
            this(path, quick, new Object());
        }

        private Entry(@Nonnull FilePath path, boolean quick, Object context) {
            this.path = path;
            this.quick = quick;
            this.context = context;
        }

        public String toString() {
            String s = this.path + " owned by " + this.holder.getName() + " from " + new Date(this.time);
            if (this.quick) {
                s = s + " (quick)";
            }
            s = s + "\n" + Functions.printThrowable(this.source);
            return s;
        }
    }

    private static final class AllocationAt
    extends Exception {
        private AllocationAt() {
        }

        @Override
        public String toString() {
            return "Allocation Point";
        }
    }
}

