/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractProject;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tasks.CommandInterpreter;
import hudson.tasks.Messages;
import hudson.util.LineEndingConversion;
import java.io.ObjectStreamException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class BatchFile
extends CommandInterpreter {
    @DataBoundConstructor
    public BatchFile(String command) {
        super(LineEndingConversion.convertEOL(command, LineEndingConversion.EOLType.Windows));
    }

    @Override
    public String[] buildCommandLine(FilePath script) {
        return new String[]{"cmd", "/c", "call", script.getRemote()};
    }

    @Override
    protected String getContents() {
        return LineEndingConversion.convertEOL(this.command + "\r\nexit %ERRORLEVEL%", LineEndingConversion.EOLType.Windows);
    }

    @Override
    protected String getFileExtension() {
        return ".bat";
    }

    private Object readResolve() throws ObjectStreamException {
        return new BatchFile(this.command);
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        @Override
        public String getHelpFile() {
            return "/help/project-config/batch.html";
        }

        @Override
        public String getDisplayName() {
            return Messages.BatchFile_DisplayName();
        }

        @Override
        public Builder newInstance(StaplerRequest req, JSONObject data) {
            return new BatchFile(data.getString("command"));
        }

        @Override
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

