/*
 * Decompiled with CFR 0.152.
 */
package hudson.tools;

import hudson.Extension;
import hudson.FilePath;
import hudson.tools.AbstractCommandInstaller;
import hudson.tools.Messages;
import hudson.util.LineEndingConversion;
import java.io.ObjectStreamException;
import org.kohsuke.stapler.DataBoundConstructor;

public class CommandInstaller
extends AbstractCommandInstaller {
    @DataBoundConstructor
    public CommandInstaller(String label, String command, String toolHome) {
        super(label, LineEndingConversion.convertEOL(command, LineEndingConversion.EOLType.Unix), toolHome);
    }

    @Override
    public String getCommandFileExtension() {
        return ".sh";
    }

    @Override
    public String[] getCommandCall(FilePath script) {
        String[] cmd = new String[]{"sh", "-e", script.getRemote()};
        return cmd;
    }

    private Object readResolve() throws ObjectStreamException {
        return new CommandInstaller(this.getLabel(), this.getCommand(), this.getToolHome());
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractCommandInstaller.Descriptor<CommandInstaller> {
        @Override
        public String getDisplayName() {
            return Messages.CommandInstaller_DescriptorImpl_displayName();
        }
    }
}

