/*
 * Decompiled with CFR 0.152.
 */
package hudson.tools;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.DownloadService;
import hudson.model.JDK;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tools.Messages;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolInstallerDescriptor;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import hudson.util.NoClientBindProtocolSocketFactory;
import hudson.util.NoClientBindSSLProtocolSocketFactory;
import hudson.util.Secret;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;

public class JDKInstaller
extends ToolInstaller {
    public final String id;
    public final boolean acceptLicense;
    private static final Logger LOGGER;

    @DataBoundConstructor
    public JDKInstaller(String id, boolean acceptLicense) {
        super(null);
        this.id = id;
        this.acceptLicense = acceptLicense;
    }

    @Override
    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener log) throws IOException, InterruptedException {
        FilePath expectedLocation = this.preferredLocation(tool, node);
        PrintStream out = log.getLogger();
        try {
            if (!this.acceptLicense) {
                out.println(Messages.JDKInstaller_UnableToInstallUntilLicenseAccepted());
                return expectedLocation;
            }
            FilePath marker = expectedLocation.child(".installedByHudson");
            if (marker.exists() && marker.readToString().equals(this.id)) {
                return expectedLocation;
            }
            expectedLocation.deleteRecursive();
            expectedLocation.mkdirs();
            Platform p = Platform.of(node);
            URL url = this.locate(log, p, CPU.of(node));
            FilePath file = expectedLocation.child(p.bundleFileName);
            file.copyFrom(url);
            this.install(node.createLauncher(log), p, new FilePathFileSystem(node), log, expectedLocation.absolutize().getRemote(), file.getRemote());
            file.delete();
            marker.write(this.id, null);
        }
        catch (DetectionFailedException e) {
            out.println("JDK installation skipped: " + e.getMessage());
        }
        return expectedLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void install(Launcher launcher, Platform p, FileSystem fs, TaskListener log, String expectedLocation, String jdkBundle) throws IOException, InterruptedException {
        PrintStream out = log.getLogger();
        out.println("Installing " + jdkBundle);
        FilePath parent = new FilePath(launcher.getChannel(), expectedLocation).getParent();
        switch (p) {
            case LINUX: 
            case SOLARIS: {
                Launcher.ProcStarter starter;
                byte[] header = new byte[2];
                DataInputStream in = new DataInputStream(fs.read(jdkBundle));
                try {
                    in.readFully(header);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                }
                if (header[0] == 31 && header[1] == -117) {
                    starter = launcher.launch().cmds("tar", "xvzf", jdkBundle);
                } else {
                    fs.chmod(jdkBundle, 493);
                    starter = launcher.launch().cmds(jdkBundle, "-noregister");
                }
                int exit = starter.stdin(new ByteArrayInputStream("yes".getBytes())).stdout(out).pwd(new FilePath(launcher.getChannel(), expectedLocation)).join();
                if (exit != 0) {
                    throw new AbortException(Messages.JDKInstaller_FailedToInstallJDK(exit));
                }
                List<String> paths = fs.listSubDirectories(expectedLocation);
                Iterator<String> itr = paths.iterator();
                while (itr.hasNext()) {
                    String s = itr.next();
                    if (s.matches("j(2s)?dk.*")) continue;
                    itr.remove();
                }
                if (paths.size() != 1) {
                    throw new AbortException("Failed to find the extracted JDKs: " + paths);
                }
                fs.pullUp(expectedLocation + '/' + paths.get(0), expectedLocation);
                return;
            }
            case WINDOWS: {
                expectedLocation = expectedLocation.trim();
                if (expectedLocation.endsWith("\\")) {
                    expectedLocation = expectedLocation.substring(0, expectedLocation.length() - 1);
                }
                String logFile = parent.createTempFile("install", "log").getRemote();
                ArgumentListBuilder args = new ArgumentListBuilder();
                assert (new File(expectedLocation).exists()) : expectedLocation + " must exist, otherwise /L will cause the installer to fail with error 1622";
                if (this.isJava15() || this.isJava14()) {
                    args.add("CMD.EXE", "/C");
                    args.add(jdkBundle + " /s /v\"/qn REBOOT=ReallySuppress INSTALLDIR=\\\"" + expectedLocation + "\\\" /L \\\"" + logFile + "\\\"\"");
                } else {
                    args.add(jdkBundle, "/s");
                    args.add("ADDLOCAL=\"ToolsFeature\"", "REBOOT=ReallySuppress", "INSTALLDIR=" + expectedLocation, "/L", logFile);
                }
                int r = launcher.launch().cmds(args).stdout(out).pwd(new FilePath(launcher.getChannel(), expectedLocation)).join();
                if (r != 0) {
                    out.println(Messages.JDKInstaller_FailedToInstallJDK(r));
                    try (InputStreamReader in = new InputStreamReader(fs.read(logFile), "UTF-16");){
                        IOUtils.copy((Reader)in, (Writer)new OutputStreamWriter(out));
                        throw new AbortException();
                    }
                }
                fs.delete(logFile);
                return;
            }
            case OSX: {
                FilePath dmg = parent.createTempDir("jdk", "dmg");
                int exit = launcher.launch().cmds("hdiutil", "attach", "-puppetstrings", "-mountpoint", dmg.getRemote(), jdkBundle).stdout(log).join();
                if (exit != 0) {
                    throw new AbortException(Messages.JDKInstaller_FailedToInstallJDK(exit));
                }
                FilePath[] list = dmg.list("*.pkg");
                if (list.length != 1) {
                    log.getLogger().println("JDK dmg bundle does not contain expected pkg installer");
                    throw new AbortException(Messages.JDKInstaller_FailedToInstallJDK(exit));
                }
                String installer = list[0].getRemote();
                FilePath pkg = parent.createTempDir("jdk", "pkg");
                pkg.deleteRecursive();
                exit = launcher.launch().cmds("pkgutil", "--expand", installer, pkg.getRemote()).stdout(log).join();
                if (exit != 0) {
                    throw new AbortException(Messages.JDKInstaller_FailedToInstallJDK(exit));
                }
                exit = launcher.launch().cmds("umount", dmg.getRemote()).stdout(log).join();
                if (exit != 0) {
                    throw new AbortException(Messages.JDKInstaller_FailedToInstallJDK(exit));
                }
                list = pkg.list("jdk*.pkg/Payload");
                if (list.length != 1) {
                    log.getLogger().println("JDK pkg installer does not contain expected JDK Payload archive");
                    throw new AbortException(Messages.JDKInstaller_FailedToInstallJDK(exit));
                }
                String payload = list[0].getRemote();
                exit = launcher.launch().pwd(parent).cmds("tar", "xzf", payload).stdout(log).join();
                if (exit != 0) {
                    throw new AbortException(Messages.JDKInstaller_FailedToInstallJDK(exit));
                }
                parent.child("Contents/Home").moveAllChildrenTo(new FilePath(launcher.getChannel(), expectedLocation));
                parent.child("Contents").deleteRecursive();
                pkg.deleteRecursive();
                dmg.deleteRecursive();
            }
        }
    }

    private boolean isJava15() {
        return this.id.contains("-1.5");
    }

    private boolean isJava14() {
        return this.id.contains("-1.4");
    }

    private File getLocalCacheFile(Platform platform, CPU cpu) {
        return new File(Jenkins.getInstance().getRootDir(), "cache/jdks/" + (Object)((Object)platform) + "/" + (Object)((Object)cpu) + "/" + this.id);
    }

    /*
     * Exception decompiling
     */
    public URL locate(TaskListener log, Platform platform, CPU cpu) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String extractAttribute(String s, String name) {
        String h = name + "=\"";
        int si = s.indexOf(h);
        if (si < 0) {
            return null;
        }
        int ei = s.indexOf(34, si + h.length());
        return s.substring(si + h.length(), ei);
    }

    private String getCredentialPageUrl() {
        return "/" + this.getDescriptor().getDescriptorUrl() + "/enterCredential";
    }

    @Override
    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    static {
        Protocol.registerProtocol((String)"http", (Protocol)new Protocol("http", (ProtocolSocketFactory)new NoClientBindProtocolSocketFactory(), 80));
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (SecureProtocolSocketFactory)new NoClientBindSSLProtocolSocketFactory(), 443));
        LOGGER = Logger.getLogger(JDKInstaller.class.getName());
    }

    @Extension
    public static final class JDKList
    extends DownloadService.Downloadable {
        public JDKList() {
            super(JDKInstaller.class);
        }

        public JDKFamilyList toList() throws IOException {
            JSONObject d = this.getData();
            if (d == null) {
                return new JDKFamilyList();
            }
            return (JDKFamilyList)JSONObject.toBean((JSONObject)d, JDKFamilyList.class);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends ToolInstallerDescriptor<JDKInstaller> {
        private String username;
        private Secret password;

        public DescriptorImpl() {
            this.load();
        }

        @Override
        public String getDisplayName() {
            return Messages.JDKInstaller_DescriptorImpl_displayName();
        }

        @Override
        public boolean isApplicable(Class<? extends ToolInstallation> toolType) {
            return toolType == JDK.class;
        }

        public String getUsername() {
            return this.username;
        }

        public Secret getPassword() {
            return this.password;
        }

        public FormValidation doCheckId(@QueryParameter String value) {
            if (Util.fixEmpty(value) == null) {
                return FormValidation.error(Messages.JDKInstaller_DescriptorImpl_doCheckId());
            }
            return FormValidation.ok();
        }

        public List<JDKFamily> getInstallableJDKs() throws IOException {
            return Arrays.asList(JDKList.all().get(JDKList.class).toList().data);
        }

        public FormValidation doCheckAcceptLicense(@QueryParameter boolean value) {
            if (this.username == null || this.password == null) {
                return FormValidation.errorWithMarkup(Messages.JDKInstaller_RequireOracleAccount(Stapler.getCurrentRequest().getContextPath() + '/' + this.getDescriptorUrl() + "/enterCredential"));
            }
            if (value) {
                return FormValidation.ok();
            }
            return FormValidation.error(Messages.JDKInstaller_DescriptorImpl_doCheckAcceptLicense());
        }

        public HttpResponse doPostCredential(@QueryParameter String username, @QueryParameter String password) throws IOException, ServletException {
            this.username = username;
            this.password = Secret.fromString(password);
            this.save();
            return HttpResponses.redirectTo((String)"credentialOK");
        }
    }

    public static final class JDKFile {
        public String name;
        public String title;
        public String filepath;
    }

    public static final class JDKRelease {
        public String name;
        public String title;
        public JDKFile[] files;

        public boolean matchesId(String rhs) {
            return rhs != null && (rhs.equals(this.name) || rhs.startsWith(this.name + "@"));
        }
    }

    public static final class JDKFamily {
        public String name;
        public JDKRelease[] releases;
    }

    public static final class JDKFamilyList {
        public int version;
        public JDKFamily[] data = new JDKFamily[0];

        public boolean isEmpty() {
            for (JDKFamily f : this.data) {
                if (f.releases.length <= 0) continue;
                return false;
            }
            return true;
        }

        public JDKRelease getRelease(String productCode) {
            for (JDKFamily f : this.data) {
                for (JDKRelease r : f.releases) {
                    if (!r.matchesId(productCode)) continue;
                    return r;
                }
            }
            return null;
        }
    }

    private static final class DetectionFailedException
    extends Exception {
        private DetectionFailedException(String message) {
            super(message);
        }
    }

    public static enum CPU {
        i386,
        amd64,
        Sparc,
        Itanium;


        public Preference accept(String line) {
            switch (this) {
                case Sparc: {
                    return CPU.must(line.contains("SPARC"));
                }
                case Itanium: {
                    return CPU.must(line.contains("IA64"));
                }
                case amd64: {
                    if (line.contains("SPARC") || line.contains("IA64")) {
                        return Preference.UNACCEPTABLE;
                    }
                    if (line.contains("64")) {
                        return Preference.PRIMARY;
                    }
                    return Preference.SECONDARY;
                }
                case i386: {
                    if (line.contains("64") || line.contains("SPARC") || line.contains("IA64")) {
                        return Preference.UNACCEPTABLE;
                    }
                    return Preference.PRIMARY;
                }
            }
            return Preference.UNACCEPTABLE;
        }

        private static Preference must(boolean b) {
            return b ? Preference.PRIMARY : Preference.UNACCEPTABLE;
        }

        public static CPU of(Node n) throws IOException, InterruptedException, DetectionFailedException {
            return (CPU)((Object)n.getChannel().call((Callable)new GetCurrentCPU()));
        }

        public static CPU current() throws DetectionFailedException {
            String arch = System.getProperty("os.arch").toLowerCase(Locale.ENGLISH);
            if (arch.contains("sparc")) {
                return Sparc;
            }
            if (arch.contains("ia64")) {
                return Itanium;
            }
            if (arch.contains("amd64") || arch.contains("86_64")) {
                return amd64;
            }
            if (arch.contains("86")) {
                return i386;
            }
            throw new DetectionFailedException("Unknown CPU architecture: " + arch);
        }

        static class GetCurrentCPU
        extends MasterToSlaveCallable<CPU, DetectionFailedException> {
            private static final long serialVersionUID = 1L;

            GetCurrentCPU() {
            }

            public CPU call() throws DetectionFailedException {
                return CPU.current();
            }
        }
    }

    public static enum Platform {
        LINUX("jdk.sh"),
        SOLARIS("jdk.sh"),
        WINDOWS("jdk.exe"),
        OSX("jdk.dmg");

        public final String bundleFileName;

        private Platform(String bundleFileName) {
            this.bundleFileName = bundleFileName;
        }

        public boolean is(String line) {
            return line.contains(this.name());
        }

        public static Platform of(Node n) throws IOException, InterruptedException, DetectionFailedException {
            return (Platform)((Object)n.getChannel().call((Callable)new GetCurrentPlatform()));
        }

        public static Platform current() throws DetectionFailedException {
            String arch = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
            if (arch.contains("linux")) {
                return LINUX;
            }
            if (arch.contains("windows")) {
                return WINDOWS;
            }
            if (arch.contains("sun") || arch.contains("solaris")) {
                return SOLARIS;
            }
            if (arch.contains("mac")) {
                return OSX;
            }
            throw new DetectionFailedException("Unknown CPU name: " + arch);
        }

        static class GetCurrentPlatform
        extends MasterToSlaveCallable<Platform, DetectionFailedException> {
            private static final long serialVersionUID = 1L;

            GetCurrentPlatform() {
            }

            public Platform call() throws DetectionFailedException {
                return Platform.current();
            }
        }
    }

    public static enum Preference {
        PRIMARY,
        SECONDARY,
        UNACCEPTABLE;

    }

    static final class FilePathFileSystem
    implements FileSystem {
        private final Node node;

        FilePathFileSystem(Node node) {
            this.node = node;
        }

        @Override
        public void delete(String file) throws IOException, InterruptedException {
            this.$(file).delete();
        }

        @Override
        public void chmod(String file, int mode) throws IOException, InterruptedException {
            this.$(file).chmod(mode);
        }

        @Override
        public InputStream read(String file) throws IOException, InterruptedException {
            return this.$(file).read();
        }

        @Override
        public List<String> listSubDirectories(String dir) throws IOException, InterruptedException {
            ArrayList<String> r = new ArrayList<String>();
            for (FilePath f : this.$(dir).listDirectories()) {
                r.add(f.getName());
            }
            return r;
        }

        @Override
        public void pullUp(String from, String to) throws IOException, InterruptedException {
            this.$(from).moveAllChildrenTo(this.$(to));
        }

        private FilePath $(String file) {
            return this.node.createPath(file);
        }
    }

    public static interface FileSystem {
        public void delete(String var1) throws IOException, InterruptedException;

        public void chmod(String var1, int var2) throws IOException, InterruptedException;

        public InputStream read(String var1) throws IOException, InterruptedException;

        public List<String> listSubDirectories(String var1) throws IOException, InterruptedException;

        public void pullUp(String var1, String var2) throws IOException, InterruptedException;
    }
}

