/*
 * Decompiled with CFR 0.152.
 */
package hudson.tools;

import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstallerDescriptor;
import java.io.File;
import java.io.IOException;
import jenkins.model.Jenkins;

public abstract class ToolInstaller
implements Describable<ToolInstaller>,
ExtensionPoint {
    private final String label;
    protected transient ToolInstallation tool;

    protected ToolInstaller(String label) {
        this.label = Util.fixEmptyAndTrim(label);
    }

    protected void setTool(ToolInstallation t) {
        this.tool = t;
    }

    public final String getLabel() {
        return this.label;
    }

    public boolean appliesTo(Node node) {
        Label l = Jenkins.getInstance().getLabel(this.label);
        return l == null || l.contains(node);
    }

    public abstract FilePath performInstallation(ToolInstallation var1, Node var2, TaskListener var3) throws IOException, InterruptedException;

    protected final FilePath preferredLocation(ToolInstallation tool, Node node) {
        FilePath root;
        if (node == null) {
            throw new IllegalArgumentException("must pass non-null node");
        }
        String home = Util.fixEmptyAndTrim(tool.getHome());
        if (home == null) {
            home = this.sanitize(tool.getDescriptor().getId()) + File.separatorChar + this.sanitize(tool.getName());
        }
        if ((root = node.getRootPath()) == null) {
            throw new IllegalArgumentException("Node " + node.getDisplayName() + " seems to be offline");
        }
        return root.child("tools").child(home);
    }

    private String sanitize(String s) {
        return s != null ? s.replaceAll("[^A-Za-z0-9_.-]+", "_") : null;
    }

    @Override
    public ToolInstallerDescriptor<?> getDescriptor() {
        return (ToolInstallerDescriptor)Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }
}

