/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.trilead.ssh2.crypto.Base64;
import hudson.Util;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import jenkins.model.Jenkins;
import jenkins.security.CryptoConfidentialKey;
import org.kohsuke.stapler.Stapler;

public final class Secret
implements Serializable {
    private final String value;
    private static final String MAGIC = "::::MAGIC::::";
    private static final String PROVIDER = System.getProperty(Secret.class.getName() + ".provider");
    static String SECRET = null;
    private static final CryptoConfidentialKey KEY = new CryptoConfidentialKey(Secret.class.getName());
    private static final long serialVersionUID = 1L;

    private Secret(String value) {
        this.value = value;
    }

    @Deprecated
    public String toString() {
        return this.value;
    }

    public String getPlainText() {
        return this.value;
    }

    public boolean equals(Object that) {
        return that instanceof Secret && this.value.equals(((Secret)that).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Deprecated
    static SecretKey getLegacyKey() throws GeneralSecurityException {
        String secret = SECRET;
        if (secret == null) {
            return Jenkins.getInstance().getSecretKeyAsAES128();
        }
        return Util.toAes128Key(secret);
    }

    public String getEncryptedValue() {
        try {
            Cipher cipher = KEY.encrypt();
            return new String(Base64.encode((byte[])cipher.doFinal((this.value + MAGIC).getBytes("UTF-8"))));
        }
        catch (GeneralSecurityException e) {
            throw new Error(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public static Secret decrypt(String data) {
        if (data == null) {
            return null;
        }
        try {
            byte[] in = Base64.decode((char[])data.toCharArray());
            Secret s = Secret.tryDecrypt(KEY.decrypt(), in);
            if (s != null) {
                return s;
            }
            Cipher cipher = Secret.getCipher("AES");
            cipher.init(2, Secret.getLegacyKey());
            return Secret.tryDecrypt(cipher, in);
        }
        catch (GeneralSecurityException e) {
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        catch (IOException e) {
            return null;
        }
    }

    static Secret tryDecrypt(Cipher cipher, byte[] in) throws UnsupportedEncodingException {
        try {
            String plainText = new String(cipher.doFinal(in), "UTF-8");
            if (plainText.endsWith(MAGIC)) {
                return new Secret(plainText.substring(0, plainText.length() - MAGIC.length()));
            }
            return null;
        }
        catch (GeneralSecurityException e) {
            return null;
        }
    }

    public static Cipher getCipher(String algorithm) throws GeneralSecurityException {
        return PROVIDER != null ? Cipher.getInstance(algorithm, PROVIDER) : Cipher.getInstance(algorithm);
    }

    public static Secret fromString(String data) {
        Secret s = Secret.decrypt(data = Util.fixNull(data));
        if (s == null) {
            s = new Secret(data);
        }
        return s;
    }

    public static String toString(Secret s) {
        return s == null ? "" : s.value;
    }

    static {
        Stapler.CONVERT_UTILS.register(new org.apache.commons.beanutils.Converter(){

            public Secret convert(Class type, Object value) {
                return Secret.fromString(value.toString());
            }
        }, Secret.class);
    }

    public static final class ConverterImpl
    implements Converter {
        public boolean canConvert(Class type) {
            return type == Secret.class;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            Secret src = (Secret)source;
            writer.setValue(src.getEncryptedValue());
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            return Secret.fromString(reader.getValue());
        }
    }
}

