/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import hudson.PluginManager;
import java.lang.reflect.Constructor;
import jenkins.model.Jenkins;
import org.kohsuke.asm5.ClassWriter;
import org.kohsuke.asm5.MethodVisitor;
import org.kohsuke.asm5.Type;

public class SubClassGenerator
extends ClassLoader {
    public SubClassGenerator(ClassLoader parent) {
        super(parent);
    }

    public <T> Class<? extends T> generate(Class<T> base, String name) {
        ClassWriter cw = new ClassWriter(0);
        cw.visit(49, 1, name.replace('.', '/'), null, Type.getInternalName(base), null);
        for (Constructor<?> c : base.getDeclaredConstructors()) {
            Class<?>[] et = c.getExceptionTypes();
            String[] exceptions = new String[et.length];
            for (int i = 0; i < et.length; ++i) {
                exceptions[i] = Type.getInternalName(et[i]);
            }
            String methodDescriptor = this.getMethodDescriptor(c);
            MethodVisitor m = cw.visitMethod(c.getModifiers(), "<init>", methodDescriptor, null, exceptions);
            m.visitCode();
            int index = 1;
            m.visitVarInsn(25, 0);
            for (Class<?> param : c.getParameterTypes()) {
                Type t = Type.getType(param);
                m.visitVarInsn(t.getOpcode(21), index);
                index += t.getSize();
            }
            m.visitMethodInsn(183, Type.getInternalName(base), "<init>", methodDescriptor);
            m.visitInsn(177);
            m.visitMaxs(index, index);
            m.visitEnd();
        }
        cw.visitEnd();
        byte[] image = cw.toByteArray();
        Class<T> c = this.defineClass(name, image, 0, image.length).asSubclass(base);
        Jenkins h = Jenkins.getInstance();
        if (h != null) {
            ((PluginManager.UberClassLoader)h.pluginManager.uberClassLoader).addNamedClass(name, c);
        }
        return c;
    }

    private String getMethodDescriptor(Constructor c) {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        for (Class<?> p : c.getParameterTypes()) {
            buf.append(Type.getDescriptor(p));
        }
        buf.append(")V");
        return buf.toString();
    }
}

