/*
 * Decompiled with CFR 0.152.
 */
package hudson.util.spring;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyShell;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import hudson.util.spring.BeanConfiguration;
import hudson.util.spring.ClosureScript;
import hudson.util.spring.DefaultBeanConfiguration;
import hudson.util.spring.DefaultRuntimeSpringConfiguration;
import hudson.util.spring.RuntimeSpringConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.web.context.WebApplicationContext;

public class BeanBuilder
extends GroovyObjectSupport {
    private static final String ANONYMOUS_BEAN = "bean";
    private RuntimeSpringConfiguration springConfig = new DefaultRuntimeSpringConfiguration();
    private BeanConfiguration currentBeanConfig;
    private Map<String, DeferredProperty> deferredProperties = new HashMap<String, DeferredProperty>();
    private ApplicationContext parentCtx;
    private Map binding = new HashMap();
    private ClassLoader classLoader = null;

    public BeanBuilder() {
    }

    public BeanBuilder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public BeanBuilder(ApplicationContext parent) {
        this.parentCtx = parent;
        this.springConfig = new DefaultRuntimeSpringConfiguration(parent);
    }

    public BeanBuilder(ApplicationContext parent, ClassLoader classLoader) {
        this.parentCtx = parent;
        this.springConfig = new DefaultRuntimeSpringConfiguration(parent);
        this.classLoader = classLoader;
    }

    public void parse(InputStream script) {
        this.parse(script, new Binding());
    }

    public void parse(InputStream script, Binding binding) {
        if (script == null) {
            throw new IllegalArgumentException("No script is provided");
        }
        this.setBinding(binding);
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.setScriptBaseClass(ClosureScript.class.getName());
        GroovyShell shell = new GroovyShell(this.classLoader, binding, cc);
        ClosureScript s = (ClosureScript)shell.parse(script);
        s.setDelegate((GroovyObject)this);
        s.run();
    }

    public ApplicationContext getParentCtx() {
        return this.parentCtx;
    }

    public RuntimeSpringConfiguration getSpringConfig() {
        return this.springConfig;
    }

    public BeanDefinition getBeanDefinition(String name) {
        if (!this.getSpringConfig().containsBean(name)) {
            return null;
        }
        return this.getSpringConfig().getBeanConfig(name).getBeanDefinition();
    }

    public Map<String, BeanDefinition> getBeanDefinitions() {
        HashMap<String, BeanDefinition> beanDefinitions = new HashMap<String, BeanDefinition>();
        for (String beanName : this.getSpringConfig().getBeanNames()) {
            AbstractBeanDefinition bd = this.getSpringConfig().getBeanConfig(beanName).getBeanDefinition();
            beanDefinitions.put(beanName, (BeanDefinition)bd);
        }
        return beanDefinitions;
    }

    public void setSpringConfig(RuntimeSpringConfiguration springConfig) {
        this.springConfig = springConfig;
    }

    public void loadBeans(String resourcePattern) throws IOException {
        this.loadBeans(new PathMatchingResourcePatternResolver().getResources(resourcePattern));
    }

    public void loadBeans(Resource resource) throws IOException {
        this.loadBeans(new Resource[]{resource});
    }

    public void loadBeans(Resource[] resources) throws IOException {
        Closure beans = new Closure((Object)this){

            public Object call(Object ... args) {
                return BeanBuilder.this.beans((Closure)args[0]);
            }
        };
        Binding b = new Binding();
        b.setVariable("beans", (Object)beans);
        GroovyShell shell = this.classLoader != null ? new GroovyShell(this.classLoader, b) : new GroovyShell(b);
        for (Resource resource : resources) {
            shell.evaluate(resource.getInputStream());
        }
    }

    public void registerBeans(StaticApplicationContext ctx) {
        this.finalizeDeferredProperties();
        this.springConfig.registerBeansWithContext(ctx);
    }

    public RuntimeBeanReference ref(String refName) {
        return this.ref(refName, false);
    }

    public RuntimeBeanReference parentRef(String refName) {
        return this.ref(refName, true);
    }

    public RuntimeBeanReference ref(String refName, boolean parentRef) {
        return new RuntimeBeanReference(refName, parentRef);
    }

    public Object methodMissing(String name, Object arg) {
        Object[] args = (Object[])arg;
        if (args.length == 0) {
            throw new MissingMethodException(name, ((Object)((Object)this)).getClass(), args);
        }
        if (args[0] instanceof Closure) {
            return this.invokeBeanDefiningMethod(name, args);
        }
        if (args[0] instanceof Class || args[0] instanceof RuntimeBeanReference || args[0] instanceof Map) {
            return this.invokeBeanDefiningMethod(name, args);
        }
        if (args.length > 1 && args[args.length - 1] instanceof Closure) {
            return this.invokeBeanDefiningMethod(name, args);
        }
        WebApplicationContext ctx = this.springConfig.getUnrefreshedApplicationContext();
        MetaClass mc = DefaultGroovyMethods.getMetaClass((Object)ctx);
        if (!mc.respondsTo((Object)ctx, name, args).isEmpty()) {
            return mc.invokeMethod((Object)ctx, name, args);
        }
        return this;
    }

    public WebApplicationContext createApplicationContext() {
        this.finalizeDeferredProperties();
        return this.springConfig.getApplicationContext();
    }

    private void finalizeDeferredProperties() {
        for (DeferredProperty dp : this.deferredProperties.values()) {
            if (dp.value instanceof List) {
                dp.value = this.manageListIfNecessary((List)dp.value);
            } else if (dp.value instanceof Map) {
                dp.value = this.manageMapIfNecessary((Map)dp.value);
            }
            dp.setInBeanConfig();
        }
        this.deferredProperties.clear();
    }

    private boolean addToDeferred(BeanConfiguration beanConfig, String property, Object newValue) {
        if (newValue instanceof List) {
            this.deferredProperties.put(this.currentBeanConfig.getName() + property, new DeferredProperty(this.currentBeanConfig, property, newValue));
            return true;
        }
        if (newValue instanceof Map) {
            this.deferredProperties.put(this.currentBeanConfig.getName() + property, new DeferredProperty(this.currentBeanConfig, property, newValue));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BeanConfiguration invokeBeanDefiningMethod(String name, Object[] args) {
        BeanConfiguration old = this.currentBeanConfig;
        try {
            if (args[0] instanceof Class) {
                Class<?> beanClass;
                Class<?> clazz = beanClass = args[0] instanceof Class ? (Class<?>)args[0] : args[0].getClass();
                if (args.length >= 1) {
                    if (args[args.length - 1] instanceof Closure) {
                        if (args.length - 1 != 1) {
                            Object[] constructorArgs = ArrayUtils.subarray((Object[])args, (int)1, (int)(args.length - 1));
                            this.filterGStringReferences(constructorArgs);
                            this.currentBeanConfig = name.equals(ANONYMOUS_BEAN) ? this.springConfig.createSingletonBean(beanClass, Arrays.asList(constructorArgs)) : this.springConfig.addSingletonBean(name, beanClass, Arrays.asList(constructorArgs));
                        } else {
                            this.currentBeanConfig = name.equals(ANONYMOUS_BEAN) ? this.springConfig.createSingletonBean(beanClass) : this.springConfig.addSingletonBean(name, beanClass);
                        }
                    } else {
                        Object[] constructorArgs = ArrayUtils.subarray((Object[])args, (int)1, (int)args.length);
                        this.filterGStringReferences(constructorArgs);
                        this.currentBeanConfig = name.equals(ANONYMOUS_BEAN) ? this.springConfig.createSingletonBean(beanClass, Arrays.asList(constructorArgs)) : this.springConfig.addSingletonBean(name, beanClass, Arrays.asList(constructorArgs));
                    }
                }
            } else if (args[0] instanceof RuntimeBeanReference) {
                this.currentBeanConfig = this.springConfig.addSingletonBean(name);
                this.currentBeanConfig.setFactoryBean(((RuntimeBeanReference)args[0]).getBeanName());
            } else if (args[0] instanceof Map) {
                this.currentBeanConfig = this.springConfig.addSingletonBean(name);
                Map.Entry factoryBeanEntry = ((Map)args[0]).entrySet().iterator().next();
                this.currentBeanConfig.setFactoryBean(factoryBeanEntry.getKey().toString());
                this.currentBeanConfig.setFactoryMethod(factoryBeanEntry.getValue().toString());
            } else if (args[0] instanceof Closure) {
                this.currentBeanConfig = this.springConfig.addAbstractBean(name);
            } else {
                Object[] constructorArgs = args[args.length - 1] instanceof Closure ? ArrayUtils.subarray((Object[])args, (int)0, (int)(args.length - 1)) : ArrayUtils.subarray((Object[])args, (int)0, (int)args.length);
                this.filterGStringReferences(constructorArgs);
                this.currentBeanConfig = new DefaultBeanConfiguration(name, null, Arrays.asList(constructorArgs));
                this.springConfig.addBeanConfiguration(name, this.currentBeanConfig);
            }
            if (args[args.length - 1] instanceof Closure) {
                Closure callable = (Closure)args[args.length - 1];
                callable.setDelegate((Object)this);
                callable.setResolveStrategy(1);
                callable.call(new Object[]{this.currentBeanConfig});
            }
            BeanConfiguration beanConfiguration = this.currentBeanConfig;
            return beanConfiguration;
        }
        finally {
            this.currentBeanConfig = old;
        }
    }

    private void filterGStringReferences(Object[] constructorArgs) {
        for (int i = 0; i < constructorArgs.length; ++i) {
            Object constructorArg = constructorArgs[i];
            if (!(constructorArg instanceof GString)) continue;
            constructorArgs[i] = constructorArg.toString();
        }
    }

    public BeanBuilder beans(Closure callable) {
        callable.setDelegate((Object)this);
        callable.call();
        this.finalizeDeferredProperties();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String name, Object value) {
        if (this.currentBeanConfig != null) {
            if (value instanceof GString) {
                value = value.toString();
            }
            if (this.addToDeferred(this.currentBeanConfig, name, value)) {
                return;
            }
            if (value instanceof Closure) {
                BeanConfiguration current = this.currentBeanConfig;
                try {
                    Closure callable = (Closure)value;
                    Class parameterType = callable.getParameterTypes()[0];
                    if (parameterType.equals(Object.class)) {
                        this.currentBeanConfig = this.springConfig.createSingletonBean("");
                        callable.call(new Object[]{this.currentBeanConfig});
                    } else {
                        this.currentBeanConfig = this.springConfig.createSingletonBean(parameterType);
                        callable.call(null);
                    }
                    value = this.currentBeanConfig.getBeanDefinition();
                }
                finally {
                    this.currentBeanConfig = current;
                }
            }
            this.currentBeanConfig.addProperty(name, value);
        } else {
            this.binding.put(name, value);
        }
    }

    private Object manageMapIfNecessary(Map<Object, Object> value) {
        boolean containsRuntimeRefs = false;
        for (Map.Entry<Object, Object> e : value.entrySet()) {
            Object v = e.getValue();
            if (v instanceof RuntimeBeanReference) {
                containsRuntimeRefs = true;
            }
            if (!(v instanceof BeanConfiguration)) continue;
            BeanConfiguration c = (BeanConfiguration)v;
            e.setValue(c.getBeanDefinition());
            containsRuntimeRefs = true;
        }
        if (containsRuntimeRefs) {
            ManagedMap m = new ManagedMap();
            m.putAll(value);
            return m;
        }
        return value;
    }

    private Object manageListIfNecessary(List<Object> value) {
        boolean containsRuntimeRefs = false;
        ListIterator<Object> i = value.listIterator();
        while (i.hasNext()) {
            Object e = i.next();
            if (e instanceof RuntimeBeanReference) {
                containsRuntimeRefs = true;
            }
            if (!(e instanceof BeanConfiguration)) continue;
            BeanConfiguration c = (BeanConfiguration)e;
            i.set(c.getBeanDefinition());
            containsRuntimeRefs = true;
        }
        if (containsRuntimeRefs) {
            ManagedList tmp = new ManagedList();
            tmp.addAll(value);
            value = tmp;
        }
        return value;
    }

    public Object getProperty(String name) {
        if (this.binding.containsKey(name)) {
            return this.binding.get(name);
        }
        if (this.springConfig.containsBean(name)) {
            BeanConfiguration beanConfig = this.springConfig.getBeanConfig(name);
            if (beanConfig != null) {
                return new ConfigurableRuntimeBeanReference(name, this.springConfig.getBeanConfig(name), false);
            }
            return new RuntimeBeanReference(name, false);
        }
        if (this.currentBeanConfig != null) {
            if (this.currentBeanConfig.hasProperty(name)) {
                return this.currentBeanConfig.getPropertyValue(name);
            }
            DeferredProperty dp = this.deferredProperties.get(this.currentBeanConfig.getName() + name);
            if (dp != null) {
                return dp.value;
            }
            return super.getProperty(name);
        }
        return super.getProperty(name);
    }

    public void setBinding(Binding b) {
        this.binding = b.getVariables();
    }

    private class ConfigurableRuntimeBeanReference
    extends RuntimeBeanReference
    implements GroovyObject {
        private MetaClass metaClass;
        private BeanConfiguration beanConfig;

        public ConfigurableRuntimeBeanReference(String beanName, BeanConfiguration beanConfig) {
            this(beanName, beanConfig, false);
        }

        public ConfigurableRuntimeBeanReference(String beanName, BeanConfiguration beanConfig, boolean toParent) {
            super(beanName, toParent);
            this.beanConfig = beanConfig;
            if (beanConfig == null) {
                throw new IllegalArgumentException("Argument [beanConfig] cannot be null");
            }
            this.metaClass = InvokerHelper.getMetaClass((Object)((Object)this));
        }

        public MetaClass getMetaClass() {
            return this.metaClass;
        }

        public Object getProperty(String property) {
            if (property.equals("beanName")) {
                return this.getBeanName();
            }
            if (property.equals("source")) {
                return this.getSource();
            }
            if (this.beanConfig != null) {
                return new WrappedPropertyValue(property, this.beanConfig.getPropertyValue(property));
            }
            return this.metaClass.getProperty((Object)this, property);
        }

        public Object invokeMethod(String name, Object args) {
            return this.metaClass.invokeMethod((Object)this, name, args);
        }

        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public void setProperty(String property, Object newValue) {
            if (!BeanBuilder.this.addToDeferred(this.beanConfig, property, newValue)) {
                this.beanConfig.setPropertyValue(property, newValue);
            }
        }

        private class WrappedPropertyValue
        extends GroovyObjectSupport {
            private Object propertyValue;
            private String propertyName;

            public WrappedPropertyValue(String propertyName, Object propertyValue) {
                this.propertyValue = propertyValue;
                this.propertyName = propertyName;
            }

            public void leftShift(Object value) {
                InvokerHelper.invokeMethod((Object)this.propertyValue, (String)"leftShift", (Object)value);
                if (value instanceof RuntimeBeanReference) {
                    BeanBuilder.this.deferredProperties.put(ConfigurableRuntimeBeanReference.this.beanConfig.getName(), new DeferredProperty(ConfigurableRuntimeBeanReference.this.beanConfig, this.propertyName, this.propertyValue));
                }
            }
        }
    }

    private static class DeferredProperty {
        private BeanConfiguration config;
        private String name;
        private Object value;

        DeferredProperty(BeanConfiguration config, String name, Object value) {
            this.config = config;
            this.name = name;
            this.value = value;
        }

        public void setInBeanConfig() {
            this.config.addProperty(this.name, this.value);
        }
    }
}

