/*
 * Decompiled with CFR 0.152.
 */
package hudson.widgets;

import hudson.model.Queue;
import hudson.widgets.HistoryWidget;
import java.util.LinkedList;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.widgets.HistoryPageFilter;
import org.apache.commons.collections.IteratorUtils;

public class BuildHistoryWidget<T>
extends HistoryWidget<Queue.Task, T> {
    public BuildHistoryWidget(Queue.Task owner, Iterable<T> baseList, HistoryWidget.Adapter<? super T> adapter) {
        super(owner, baseList, adapter);
    }

    public Queue.Item getQueuedItem() {
        return Jenkins.getInstance().getQueue().getItem((Queue.Task)this.owner);
    }

    public List<Queue.Item> getQueuedItems() {
        LinkedList<Queue.Item> list = new LinkedList<Queue.Item>();
        for (Queue.Item item : Jenkins.getInstance().getQueue().getApproximateItemsQuickly()) {
            if (item.task != this.owner) continue;
            list.addFirst(item);
        }
        return list;
    }

    @Override
    public HistoryPageFilter getHistoryPageFilter() {
        HistoryPageFilter historyPageFilter = this.newPageFilter();
        LinkedList<Queue.Item> items = new LinkedList<Queue.Item>();
        items.addAll(this.getQueuedItems());
        items.addAll(IteratorUtils.toList(this.baseList.iterator()));
        historyPageFilter.add(items);
        historyPageFilter.widget = this;
        return historyPageFilter;
    }
}

