/*
 * Decompiled with CFR 0.152.
 */
package hudson.widgets;

import hudson.Functions;
import hudson.model.ModelObject;
import hudson.widgets.Messages;
import hudson.widgets.Widget;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.widgets.HistoryPageEntry;
import jenkins.widgets.HistoryPageFilter;
import org.apache.commons.collections.IteratorUtils;
import org.kohsuke.stapler.Header;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class HistoryWidget<O extends ModelObject, T>
extends Widget {
    public Iterable<T> baseList;
    private String nextBuildNumberToFetch;
    public final String baseUrl;
    public final O owner;
    private boolean trimmed;
    public final Adapter<? super T> adapter;
    final Long newerThan;
    final Long olderThan;
    final String searchString;
    private String firstTransientBuildKey;
    static final int THRESHOLD = Integer.getInteger(HistoryWidget.class.getName() + ".threshold", 30);

    public HistoryWidget(O owner, Iterable<T> baseList, Adapter<? super T> adapter) {
        StaplerRequest currentRequest = Stapler.getCurrentRequest();
        this.adapter = adapter;
        this.baseList = baseList;
        this.baseUrl = Functions.getNearestAncestorUrl(currentRequest, owner);
        this.owner = owner;
        this.newerThan = this.getPagingParam(currentRequest, "newer-than");
        this.olderThan = this.getPagingParam(currentRequest, "older-than");
        this.searchString = currentRequest.getParameter("search");
    }

    public String getDisplayName() {
        return Messages.BuildHistoryWidget_DisplayName();
    }

    @Override
    public String getUrlName() {
        return "buildHistory";
    }

    public String getFirstTransientBuildKey() {
        return this.firstTransientBuildKey;
    }

    private Iterable<HistoryPageEntry<T>> updateFirstTransientBuildKey(Iterable<HistoryPageEntry<T>> source) {
        String key = null;
        for (HistoryPageEntry<T> t : source) {
            if (!this.adapter.isBuilding(t.getEntry())) continue;
            key = this.adapter.getKey(t.getEntry());
        }
        this.firstTransientBuildKey = key;
        return source;
    }

    public Iterable<HistoryPageEntry<T>> getRenderList() {
        if (this.trimmed) {
            List<HistoryPageEntry<T>> pageEntries = this.toPageEntries(this.baseList);
            if (pageEntries.size() > THRESHOLD) {
                return this.updateFirstTransientBuildKey(pageEntries.subList(0, THRESHOLD));
            }
            this.trimmed = false;
            return this.updateFirstTransientBuildKey(pageEntries);
        }
        return this.updateFirstTransientBuildKey(this.toPageEntries(this.baseList));
    }

    private List<HistoryPageEntry<T>> toPageEntries(Iterable<T> historyItemList) {
        Iterator<T> iterator = historyItemList.iterator();
        if (!iterator.hasNext()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<HistoryPageEntry<T>> pageEntries = new ArrayList<HistoryPageEntry<T>>();
        while (iterator.hasNext()) {
            pageEntries.add(new HistoryPageEntry<T>(iterator.next()));
        }
        return pageEntries;
    }

    public HistoryPageFilter getHistoryPageFilter() {
        HistoryPageFilter<T> historyPageFilter = this.newPageFilter();
        historyPageFilter.add(IteratorUtils.toList(this.baseList.iterator()));
        historyPageFilter.widget = this;
        return historyPageFilter;
    }

    protected HistoryPageFilter<T> newPageFilter() {
        HistoryPageFilter historyPageFilter = new HistoryPageFilter(THRESHOLD);
        if (this.newerThan != null) {
            historyPageFilter.setNewerThan(this.newerThan);
        } else if (this.olderThan != null) {
            historyPageFilter.setOlderThan(this.olderThan);
        }
        if (this.searchString != null) {
            historyPageFilter.setSearchString(this.searchString);
        }
        return historyPageFilter;
    }

    public boolean isTrimmed() {
        return this.trimmed;
    }

    public void setTrimmed(boolean trimmed) {
        this.trimmed = trimmed;
    }

    public void doAjax(StaplerRequest req, StaplerResponse rsp, @Header(value="n") String n) throws IOException, ServletException {
        rsp.setContentType("text/html;charset=UTF-8");
        ArrayList<T> items = new ArrayList<T>();
        if (n != null) {
            String nn = null;
            for (T t : this.baseList) {
                if (this.adapter.compare(t, n) < 0) break;
                items.add(t);
                if (!this.adapter.isBuilding(t)) continue;
                nn = this.adapter.getKey(t);
            }
            if (nn == null) {
                nn = items.isEmpty() ? n : this.adapter.getNextKey(this.adapter.getKey(items.get(0)));
            }
            this.baseList = items;
            rsp.setHeader("n", nn);
            this.firstTransientBuildKey = nn;
        }
        HistoryPageFilter page = this.getHistoryPageFilter();
        this.updateFirstTransientBuildKey(page.runs);
        req.getView((Object)page, "ajaxBuildHistory.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public String getNextBuildNumberToFetch() {
        return this.nextBuildNumberToFetch;
    }

    public void setNextBuildNumberToFetch(String nextBuildNumberToFetch) {
        this.nextBuildNumberToFetch = nextBuildNumberToFetch;
    }

    private Long getPagingParam(@CheckForNull StaplerRequest currentRequest, @CheckForNull String name) {
        if (currentRequest == null || name == null) {
            return null;
        }
        String paramVal = currentRequest.getParameter(name);
        if (paramVal == null) {
            return null;
        }
        try {
            return new Long(paramVal);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static interface Adapter<T> {
        public int compare(T var1, String var2);

        public String getKey(T var1);

        public boolean isBuilding(T var1);

        public String getNextKey(String var1);
    }
}

