/*
 * Decompiled with CFR 0.152.
 */
package jenkins;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class ClassLoaderReflectionToolkit {
    private static final Method FIND_CLASS;
    private static final Method FIND_LOADED_CLASS;
    private static final Method FIND_RESOURCE;
    private static final Method FIND_RESOURCES;
    private static final Method GET_CLASS_LOADING_LOCK;

    private static <T extends Exception> Object invoke(Method method, Class<T> exception, Object obj, Object ... args) throws T {
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException x) {
            throw new AssertionError((Object)x);
        }
        catch (InvocationTargetException x) {
            Throwable x2 = x.getCause();
            if (x2 instanceof RuntimeException) {
                throw (RuntimeException)x2;
            }
            if (x2 instanceof Error) {
                throw (Error)x2;
            }
            if (exception.isInstance(x2)) {
                throw (Exception)exception.cast(x2);
            }
            throw new AssertionError((Object)x2);
        }
    }

    private static Object getClassLoadingLock(ClassLoader cl, String name) {
        if (GET_CLASS_LOADING_LOCK != null) {
            return ClassLoaderReflectionToolkit.invoke(GET_CLASS_LOADING_LOCK, RuntimeException.class, cl, name);
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public static Class<?> _findLoadedClass(ClassLoader cl, String name) {
        Object object = ClassLoaderReflectionToolkit.getClassLoadingLock(cl, name);
        synchronized (object) {
            return (Class)ClassLoaderReflectionToolkit.invoke(FIND_LOADED_CLASS, RuntimeException.class, cl, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static Class<?> _findClass(ClassLoader cl, String name) throws ClassNotFoundException {
        Object object = ClassLoaderReflectionToolkit.getClassLoadingLock(cl, name);
        synchronized (object) {
            return (Class)ClassLoaderReflectionToolkit.invoke(FIND_CLASS, ClassNotFoundException.class, cl, name);
        }
    }

    @CheckForNull
    public static URL _findResource(ClassLoader cl, String name) {
        return (URL)ClassLoaderReflectionToolkit.invoke(FIND_RESOURCE, RuntimeException.class, cl, name);
    }

    @Nonnull
    public static Enumeration<URL> _findResources(ClassLoader cl, String name) throws IOException {
        return (Enumeration)ClassLoaderReflectionToolkit.invoke(FIND_RESOURCES, IOException.class, cl, name);
    }

    @Deprecated
    public ClassLoaderReflectionToolkit() {
    }

    @Deprecated
    public Class findLoadedClass(ClassLoader cl, String name) throws InvocationTargetException {
        try {
            return (Class)FIND_LOADED_CLASS.invoke((Object)cl, name);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    @Deprecated
    public Class findClass(ClassLoader cl, String name) throws InvocationTargetException {
        try {
            return (Class)FIND_CLASS.invoke((Object)cl, name);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    @Deprecated
    public URL findResource(ClassLoader cl, String name) throws InvocationTargetException {
        try {
            return (URL)FIND_RESOURCE.invoke((Object)cl, name);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    @Deprecated
    public Enumeration<URL> findResources(ClassLoader cl, String name) throws InvocationTargetException {
        try {
            return (Enumeration)FIND_RESOURCES.invoke((Object)cl, name);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    static {
        try {
            FIND_CLASS = ClassLoader.class.getDeclaredMethod("findClass", String.class);
            FIND_CLASS.setAccessible(true);
            FIND_LOADED_CLASS = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            FIND_LOADED_CLASS.setAccessible(true);
            FIND_RESOURCE = ClassLoader.class.getDeclaredMethod("findResource", String.class);
            FIND_RESOURCE.setAccessible(true);
            FIND_RESOURCES = ClassLoader.class.getDeclaredMethod("findResources", String.class);
            FIND_RESOURCES.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        Method gCLL = null;
        try {
            gCLL = ClassLoader.class.getDeclaredMethod("getClassLoadingLock", String.class);
            gCLL.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        GET_CLASS_LOADING_LOCK = gCLL;
    }
}

