/*
 * Decompiled with CFR 0.152.
 */
package jenkins.diagnostics;

import com.google.common.collect.ImmutableList;
import hudson.Extension;
import hudson.PluginWrapper;
import hudson.model.AdministrativeMonitor;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import jenkins.model.Jenkins;

@Extension
public class PinningIsBlockingBundledPluginMonitor
extends AdministrativeMonitor {
    @Inject
    Jenkins jenkins;
    private List<PluginWrapper> offenders;

    @Override
    public boolean isActivated() {
        return !this.getOffenders().isEmpty();
    }

    private void compute() {
        ArrayList<PluginWrapper> offenders = new ArrayList<PluginWrapper>();
        for (PluginWrapper p : this.jenkins.pluginManager.getPlugins()) {
            if (!p.isPinningForcingOldVersion()) continue;
            offenders.add(p);
        }
        this.offenders = ImmutableList.copyOf(offenders);
    }

    public List<PluginWrapper> getOffenders() {
        if (this.offenders == null) {
            this.compute();
        }
        return this.offenders;
    }
}

