/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.model.AbstractDescribableImpl;
import hudson.util.CaseInsensitiveComparator;
import java.util.Comparator;
import java.util.Locale;
import javax.annotation.Nonnull;
import jenkins.model.IdStrategyDescriptor;
import jenkins.model.Jenkins;
import jenkins.model.Messages;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public abstract class IdStrategy
extends AbstractDescribableImpl<IdStrategy>
implements ExtensionPoint,
Comparator<String> {
    public static IdStrategy CASE_INSENSITIVE = new CaseInsensitive();

    @Nonnull
    public abstract String filenameOf(@Nonnull String var1);

    public String idFromFilename(@Nonnull String filename) {
        return filename;
    }

    @Nonnull
    public abstract String keyFor(@Nonnull String var1);

    public boolean equals(@Nonnull String id1, @Nonnull String id2) {
        return this.compare(id1, id2) == 0;
    }

    @Override
    public abstract int compare(@Nonnull String var1, @Nonnull String var2);

    public IdStrategyDescriptor getDescriptor() {
        return (IdStrategyDescriptor)super.getDescriptor();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return this.getClass().getName();
    }

    public static DescriptorExtensionList<IdStrategy, IdStrategyDescriptor> all() {
        return Jenkins.getInstance().getDescriptorList(IdStrategy.class);
    }

    public static class CaseSensitiveEmailAddress
    extends CaseSensitive {
        @DataBoundConstructor
        public CaseSensitiveEmailAddress() {
        }

        @Override
        @Nonnull
        public String filenameOf(@Nonnull String id) {
            return super.filenameOf(this.keyFor(id));
        }

        @Override
        public boolean equals(@Nonnull String id1, @Nonnull String id2) {
            return StringUtils.equals((String)this.keyFor(id1), (String)this.keyFor(id2));
        }

        @Override
        @Nonnull
        public String keyFor(@Nonnull String id) {
            int index = id.lastIndexOf(64);
            return index == -1 ? id : id.substring(0, index) + id.substring(index).toLowerCase(Locale.ENGLISH);
        }

        @Override
        public int compare(@Nonnull String id1, @Nonnull String id2) {
            return this.keyFor(id1).compareTo(this.keyFor(id2));
        }

        @Extension
        public static class DescriptorImpl
        extends IdStrategyDescriptor {
            @Override
            public String getDisplayName() {
                return Messages.IdStrategy_CaseSensitiveEmailAddress_DisplayName();
            }
        }
    }

    public static class CaseSensitive
    extends IdStrategy {
        @DataBoundConstructor
        public CaseSensitive() {
        }

        @Override
        @Nonnull
        public String filenameOf(@Nonnull String id) {
            if (id.matches("[a-z0-9_. -]+")) {
                return id;
            }
            StringBuilder buf = new StringBuilder(id.length() + 16);
            for (char c : id.toCharArray()) {
                if ('a' <= c && c <= 'z') {
                    buf.append(c);
                    continue;
                }
                if ('0' <= c && c <= '9') {
                    buf.append(c);
                    continue;
                }
                if ('_' == c || '.' == c || '-' == c || ' ' == c || '@' == c) {
                    buf.append(c);
                    continue;
                }
                if ('A' <= c && c <= 'Z') {
                    buf.append('~');
                    buf.append(Character.toLowerCase(c));
                    continue;
                }
                buf.append('$');
                buf.append(StringUtils.leftPad((String)Integer.toHexString(c & 0xFFFF), (int)4, (char)'0'));
            }
            return buf.toString();
        }

        @Override
        public String idFromFilename(@Nonnull String filename) {
            if (filename.matches("[a-z0-9_. -]+")) {
                return filename;
            }
            StringBuilder buf = new StringBuilder(filename.length());
            char[] chars = filename.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if ('a' <= c && c <= 'z') {
                    buf.append(c);
                    continue;
                }
                if ('0' <= c && c <= '9') {
                    buf.append(c);
                    continue;
                }
                if ('_' == c || '.' == c || '-' == c || ' ' == c || '@' == c) {
                    buf.append(c);
                    continue;
                }
                if (c == '~') {
                    if (++i >= chars.length) continue;
                    buf.append(Character.toUpperCase(chars[i]));
                    continue;
                }
                if (c != '$') continue;
                StringBuilder hex = new StringBuilder(4);
                if (++i >= chars.length) break;
                hex.append(chars[i]);
                if (++i >= chars.length) break;
                hex.append(chars[i]);
                if (++i >= chars.length) break;
                hex.append(chars[i]);
                if (++i >= chars.length) break;
                hex.append(chars[i]);
                buf.append(Character.valueOf((char)Integer.parseInt(hex.toString(), 16)));
            }
            return buf.toString();
        }

        @Override
        public boolean equals(@Nonnull String id1, @Nonnull String id2) {
            return StringUtils.equals((String)id1, (String)id2);
        }

        @Override
        @Nonnull
        public String keyFor(@Nonnull String id) {
            return id;
        }

        @Override
        public int compare(@Nonnull String id1, @Nonnull String id2) {
            return id1.compareTo(id2);
        }

        @Extension
        public static class DescriptorImpl
        extends IdStrategyDescriptor {
            @Override
            public String getDisplayName() {
                return Messages.IdStrategy_CaseSensitive_DisplayName();
            }
        }
    }

    public static class CaseInsensitive
    extends IdStrategy {
        @DataBoundConstructor
        public CaseInsensitive() {
        }

        @Override
        @Nonnull
        public String filenameOf(@Nonnull String id) {
            return id.toLowerCase(Locale.ENGLISH);
        }

        @Override
        @Nonnull
        public String keyFor(@Nonnull String id) {
            return id.toLowerCase(Locale.ENGLISH);
        }

        @Override
        public int compare(@Nonnull String id1, @Nonnull String id2) {
            return CaseInsensitiveComparator.INSTANCE.compare(id1, id2);
        }

        @Extension
        public static class DescriptorImpl
        extends IdStrategyDescriptor {
            @Override
            public String getDisplayName() {
                return Messages.IdStrategy_CaseInsensitive_DisplayName();
            }
        }
    }
}

