/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.lazy;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.RunMap;
import hudson.model.listeners.ItemListener;
import hudson.widgets.BuildHistoryWidget;
import hudson.widgets.HistoryWidget;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.RunIdMigrator;
import jenkins.model.lazy.AbstractLazyLoadRunMap;
import jenkins.model.lazy.BuildReference;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

public abstract class LazyBuildMixIn<JobT extends Job<JobT, RunT> & LazyLoadingJob<JobT, RunT>, RunT extends Run<JobT, RunT>> {
    private static final Logger LOGGER = Logger.getLogger(LazyBuildMixIn.class.getName());
    @Nonnull
    private RunMap<RunT> builds = new RunMap();

    protected LazyBuildMixIn() {
    }

    protected abstract JobT asJob();

    @Nonnull
    public final RunMap<RunT> getRunMap() {
        return this.builds;
    }

    public final RunMap<RunT> _getRuns() {
        assert (this.builds.baseDirInitialized()) : "neither onCreatedFromScratch nor onLoad called on " + this.asJob() + " yet";
        return this.builds;
    }

    public final void onCreatedFromScratch() {
        this.builds = this.createBuildRunMap();
    }

    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        RunMap<RunT> _builds = this.createBuildRunMap();
        RunMap<RunT> currentBuilds = this.builds;
        if (parent != null) {
            Item current;
            try {
                current = parent.getItem(name);
            }
            catch (RuntimeException x) {
                LOGGER.log(Level.WARNING, "failed to look up " + name + " in " + parent, x);
                current = null;
            }
            if (current != null && current.getClass() == this.asJob().getClass()) {
                currentBuilds = ((LazyLoadingJob)((Object)current)).getLazyBuildMixIn().builds;
            }
        }
        if (currentBuilds != null) {
            for (Run r : currentBuilds.getLoadedBuilds().values()) {
                if (!r.isBuilding()) continue;
                _builds.put(r.getNumber(), (RunT)r);
            }
        }
        this.builds = _builds;
    }

    private RunMap<RunT> createBuildRunMap() {
        RunMap r = new RunMap(((Job)this.asJob()).getBuildDir(), new RunMap.Constructor<RunT>(){

            @Override
            public RunT create(File dir) throws IOException {
                return LazyBuildMixIn.this.loadBuild(dir);
            }
        });
        RunIdMigrator runIdMigrator = ((Job)this.asJob()).runIdMigrator;
        assert (runIdMigrator != null);
        r.runIdMigrator = runIdMigrator;
        return r;
    }

    protected abstract Class<RunT> getBuildClass();

    public RunT loadBuild(File dir) throws IOException {
        try {
            return (RunT)((Run)this.getBuildClass().getConstructor(this.asJob().getClass(), File.class).newInstance(this.asJob(), dir));
        }
        catch (InstantiationException e) {
            throw new Error(e);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        catch (InvocationTargetException e) {
            throw this.handleInvocationTargetException(e);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    public final synchronized RunT newBuild() throws IOException {
        try {
            Run lastBuild = (Run)this.getBuildClass().getConstructor(this.asJob().getClass()).newInstance(this.asJob());
            this.builds.put((RunT)lastBuild);
            lastBuild.getPreviousBuild();
            return (RunT)lastBuild;
        }
        catch (InstantiationException e) {
            throw new Error(e);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        catch (InvocationTargetException e) {
            throw this.handleInvocationTargetException(e);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    private IOException handleInvocationTargetException(InvocationTargetException e) {
        Throwable t = e.getTargetException();
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof IOException) {
            return (IOException)t;
        }
        throw new Error(t);
    }

    public final void removeRun(RunT run) {
        if (!this.builds.remove(run)) {
            LOGGER.log(Level.WARNING, "{0} did not contain {1} to begin with", new Object[]{this.asJob(), run});
        }
    }

    public final RunT getBuild(String id) {
        return (RunT)this.builds.getById(id);
    }

    public final RunT getBuildByNumber(int n) {
        return (RunT)((Run)this.builds.getByNumber(n));
    }

    public final RunT getFirstBuild() {
        return (RunT)((Run)this.builds.oldestBuild());
    }

    @CheckForNull
    public final RunT getLastBuild() {
        return (RunT)((Run)this.builds.newestBuild());
    }

    public final RunT getNearestBuild(int n) {
        return (RunT)((Run)this.builds.search(n, AbstractLazyLoadRunMap.Direction.ASC));
    }

    public final RunT getNearestOldBuild(int n) {
        return (RunT)((Run)this.builds.search(n, AbstractLazyLoadRunMap.Direction.DESC));
    }

    public final HistoryWidget createHistoryWidget() {
        return new BuildHistoryWidget<Run>((Queue.Task)this.asJob(), (Iterable<Run>)this.builds, Job.HISTORY_ADAPTER);
    }

    @Extension
    @Restricted(value={DoNotUse.class})
    public static final class ItemListenerImpl
    extends ItemListener {
        @Override
        public void onLocationChanged(Item item, String oldFullName, String newFullName) {
            if (item instanceof LazyLoadingJob) {
                RunMap builds = ((LazyLoadingJob)((Object)item)).getLazyBuildMixIn().builds;
                builds.updateBaseDir(((Job)item).getBuildDir());
            }
        }
    }

    public static abstract class RunMixIn<JobT extends Job<JobT, RunT> & LazyLoadingJob<JobT, RunT>, RunT extends Run<JobT, RunT>> {
        private volatile BuildReference<RunT> previousBuildR;
        private volatile BuildReference<RunT> nextBuildR;
        private static final BuildReference NONE = new BuildReference<Object>("NONE", null);
        private BuildReference<RunT> selfReference;

        private BuildReference<RunT> none() {
            return NONE;
        }

        protected RunMixIn() {
        }

        protected abstract RunT asRun();

        public final synchronized BuildReference<RunT> createReference() {
            if (this.selfReference == null) {
                this.selfReference = new BuildReference<RunT>(((Run)this.asRun()).getId(), this.asRun());
            }
            return this.selfReference;
        }

        public final void dropLinks() {
            Run pb;
            Run nb;
            if (this.nextBuildR != null && (nb = (Run)this.nextBuildR.get()) != null) {
                ((LazyLoadingRun)((Object)nb)).getRunMixIn().previousBuildR = this.previousBuildR;
            }
            if (this.previousBuildR != null && (pb = (Run)this.previousBuildR.get()) != null) {
                ((LazyLoadingRun)((Object)pb)).getRunMixIn().nextBuildR = this.nextBuildR;
            }
            this.createReference().clear();
        }

        public final RunT getPreviousBuild() {
            while (true) {
                BuildReference<RunT> r;
                if ((r = this.previousBuildR) == null) {
                    Object _parent = ((Run)this.asRun()).getParent();
                    if (_parent == null) {
                        throw new IllegalStateException("no parent for " + ((Run)this.asRun()).number);
                    }
                    Run pb = (Run)((LazyLoadingJob)_parent).getLazyBuildMixIn()._getRuns().search(((Run)this.asRun()).number - 1, AbstractLazyLoadRunMap.Direction.DESC);
                    if (pb != null) {
                        ((LazyLoadingRun)((Object)pb)).getRunMixIn().nextBuildR = this.createReference();
                        this.previousBuildR = ((LazyLoadingRun)((Object)pb)).getRunMixIn().createReference();
                        LOGGER.log(Level.FINER, "Linked {0}<->{1} in getPreviousBuild()", new Object[]{this, pb});
                        return (RunT)pb;
                    }
                    this.previousBuildR = this.none();
                    return null;
                }
                if (r == this.none()) {
                    return null;
                }
                Run referent = (Run)r.get();
                if (referent != null) {
                    return (RunT)referent;
                }
                this.previousBuildR = null;
            }
        }

        public final RunT getNextBuild() {
            while (true) {
                BuildReference<RunT> r;
                if ((r = this.nextBuildR) == null) {
                    Run nb = (Run)((LazyLoadingJob)((Run)this.asRun()).getParent()).getLazyBuildMixIn()._getRuns().search(((Run)this.asRun()).number + 1, AbstractLazyLoadRunMap.Direction.ASC);
                    if (nb != null) {
                        ((LazyLoadingRun)((Object)nb)).getRunMixIn().previousBuildR = this.createReference();
                        this.nextBuildR = ((LazyLoadingRun)((Object)nb)).getRunMixIn().createReference();
                        LOGGER.log(Level.FINER, "Linked {0}<->{1} in getNextBuild()", new Object[]{this, nb});
                        return (RunT)nb;
                    }
                    this.nextBuildR = this.none();
                    return null;
                }
                if (r == this.none()) {
                    return null;
                }
                Run referent = (Run)r.get();
                if (referent != null) {
                    return (RunT)referent;
                }
                this.nextBuildR = null;
            }
        }
    }

    public static interface LazyLoadingRun<JobT extends Job<JobT, RunT> & LazyLoadingJob<JobT, RunT>, RunT extends Run<JobT, RunT>> {
        public RunMixIn<JobT, RunT> getRunMixIn();
    }

    public static interface LazyLoadingJob<JobT extends Job<JobT, RunT> & LazyLoadingJob<JobT, RunT>, RunT extends Run<JobT, RunT>> {
        public LazyBuildMixIn<JobT, RunT> getLazyBuildMixIn();
    }
}

