/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.lazy;

import java.util.AbstractList;
import java.util.Arrays;
import jenkins.model.lazy.Boundary;

class SortedIntList
extends AbstractList<Integer> {
    private int[] data;
    private int size;

    public SortedIntList(int capacity) {
        this.data = new int[capacity];
        this.size = 0;
    }

    public SortedIntList(SortedIntList that) {
        this.data = new int[that.size + 8];
        System.arraycopy(that.data, 0, this.data, 0, that.size);
        this.size = that.size;
    }

    public int find(int probe) {
        return SortedIntList.binarySearch(this.data, 0, this.size, probe);
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof Integer && this.contains((Integer)o);
    }

    public boolean contains(int i) {
        return this.find(i) >= 0;
    }

    @Override
    public Integer get(int index) {
        if (this.size <= index) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(Integer i) {
        return this.add((int)i);
    }

    @Override
    public boolean add(int i) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = i;
        return true;
    }

    private void ensureCapacity(int i) {
        if (this.data.length < i) {
            int[] r = new int[Math.max(this.data.length * 2, i)];
            System.arraycopy(this.data, 0, r, 0, this.size);
            this.data = r;
        }
    }

    public int lower(int v) {
        return Boundary.LOWER.apply(this.find(v));
    }

    public int higher(int v) {
        return Boundary.HIGHER.apply(this.find(v));
    }

    public int floor(int v) {
        return Boundary.FLOOR.apply(this.find(v));
    }

    public int ceil(int v) {
        return Boundary.CEIL.apply(this.find(v));
    }

    public boolean isInRange(int idx) {
        return 0 <= idx && idx < this.size;
    }

    public void sort() {
        Arrays.sort(this.data, 0, this.size);
    }

    public void copyInto(int[] dest) {
        System.arraycopy(this.data, 0, dest, 0, this.size);
    }

    public void removeValue(int n) {
        int idx = this.find(n);
        if (idx < 0) {
            return;
        }
        System.arraycopy(this.data, idx + 1, this.data, idx, this.size - (idx + 1));
        --this.size;
    }

    private static int binarySearch(int[] a, int start, int end, int key) {
        int lo = start;
        int hi = end - 1;
        while (lo <= hi) {
            int pivot = (lo + hi) / 2;
            int v = a[pivot];
            if (v < key) {
                lo = pivot + 1;
                continue;
            }
            if (v > key) {
                hi = pivot - 1;
                continue;
            }
            return pivot;
        }
        return -(lo + 1);
    }
}

