/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.security.ACL;
import hudson.util.HttpResponses;
import hudson.util.Secret;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.SecureRandom;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.security.HMACConfidentialKey;
import jenkins.security.Messages;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ApiTokenProperty
extends UserProperty {
    private volatile Secret apiToken;
    private static final boolean SHOW_TOKEN_TO_ADMINS = Boolean.getBoolean(ApiTokenProperty.class.getName() + ".showTokenToAdmins");
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final HMACConfidentialKey API_KEY_SEED = new HMACConfidentialKey(ApiTokenProperty.class, "seed", 16);

    @DataBoundConstructor
    public ApiTokenProperty() {
        this._changeApiToken();
    }

    ApiTokenProperty(String seed) {
        this.apiToken = Secret.fromString(seed);
    }

    @Nonnull
    public String getApiToken() {
        return this.hasPermissionToSeeToken() ? this.getApiTokenInsecure() : Messages.ApiTokenProperty_ChangeToken_TokenIsHidden();
    }

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    String getApiTokenInsecure() {
        String p = this.apiToken.getPlainText();
        if (p.equals(Util.getDigestOf(Jenkins.getInstance().getSecretKey() + ":" + this.user.getId()))) {
            p = API_KEY_SEED.mac(this.user.getId());
            this.apiToken = Secret.fromString(p);
        }
        return Util.getDigestOf(p);
    }

    public boolean matchesPassword(String password) {
        String token = this.getApiTokenInsecure();
        return MessageDigest.isEqual(password.getBytes(Charset.forName("US-ASCII")), token.getBytes(Charset.forName("US-ASCII")));
    }

    private boolean hasPermissionToSeeToken() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            return false;
        }
        if (SHOW_TOKEN_TO_ADMINS && jenkins.hasPermission(Jenkins.ADMINISTER)) {
            return true;
        }
        User current = User.current();
        if (current == null) {
            return false;
        }
        if (Jenkins.getAuthentication() == ACL.SYSTEM) {
            return true;
        }
        return StringUtils.equals((String)this.user.getId(), (String)current.getId());
    }

    public void changeApiToken() throws IOException {
        this.user.checkPermission(Jenkins.ADMINISTER);
        this._changeApiToken();
        this.user.save();
    }

    private void _changeApiToken() {
        byte[] random = new byte[16];
        RANDOM.nextBytes(random);
        this.apiToken = Secret.fromString(Util.toHexString(random));
    }

    @Override
    public UserProperty reconfigure(StaplerRequest req, JSONObject form) throws Descriptor.FormException {
        return this;
    }

    @Extension
    public static final class DescriptorImpl
    extends UserPropertyDescriptor {
        @Override
        public String getDisplayName() {
            return Messages.ApiTokenProperty_DisplayName();
        }

        @Override
        public ApiTokenProperty newInstance(User user) {
            return new ApiTokenProperty(API_KEY_SEED.mac(user.getId()));
        }

        public HttpResponse doChangeToken(@AncestorInPath User u, StaplerResponse rsp) throws IOException {
            ApiTokenProperty p = u.getProperty(ApiTokenProperty.class);
            if (p == null) {
                p = this.newInstance(u);
                u.addProperty(p);
            } else {
                p.changeApiToken();
            }
            rsp.setHeader("script", "document.getElementById('apiToken').value='" + p.getApiToken() + "'");
            return HttpResponses.html((String)(p.hasPermissionToSeeToken() ? Messages.ApiTokenProperty_ChangeToken_Success() : Messages.ApiTokenProperty_ChangeToken_SuccessHidden()));
        }
    }
}

