/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.Extension;
import hudson.model.User;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.security.ApiTokenProperty;
import jenkins.security.BasicHeaderAuthenticator;
import org.acegisecurity.Authentication;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.springframework.dao.DataAccessException;

@Extension
public class BasicHeaderApiTokenAuthenticator
extends BasicHeaderAuthenticator {
    private static final Logger LOGGER = Logger.getLogger(BasicHeaderApiTokenAuthenticator.class.getName());

    @Override
    public Authentication authenticate(HttpServletRequest req, HttpServletResponse rsp, String username, String password) throws ServletException {
        User u = User.get(username);
        ApiTokenProperty t = u.getProperty(ApiTokenProperty.class);
        if (t != null && t.matchesPassword(password)) {
            try {
                return u.impersonate();
            }
            catch (UsernameNotFoundException x) {
                LOGGER.log(Level.WARNING, "API token matched for user " + username + " but the impersonation failed", x);
                throw new ServletException((Throwable)x);
            }
            catch (DataAccessException x) {
                throw new ServletException((Throwable)x);
            }
        }
        return null;
    }
}

