/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.Lookup;
import hudson.util.Service;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.security.ConfidentialKey;
import jenkins.security.DefaultConfidentialStore;

public abstract class ConfidentialStore {
    static ThreadLocal<ConfidentialStore> TEST = null;
    private static final Logger LOGGER = Logger.getLogger(ConfidentialStore.class.getName());

    protected abstract void store(ConfidentialKey var1, byte[] var2) throws IOException;

    @CheckForNull
    protected abstract byte[] load(ConfidentialKey var1) throws IOException;

    public abstract byte[] randomBytes(int var1);

    @Nonnull
    public static ConfidentialStore get() {
        if (TEST != null) {
            return TEST.get();
        }
        Jenkins j = Jenkins.getInstance();
        if (j == null) {
            throw new IllegalStateException("cannot initialize confidential key store until Jenkins has started");
        }
        Lookup lookup = j.lookup;
        ConfidentialStore cs = lookup.get(ConfidentialStore.class);
        if (cs == null) {
            try {
                List<ConfidentialStore> r = Service.loadInstances(ConfidentialStore.class.getClassLoader(), ConfidentialStore.class);
                if (!r.isEmpty()) {
                    cs = r.get(0);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to list up ConfidentialStore implementations", e);
            }
            if (cs == null) {
                try {
                    cs = new DefaultConfidentialStore();
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            }
            cs = lookup.setIfNull(ConfidentialStore.class, cs);
        }
        return cs;
    }
}

