/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.security.UserMayOrMayNotExistException;
import java.util.Collections;
import jenkins.security.LastGrantedAuthoritiesProperty;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.springframework.dao.DataAccessException;

public class ImpersonatingUserDetailsService
implements UserDetailsService {
    private final UserDetailsService base;

    public ImpersonatingUserDetailsService(UserDetailsService base) {
        this.base = base;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        try {
            return this.base.loadUserByUsername(username);
        }
        catch (UserMayOrMayNotExistException e) {
            return this.attemptToImpersonate(username, (RuntimeException)((Object)e));
        }
        catch (DataAccessException e) {
            return this.attemptToImpersonate(username, (RuntimeException)((Object)e));
        }
    }

    protected UserDetails attemptToImpersonate(String username, RuntimeException e) {
        LastGrantedAuthoritiesProperty p;
        hudson.model.User u = hudson.model.User.get(username, false, Collections.emptyMap());
        if (u != null && (p = u.getProperty(LastGrantedAuthoritiesProperty.class)) != null) {
            return new User(username, "", true, true, true, true, p.getAuthorities());
        }
        throw e;
    }
}

