/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.Extension;
import hudson.ExtensionPoint;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;

public interface SecureRequester
extends ExtensionPoint {
    public boolean permit(StaplerRequest var1, Object var2);

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static class Default
    implements SecureRequester {
        private static final String PROP = "hudson.model.Api.INSECURE";
        private static final boolean INSECURE = Boolean.getBoolean("hudson.model.Api.INSECURE");

        @Override
        public boolean permit(StaplerRequest req, Object bean) {
            return INSECURE || !Jenkins.getInstance().isUseSecurity();
        }

        static {
            if (INSECURE) {
                Logger.getLogger(SecureRequester.class.getName()).warning("hudson.model.Api.INSECURE system property is deprecated; implement SecureRequester instead");
            }
        }
    }
}

