/*
 * Decompiled with CFR 0.152.
 */
package jenkins.slaves;

import hudson.Extension;
import hudson.TcpSlaveAgentListener;
import hudson.Util;
import hudson.remoting.Channel;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.slaves.JnlpAgentReceiver;
import jenkins.slaves.JnlpSlaveAgentProtocol;
import jenkins.slaves.JnlpSlaveAgentProtocol2;
import jenkins.slaves.JnlpSlaveHandshake;

@Extension
public class DefaultJnlpSlaveReceiver
extends JnlpAgentReceiver {
    private static final Logger LOGGER = Logger.getLogger(DefaultJnlpSlaveReceiver.class.getName());
    private static final String COOKIE_NAME = JnlpSlaveAgentProtocol2.class.getName() + ".cookie";

    @Override
    public boolean handle(String nodeName, JnlpSlaveHandshake handshake) throws IOException, InterruptedException {
        SlaveComputer computer = (SlaveComputer)Jenkins.getInstance().getComputer(nodeName);
        if (computer == null) {
            return false;
        }
        Channel ch = computer.getChannel();
        if (ch != null) {
            String c = handshake.getRequestProperty("Cookie");
            if (c != null && c.equals(ch.getProperty((Object)COOKIE_NAME))) {
                LOGGER.info("Disconnecting " + nodeName + " as we are reconnected from the current peer");
                try {
                    computer.disconnect(new TcpSlaveAgentListener.ConnectionFromCurrentPeer()).get(15L, TimeUnit.SECONDS);
                }
                catch (ExecutionException e) {
                    throw new IOException("Failed to disconnect the current client", e);
                }
                catch (TimeoutException e) {
                    throw new IOException("Failed to disconnect the current client", e);
                }
            } else {
                handshake.error(nodeName + " is already connected to this master. Rejecting this connection.");
                return true;
            }
        }
        if (!this.matchesSecret(nodeName, handshake)) {
            handshake.error(nodeName + " can't be connected since the slave's secret does not match the handshake secret.");
            return true;
        }
        Properties response = new Properties();
        String cookie = this.generateCookie();
        response.put("Cookie", cookie);
        handshake.success(response);
        JnlpSlaveAgentProtocol.Handler handler = (JnlpSlaveAgentProtocol.Handler)handshake;
        ch = handler.jnlpConnect(computer);
        ch.setProperty((Object)COOKIE_NAME, (Object)cookie);
        return true;
    }

    private boolean matchesSecret(String nodeName, JnlpSlaveHandshake handshake) {
        SlaveComputer computer = (SlaveComputer)Jenkins.getInstance().getComputer(nodeName);
        String handshakeSecret = handshake.getRequestProperty("Secret-Key");
        if (!computer.getJnlpMac().equals(handshakeSecret)) {
            LOGGER.log(Level.WARNING, "An attempt was made to connect as {0} from {1} with an incorrect secret", new Object[]{nodeName, handshake.getSocket() != null ? handshake.getSocket().getRemoteSocketAddress() : null});
            return false;
        }
        return true;
    }

    private String generateCookie() {
        byte[] cookie = new byte[32];
        new SecureRandom().nextBytes(cookie);
        return Util.toHexString(cookie);
    }
}

