/*
 * Decompiled with CFR 0.152.
 */
package jenkins.slaves;

import hudson.model.Computer;
import hudson.remoting.ChannelBuilder;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.remoting.nio.NioChannelHub;

public class JnlpSlaveHandshake {
    final NioChannelHub hub;
    final Socket socket;
    final DataInputStream in;
    final PrintWriter out;
    final Properties request = new Properties();
    private static final Logger LOGGER = Logger.getLogger(JnlpSlaveHandshake.class.getName());

    JnlpSlaveHandshake(NioChannelHub hub, Socket socket, DataInputStream in, PrintWriter out) {
        this.hub = hub;
        this.socket = socket;
        this.in = in;
        this.out = out;
    }

    public NioChannelHub getHub() {
        return this.hub;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public DataInputStream getIn() {
        return this.in;
    }

    public PrintWriter getOut() {
        return this.out;
    }

    public Properties getRequestProperties() {
        return this.request;
    }

    public String getRequestProperty(String name) {
        return this.request.getProperty(name);
    }

    public void error(String msg) throws IOException {
        this.out.println(msg);
        LOGGER.log(Level.WARNING, Thread.currentThread().getName() + " is aborted: " + msg);
        this.socket.close();
    }

    public void success(Properties response) {
        this.out.println("Welcome");
        for (Map.Entry<Object, Object> e : response.entrySet()) {
            this.out.println(e.getKey() + ": " + e.getValue());
        }
        this.out.println();
    }

    public ChannelBuilder createChannelBuilder(String nodeName) {
        if (this.hub == null) {
            return new ChannelBuilder(nodeName, Computer.threadPoolForRemoting);
        }
        return this.hub.newChannelBuilder(nodeName, Computer.threadPoolForRemoting);
    }
}

