/*
 * Decompiled with CFR 0.152.
 */
package jenkins.slaves;

import hudson.Extension;
import hudson.model.Computer;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.remoting.nio.NioChannelHub;

@Extension
public class NioChannelSelector {
    private NioChannelHub hub;
    public static boolean DISABLED = Boolean.getBoolean(NioChannelSelector.class.getName() + ".disabled");
    private static final Logger LOGGER = Logger.getLogger(NioChannelSelector.class.getName());

    public NioChannelSelector() {
        try {
            if (!DISABLED) {
                this.hub = new NioChannelHub(Computer.threadPoolForRemoting);
                Computer.threadPoolForRemoting.submit((Runnable)this.hub);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to launch NIO hub", e);
            this.hub = null;
            DISABLED = true;
        }
    }

    public NioChannelHub getHub() {
        return this.hub;
    }
}

