/*
 * Decompiled with CFR 0.152.
 */
package jenkins.slaves;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.StandardOutputStream;
import hudson.slaves.ComputerListener;
import hudson.util.jna.GNUCLibrary;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import jenkins.security.MasterToSlaveCallable;

@Extension
public class StandardOutputSwapper
extends ComputerListener {
    private static final Logger LOGGER = Logger.getLogger(StandardOutputSwapper.class.getName());
    public static boolean disabled = Boolean.getBoolean(StandardOutputSwapper.class.getName() + ".disabled");

    @Override
    public void preOnline(Computer c, Channel channel, FilePath root, TaskListener listener) {
        if (disabled) {
            return;
        }
        try {
            if (((Boolean)channel.call((Callable)new ChannelSwapper())).booleanValue()) {
                listener.getLogger().println("Evacuated stdout");
            }
        }
        catch (Throwable e) {
            LOGGER.fine("Fatal problem swapping file descriptors " + c.getName());
        }
    }

    private static final class ChannelSwapper
    extends MasterToSlaveCallable<Boolean, Exception> {
        private ChannelSwapper() {
        }

        public Boolean call() throws Exception {
            if (File.pathSeparatorChar == ';') {
                return false;
            }
            Channel c = Channel.current();
            StandardOutputStream sos = (StandardOutputStream)c.getProperty(StandardOutputStream.class);
            if (sos != null) {
                this.swap(sos);
                return true;
            }
            OutputStream o = c.getUnderlyingOutput();
            if (o instanceof StandardOutputStream) {
                this.swap((StandardOutputStream)o);
                return true;
            }
            return false;
        }

        private void swap(StandardOutputStream stdout) throws IOException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
            int out = GNUCLibrary.LIBC.dup(1);
            if (out < 0) {
                throw new IOException("Failed to dup(1)");
            }
            Constructor c = FileDescriptor.class.getDeclaredConstructor(Integer.TYPE);
            c.setAccessible(true);
            FileOutputStream fos = new FileOutputStream((FileDescriptor)c.newInstance(out));
            stdout.swap((OutputStream)fos);
            GNUCLibrary.LIBC.close(1);
            GNUCLibrary.LIBC.dup2(2, 1);
        }
    }
}

