/*
 * Decompiled with CFR 0.152.
 */
package jenkins.slaves.restarter;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Engine;
import hudson.remoting.EngineListener;
import hudson.remoting.EngineListenerAdapter;
import hudson.remoting.VirtualChannel;
import hudson.slaves.ComputerListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import jenkins.slaves.restarter.SlaveRestarter;

@Extension
public class JnlpSlaveRestarterInstaller
extends ComputerListener
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(JnlpSlaveRestarterInstaller.class.getName());
    private static final long serialVersionUID = 1L;

    @Override
    public void onOnline(final Computer c, final TaskListener listener) throws IOException, InterruptedException {
        Jenkins.MasterComputer.threadPoolForRemoting.submit(new java.util.concurrent.Callable<Void>(){

            @Override
            public Void call() throws Exception {
                JnlpSlaveRestarterInstaller.this.install(c, listener);
                return null;
            }
        });
    }

    private void install(Computer c, TaskListener listener) {
        try {
            final ArrayList<SlaveRestarter> restarters = new ArrayList<SlaveRestarter>(SlaveRestarter.all());
            VirtualChannel ch = c.getChannel();
            if (ch == null) {
                return;
            }
            List effective = (List)ch.call((Callable)new MasterToSlaveCallable<List<SlaveRestarter>, IOException>(){

                public List<SlaveRestarter> call() throws IOException {
                    Engine e = Engine.current();
                    if (e == null) {
                        return null;
                    }
                    try {
                        Engine.class.getMethod("addListener", EngineListener.class);
                    }
                    catch (NoSuchMethodException _) {
                        return null;
                    }
                    Iterator itr = restarters.iterator();
                    while (itr.hasNext()) {
                        SlaveRestarter r = (SlaveRestarter)itr.next();
                        if (r.canWork()) continue;
                        itr.remove();
                    }
                    e.addListener((EngineListener)new EngineListenerAdapter(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onReconnect() {
                            try {
                                for (SlaveRestarter r : restarters) {
                                    try {
                                        LOGGER.info("Restarting slave via " + r);
                                        r.restart();
                                    }
                                    catch (Exception x) {
                                        LOGGER.log(Level.SEVERE, "Failed to restart slave with " + r, x);
                                    }
                                }
                            }
                            finally {
                                restarters.clear();
                            }
                        }
                    });
                    return restarters;
                }
            });
            LOGGER.log(Level.FINE, "Effective SlaveRestarter on {0}: {1}", new Object[]{c.getName(), effective});
        }
        catch (Throwable e) {
            e.printStackTrace(listener.error("Failed to install restarter"));
        }
    }
}

