/*
 * Decompiled with CFR 0.152.
 */
package jenkins.triggers;

import hudson.Extension;
import hudson.Util;
import hudson.console.ModelHyperlinkNote;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.DependencyGraph;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.model.listeners.RunListener;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.DependencyDeclarer;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.security.QueueItemAuthenticatorConfiguration;
import jenkins.triggers.Messages;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public final class ReverseBuildTrigger
extends Trigger<Job>
implements DependencyDeclarer {
    private static final Logger LOGGER = Logger.getLogger(ReverseBuildTrigger.class.getName());
    private static final Map<Job, Collection<ReverseBuildTrigger>> upstream2Trigger = new WeakHashMap<Job, Collection<ReverseBuildTrigger>>();
    private String upstreamProjects;
    private final Result threshold;

    @DataBoundConstructor
    public ReverseBuildTrigger(String upstreamProjects, Result threshold) {
        this.upstreamProjects = upstreamProjects;
        this.threshold = threshold;
    }

    public String getUpstreamProjects() {
        return this.upstreamProjects;
    }

    public Result getThreshold() {
        return this.threshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldTrigger(Run upstreamBuild, TaskListener listener) {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null || this.job == null) {
            return false;
        }
        boolean downstreamVisible = jenkins.getItemByFullName(((Job)this.job).getFullName()) == this.job;
        Authentication originalAuth = Jenkins.getAuthentication();
        Object upstream = upstreamBuild.getParent();
        Authentication auth = Tasks.getAuthenticationOf((Queue.Task)((Object)this.job));
        if (auth.equals(ACL.SYSTEM) && !QueueItemAuthenticatorConfiguration.get().getAuthenticators().isEmpty()) {
            auth = Jenkins.ANONYMOUS;
        }
        SecurityContext orig = ACL.impersonate(auth);
        try {
            if (jenkins.getItemByFullName(((AbstractItem)upstream).getFullName()) != upstream) {
                if (downstreamVisible) {
                    listener.getLogger().println(Messages.ReverseBuildTrigger_running_as_cannot_even_see_for_trigger_f(auth.getName(), ((AbstractItem)upstream).getFullName(), ((Job)this.job).getFullName()));
                } else {
                    LOGGER.log(Level.WARNING, "Running as {0} cannot even see {1} for trigger from {2} (but cannot tell {3} that)", new Object[]{auth.getName(), upstream, this.job, originalAuth.getName()});
                }
                boolean bl = false;
                return bl;
            }
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)orig);
        }
        Result result = upstreamBuild.getResult();
        return result != null && result.isBetterOrEqualTo(this.threshold);
    }

    @Override
    public void buildDependencyGraph(AbstractProject downstream, DependencyGraph graph) {
        for (AbstractProject upstream : Items.fromNameList(downstream.getParent(), this.upstreamProjects, AbstractProject.class)) {
            graph.addDependency(new DependencyGraph.Dependency(upstream, downstream){

                @Override
                public boolean shouldTriggerBuild(AbstractBuild upstreamBuild, TaskListener listener, List<Action> actions) {
                    return ReverseBuildTrigger.this.shouldTrigger(upstreamBuild, listener);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void start(@Nonnull Job project, boolean newInstance) {
        super.start(project, newInstance);
        SecurityContext orig = ACL.impersonate(ACL.SYSTEM);
        try {
            for (Job upstream : Items.fromNameList(project.getParent(), this.upstreamProjects, Job.class)) {
                if (upstream instanceof AbstractProject && project instanceof AbstractProject) continue;
                Map<Job, Collection<ReverseBuildTrigger>> map = upstream2Trigger;
                synchronized (map) {
                    Collection<ReverseBuildTrigger> triggers = upstream2Trigger.get(upstream);
                    if (triggers == null) {
                        triggers = new LinkedList<ReverseBuildTrigger>();
                        upstream2Trigger.put(upstream, triggers);
                    }
                    triggers.remove(this);
                    triggers.add(this);
                }
            }
            return;
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)orig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        Map<Job, Collection<ReverseBuildTrigger>> map = upstream2Trigger;
        synchronized (map) {
            for (Collection<ReverseBuildTrigger> triggers : upstream2Trigger.values()) {
                triggers.remove(this);
            }
        }
    }

    @Extension
    public static class ItemListenerImpl
    extends ItemListener {
        @Override
        public void onLocationChanged(Item item, String oldFullName, String newFullName) {
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                return;
            }
            for (Job p : jenkins.getAllItems(Job.class)) {
                String revised;
                ReverseBuildTrigger t = ParameterizedJobMixIn.getTrigger(p, ReverseBuildTrigger.class);
                if (t == null || (revised = Items.computeRelativeNamesAfterRenaming(oldFullName, newFullName, t.upstreamProjects, p.getParent())).equals(t.upstreamProjects)) continue;
                t.upstreamProjects = revised;
                try {
                    p.save();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to persist project setting during rename from " + oldFullName + " to " + newFullName, e);
                }
            }
        }
    }

    @Extension
    public static final class RunListenerImpl
    extends RunListener<Run> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted(@Nonnull Run r, @Nonnull TaskListener listener) {
            ArrayList triggers;
            Map map = upstream2Trigger;
            synchronized (map) {
                Collection _triggers = (Collection)upstream2Trigger.get(r.getParent());
                if (_triggers == null || _triggers.isEmpty()) {
                    return;
                }
                triggers = new ArrayList(_triggers);
            }
            for (ReverseBuildTrigger trigger : triggers) {
                if (!trigger.shouldTrigger(r, listener)) continue;
                if (!((Job)trigger.job).isBuildable()) {
                    listener.getLogger().println(hudson.tasks.Messages.BuildTrigger_Disabled(ModelHyperlinkNote.encodeTo(trigger.job)));
                    continue;
                }
                String name = ModelHyperlinkNote.encodeTo(trigger.job) + " #" + ((Job)trigger.job).getNextBuildNumber();
                if (ParameterizedJobMixIn.scheduleBuild2((Job)trigger.job, -1, new CauseAction((Cause)new Cause.UpstreamCause(r))) != null) {
                    listener.getLogger().println(hudson.tasks.Messages.BuildTrigger_Triggering(name));
                    continue;
                }
                listener.getLogger().println(hudson.tasks.Messages.BuildTrigger_InQueue(name));
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends TriggerDescriptor {
        @Override
        public String getDisplayName() {
            return Messages.ReverseBuildTrigger_build_after_other_projects_are_built();
        }

        @Override
        public boolean isApplicable(Item item) {
            return item instanceof Job && item instanceof ParameterizedJobMixIn.ParameterizedJob;
        }

        public AutoCompletionCandidates doAutoCompleteUpstreamProjects(@QueryParameter String value, @AncestorInPath Item self, @AncestorInPath ItemGroup container) {
            return AutoCompletionCandidates.ofJobNames(Job.class, value, self, container);
        }

        public FormValidation doCheckUpstreamProjects(@AncestorInPath Job project, @QueryParameter String value) {
            if (!project.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            StringTokenizer tokens = new StringTokenizer(Util.fixNull(value), ",");
            boolean hasProjects = false;
            while (tokens.hasMoreTokens()) {
                String projectName = tokens.nextToken().trim();
                if (!StringUtils.isNotBlank((String)projectName)) continue;
                Jenkins jenkins = Jenkins.getInstance();
                if (jenkins == null) {
                    return FormValidation.ok();
                }
                Job item = jenkins.getItem(projectName, project, Job.class);
                if (item == null) {
                    Job nearest = Items.findNearest(Job.class, projectName, project.getParent());
                    String alternative = nearest != null ? nearest.getRelativeNameFrom(project) : "?";
                    return FormValidation.error(hudson.tasks.Messages.BuildTrigger_NoSuchProject(projectName, alternative));
                }
                hasProjects = true;
            }
            if (!hasProjects) {
                return FormValidation.error(hudson.tasks.Messages.BuildTrigger_NoProjectSpecified());
            }
            return FormValidation.ok();
        }
    }
}

