/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Main;
import hudson.Platform;
import hudson.Util;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.util.CaseInsensitiveComparator;
import hudson.util.CyclicGraphDetector;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Logger;
import jenkins.security.MasterToSlaveCallable;

public class EnvVars
extends TreeMap<String, String> {
    private static final long serialVersionUID = 4320331661987259022L;
    private static Logger LOGGER = Logger.getLogger(EnvVars.class.getName());
    private Platform platform;
    public static final Map<String, String> masterEnvVars = EnvVars.initMaster();

    @CheckForNull
    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(@NonNull Platform platform) {
        this.platform = platform;
    }

    public EnvVars() {
        super(CaseInsensitiveComparator.INSTANCE);
    }

    public EnvVars(@NonNull Map<String, String> m) {
        this();
        this.putAll(m);
        if (m instanceof EnvVars) {
            EnvVars lhs = (EnvVars)m;
            this.platform = lhs.platform;
        }
    }

    public EnvVars(@NonNull EnvVars m) {
        this((Map<String, String>)m);
    }

    public EnvVars(String ... keyValuePairs) {
        this();
        if (keyValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException(Arrays.asList(keyValuePairs).toString());
        }
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            this.put(keyValuePairs[i], keyValuePairs[i + 1]);
        }
    }

    public void override(String key, String value) {
        if (value == null || value.length() == 0) {
            this.remove(key);
            return;
        }
        int idx = key.indexOf(43);
        if (idx > 0) {
            String realKey = key.substring(0, idx);
            String v = (String)this.get(realKey);
            if (v == null) {
                v = value;
            } else {
                char ch = this.platform == null ? File.pathSeparatorChar : this.platform.pathSeparator;
                v = value + ch + v;
            }
            this.put(realKey, v);
            return;
        }
        this.put(key, value);
    }

    public EnvVars overrideAll(Map<String, String> all) {
        for (Map.Entry<String, String> e : all.entrySet()) {
            this.override(e.getKey(), e.getValue());
        }
        return this;
    }

    public EnvVars overrideExpandingAll(@NonNull Map<String, String> all) {
        for (String key : new OverrideOrderCalculator(this, all).getOrderedVariableNames()) {
            this.override(key, this.expand(all.get(key)));
        }
        return this;
    }

    public static void resolve(Map<String, String> env) {
        for (Map.Entry<String, String> entry : env.entrySet()) {
            entry.setValue(Util.replaceMacro(entry.getValue(), env));
        }
    }

    public String get(String key, String defaultValue) {
        String v = (String)this.get(key);
        if (v == null) {
            v = defaultValue;
        }
        return v;
    }

    @Override
    public String put(String key, String value) {
        if (value == null) {
            throw new IllegalArgumentException("Null value not allowed as an environment variable: " + key);
        }
        return super.put(key, value);
    }

    public void putIfNotNull(String key, String value) {
        if (value != null) {
            this.put(key, value);
        }
    }

    public void putAllNonNull(Map<String, String> map) {
        map.forEach(this::putIfNotNull);
    }

    public void addLine(String line) {
        int sep = line.indexOf(61);
        if (sep > 0) {
            this.put(line.substring(0, sep), line.substring(sep + 1));
        }
    }

    public String expand(String s) {
        return Util.replaceMacro(s, this);
    }

    public static EnvVars createCookie() {
        return new EnvVars("HUDSON_COOKIE", UUID.randomUUID().toString());
    }

    public static EnvVars getRemote(VirtualChannel channel) throws IOException, InterruptedException {
        if (channel == null) {
            return new EnvVars("N/A", "N/A");
        }
        return (EnvVars)channel.call((Callable)new GetEnvVars());
    }

    private static EnvVars initMaster() {
        EnvVars vars = new EnvVars(System.getenv());
        vars.platform = Platform.current();
        if (Main.isUnitTest || Main.isDevelopmentMode) {
            vars.remove("MAVEN_OPTS");
        }
        return vars;
    }

    private static final class GetEnvVars
    extends MasterToSlaveCallable<EnvVars, RuntimeException> {
        private static final long serialVersionUID = 1L;

        private GetEnvVars() {
        }

        public EnvVars call() {
            return new EnvVars(masterEnvVars);
        }
    }

    static class OverrideOrderCalculator {
        private final Comparator<? super String> comparator;
        @NonNull
        private final EnvVars target;
        @NonNull
        private final Map<String, String> overrides;
        private Map<String, Set<String>> refereeSetMap;
        private List<String> orderedVariableNames;

        OverrideOrderCalculator(@NonNull EnvVars target, @NonNull Map<String, String> overrides) {
            this.comparator = target.comparator();
            this.target = target;
            this.overrides = overrides;
            this.scan();
        }

        public List<String> getOrderedVariableNames() {
            return this.orderedVariableNames;
        }

        private void cutCycleAt(String referee, List<String> cycle) {
            int refererIndex = cycle.lastIndexOf(referee) - 1;
            assert (refererIndex >= 0);
            String referrer = cycle.get(refererIndex);
            boolean removed = this.refereeSetMap.get(referrer).remove(referee);
            assert (removed);
            LOGGER.warning(String.format("Cyclic reference detected: %s", String.join((CharSequence)" -> ", cycle)));
            LOGGER.warning(String.format("Cut the reference %s -> %s", referrer, referee));
        }

        private void cutCycle(List<String> cycle) {
            for (String referee : cycle) {
                if (!this.target.containsKey(referee)) continue;
                this.cutCycleAt(referee, cycle);
                return;
            }
            this.cutCycleAt(cycle.get(0), cycle);
        }

        public void scan() {
            VariableReferenceSorter sorter;
            this.refereeSetMap = new TreeMap<String, Set<String>>(this.comparator);
            ArrayList<String> extendingVariableNames = new ArrayList<String>();
            TraceResolver resolver = new TraceResolver(this.comparator);
            for (Map.Entry<String, String> entry : this.overrides.entrySet()) {
                if (entry.getKey().indexOf(43) > 0) {
                    extendingVariableNames.add(entry.getKey());
                    continue;
                }
                resolver.clear();
                Util.replaceMacro(entry.getValue(), resolver);
                Set<String> refereeSet = resolver.referredVariables;
                refereeSet.remove(entry.getKey());
                this.refereeSetMap.put(entry.getKey(), refereeSet);
            }
            while (true) {
                sorter = new VariableReferenceSorter(this.refereeSetMap);
                try {
                    sorter.run(this.refereeSetMap.keySet());
                }
                catch (CyclicGraphDetector.CycleDetectedException e) {
                    List cycle = e.cycle;
                    this.cutCycle(cycle);
                    continue;
                }
                break;
            }
            ArrayList reversedDuplicatedOrder = new ArrayList(sorter.getSorted());
            Collections.reverse(reversedDuplicatedOrder);
            this.orderedVariableNames = new ArrayList<String>(this.overrides.size());
            for (String key : reversedDuplicatedOrder) {
                if (!this.overrides.containsKey(key) || this.orderedVariableNames.contains(key)) continue;
                this.orderedVariableNames.add(key);
            }
            Collections.reverse(this.orderedVariableNames);
            this.orderedVariableNames.addAll(extendingVariableNames);
        }

        private static class VariableReferenceSorter
        extends CyclicGraphDetector<String> {
            private final Map<String, Set<String>> refereeSetMap;

            VariableReferenceSorter(Map<String, Set<String>> refereeSetMap) {
                this.refereeSetMap = refereeSetMap;
            }

            @Override
            protected Iterable<? extends String> getEdges(String n) {
                if (!this.refereeSetMap.containsKey(n)) {
                    return Collections.emptySet();
                }
                return this.refereeSetMap.get(n);
            }
        }

        private static class TraceResolver
        implements VariableResolver<String> {
            private final Comparator<? super String> comparator;
            public Set<String> referredVariables;

            TraceResolver(Comparator<? super String> comparator) {
                this.comparator = comparator;
                this.clear();
            }

            public void clear() {
                this.referredVariables = new TreeSet<String>(this.comparator);
            }

            @Override
            public String resolve(String name) {
                this.referredVariables.add(name);
                return "";
            }
        }
    }
}

