/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import com.google.common.annotations.VisibleForTesting;
import com.jcraft.jzlib.GZIPOutputStream;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Functions;
import hudson.Launcher;
import hudson.Messages;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.os.PosixAPI;
import hudson.os.PosixException;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.DelegatingCallable;
import hudson.remoting.Future;
import hudson.remoting.LocalChannel;
import hudson.remoting.Pipe;
import hudson.remoting.RemoteInputStream;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.VirtualChannel;
import hudson.remoting.Which;
import hudson.security.AccessControlled;
import hudson.slaves.WorkspaceList;
import hudson.util.DaemonThreadFactory;
import hudson.util.DirScanner;
import hudson.util.ExceptionCatchingThreadFactory;
import hudson.util.FileVisitor;
import hudson.util.FormValidation;
import hudson.util.HeadBufferingStream;
import hudson.util.IOUtils;
import hudson.util.NamingThreadFactory;
import hudson.util.io.Archiver;
import hudson.util.io.ArchiverFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import jenkins.FilePathFilter;
import jenkins.MasterToSlaveFileCallable;
import jenkins.SlaveToMasterFileCallable;
import jenkins.SoloFilePathFilter;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import jenkins.util.ContextResettingExecutorService;
import jenkins.util.SystemProperties;
import jenkins.util.VirtualFile;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;
import org.jenkinsci.remoting.SerializableOnlyOverRemoting;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;

public final class FilePath
implements SerializableOnlyOverRemoting {
    private static final int MAX_REDIRECTS = 20;
    private transient VirtualChannel channel;
    private String remote;
    private static final Pattern DRIVE_PATTERN = Pattern.compile("[A-Za-z]:[\\\\/].*");
    private static final Pattern UNC_PATTERN = Pattern.compile("^\\\\\\\\.*");
    private static final Pattern ABSOLUTE_PREFIX_PATTERN = Pattern.compile("^(\\\\\\\\|(?:[A-Za-z]:)?[\\\\/])[\\\\/]*");
    private static boolean CHMOD_WARNED = false;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static int VALIDATE_ANT_FILE_MASK_BOUND = SystemProperties.getInteger(FilePath.class.getName() + ".VALIDATE_ANT_FILE_MASK_BOUND", 10000);
    private static final UrlFactory DEFAULT_URL_FACTORY = new UrlFactory();
    private UrlFactory urlFactory;
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static int SIDE_BUFFER_SIZE = 1024;
    private static final Logger LOGGER = Logger.getLogger(FilePath.class.getName());
    private static final Comparator<String> SHORTER_STRING_FIRST = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.length() - o2.length();
        }
    };
    private static final ExecutorService threadPoolForRemoting = new ContextResettingExecutorService(Executors.newCachedThreadPool(new ExceptionCatchingThreadFactory(new NamingThreadFactory(new DaemonThreadFactory(), "FilePath.localPool"))));
    @NonNull
    public static final LocalChannel localChannel = new LocalChannel(threadPoolForRemoting);
    private static final SoloFilePathFilter UNRESTRICTED = SoloFilePathFilter.wrap(FilePathFilter.UNRESTRICTED);

    public FilePath(@CheckForNull VirtualChannel channel, @NonNull String remote) {
        this.channel = channel instanceof LocalChannel ? null : channel;
        this.remote = FilePath.normalize(remote);
    }

    public FilePath(@NonNull File localPath) {
        this.channel = null;
        this.remote = FilePath.normalize(localPath.getPath());
    }

    public FilePath(@NonNull FilePath base, @NonNull String rel) {
        this.channel = base.channel;
        this.remote = FilePath.normalize(this.resolvePathIfRelative(base, rel));
    }

    private Object readResolve() {
        this.remote = FilePath.normalize(this.remote);
        return this;
    }

    private String resolvePathIfRelative(@NonNull FilePath base, @NonNull String rel) {
        if (FilePath.isAbsolute(rel)) {
            return rel;
        }
        if (base.isUnix()) {
            return base.remote + '/' + rel.replace('\\', '/');
        }
        return base.remote + '\\' + rel.replace('/', '\\');
    }

    private static boolean isAbsolute(@NonNull String rel) {
        return rel.startsWith("/") || DRIVE_PATTERN.matcher(rel).matches() || UNC_PATTERN.matcher(rel).matches();
    }

    @Restricted(value={NoExternalUse.class})
    public static String normalize(@NonNull String path) {
        int i;
        StringBuilder buf = new StringBuilder();
        Matcher m = ABSOLUTE_PREFIX_PATTERN.matcher(path);
        if (m.find()) {
            buf.append(m.group(1));
            path = path.substring(m.end());
        }
        boolean isAbsolute = buf.length() > 0;
        ArrayList<String> tokens = new ArrayList<String>();
        int s = 0;
        int end = path.length();
        for (i = 0; i < end; ++i) {
            char c = path.charAt(i);
            if (c != '/' && c != '\\') continue;
            tokens.add(path.substring(s, i));
            s = i;
            while (++i < end && ((c = path.charAt(i)) == '/' || c == '\\')) {
            }
            if (i < end) {
                tokens.add(path.substring(s, s + 1));
            }
            s = i;
        }
        if (s < end) {
            tokens.add(path.substring(s));
        }
        i = 0;
        while (i < tokens.size()) {
            String token = (String)tokens.get(i);
            if (token.equals(".")) {
                tokens.remove(i);
                if (tokens.size() <= 0) continue;
                tokens.remove(i > 0 ? i - 1 : i);
                continue;
            }
            if (token.equals("..")) {
                if (i == 0) {
                    tokens.remove(0);
                    if (tokens.size() > 0) {
                        token = token + (String)tokens.remove(0);
                    }
                    if (isAbsolute) continue;
                    buf.append(token);
                    continue;
                }
                i -= 2;
                for (int j = 0; j < 3; ++j) {
                    tokens.remove(i);
                }
                if (i > 0) {
                    tokens.remove(i - 1);
                    continue;
                }
                if (tokens.size() <= 0) continue;
                tokens.remove(0);
                continue;
            }
            i += 2;
        }
        for (String token : tokens) {
            buf.append(token);
        }
        if (buf.length() == 0) {
            buf.append('.');
        }
        return buf.toString();
    }

    boolean isUnix() {
        if (!this.isRemote()) {
            return File.pathSeparatorChar != ';';
        }
        if (this.remote.length() > 3 && this.remote.charAt(1) == ':' && this.remote.charAt(2) == '\\') {
            return false;
        }
        return !this.remote.contains("\\");
    }

    public String getRemote() {
        return this.remote;
    }

    @Deprecated
    public void createZipArchive(OutputStream os) throws IOException, InterruptedException {
        this.zip(os);
    }

    public void zip(OutputStream os) throws IOException, InterruptedException {
        this.zip(os, (FileFilter)null);
    }

    public void zip(FilePath dst) throws IOException, InterruptedException {
        try (OutputStream os = dst.write();){
            this.zip(os);
        }
    }

    public void zip(OutputStream os, FileFilter filter) throws IOException, InterruptedException {
        this.archive(ArchiverFactory.ZIP, os, filter);
    }

    @Deprecated
    public void createZipArchive(OutputStream os, String glob) throws IOException, InterruptedException {
        this.archive(ArchiverFactory.ZIP, os, glob);
    }

    public void zip(OutputStream os, String glob) throws IOException, InterruptedException {
        this.archive(ArchiverFactory.ZIP, os, glob);
    }

    public int zip(OutputStream out, DirScanner scanner) throws IOException, InterruptedException {
        return this.archive(ArchiverFactory.ZIP, out, scanner);
    }

    @Restricted(value={NoExternalUse.class})
    public int zip(OutputStream out, DirScanner scanner, String verificationRoot, boolean noFollowLinks, String prefix) throws IOException, InterruptedException {
        ArchiverFactory archiverFactory = noFollowLinks ? ArchiverFactory.createZipWithoutSymlink(prefix) : ArchiverFactory.ZIP;
        return this.archive(archiverFactory, out, scanner, verificationRoot, noFollowLinks);
    }

    public int archive(ArchiverFactory factory, OutputStream os, DirScanner scanner) throws IOException, InterruptedException {
        return this.archive(factory, os, scanner, null, false);
    }

    @Restricted(value={NoExternalUse.class})
    public int archive(ArchiverFactory factory, OutputStream os, DirScanner scanner, String verificationRoot, boolean noFollowLinks) throws IOException, InterruptedException {
        OutputStream out = this.channel != null ? new RemoteOutputStream(os) : os;
        return this.act(new Archive(factory, out, scanner, verificationRoot, noFollowLinks));
    }

    public int archive(ArchiverFactory factory, OutputStream os, FileFilter filter) throws IOException, InterruptedException {
        return this.archive(factory, os, new DirScanner.Filter(filter));
    }

    public int archive(ArchiverFactory factory, OutputStream os, String glob) throws IOException, InterruptedException {
        return this.archive(factory, os, new DirScanner.Glob(glob, null));
    }

    public void unzip(FilePath target) throws IOException, InterruptedException {
        if (this.channel != target.channel) {
            RemoteInputStream in = new RemoteInputStream(this.read(), RemoteInputStream.Flag.GREEDY);
            target.act(new UnzipRemote(in));
        } else {
            target.act(new UnzipLocal(this));
        }
    }

    public void untar(FilePath target, TarCompression compression) throws IOException, InterruptedException {
        FilePath source = this;
        if (source.channel != target.channel) {
            RemoteInputStream in = new RemoteInputStream(source.read(), RemoteInputStream.Flag.GREEDY);
            target.act(new UntarRemote(source.getName(), compression, in));
        } else {
            target.act(new UntarLocal(source, compression));
        }
    }

    public void unzipFrom(InputStream _in) throws IOException, InterruptedException {
        RemoteInputStream in = new RemoteInputStream(_in, RemoteInputStream.Flag.GREEDY);
        this.act(new UnzipFrom((InputStream)in));
    }

    private static void unzip(File dir, InputStream in) throws IOException {
        File tmpFile = File.createTempFile("tmpzip", null);
        try {
            IOUtils.copy(in, tmpFile);
            FilePath.unzip(dir, tmpFile);
        }
        finally {
            tmpFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(File dir, File zipFile) throws IOException {
        dir = dir.getAbsoluteFile();
        ZipFile zip = new ZipFile(zipFile);
        Enumeration entries = zip.getEntries();
        try {
            while (entries.hasMoreElements()) {
                ZipEntry e = (ZipEntry)entries.nextElement();
                File f = new File(dir, e.getName());
                if (!f.getCanonicalFile().toPath().startsWith(dir.getCanonicalPath())) {
                    throw new IOException("Zip " + zipFile.getPath() + " contains illegal file name that breaks out of the target directory: " + e.getName());
                }
                if (e.isDirectory()) {
                    FilePath.mkdirs(f);
                    continue;
                }
                File p = f.getParentFile();
                if (p != null) {
                    FilePath.mkdirs(p);
                }
                try (InputStream input = zip.getInputStream(e);){
                    IOUtils.copy(input, FilePath.writing(f));
                }
                try {
                    FilePath target = new FilePath(f);
                    int mode = e.getUnixMode();
                    if (mode != 0) {
                        target.chmod(mode);
                    }
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.WARNING, "unable to set permissions", ex);
                }
                f.setLastModified(e.getTime());
            }
        }
        finally {
            zip.close();
        }
    }

    public FilePath absolutize() throws IOException, InterruptedException {
        return new FilePath(this.channel, this.act(new Absolutize()));
    }

    @Restricted(value={NoExternalUse.class})
    public boolean hasSymlink(FilePath verificationRoot, boolean noFollowLinks) throws IOException, InterruptedException {
        return this.act(new HasSymlink(verificationRoot == null ? null : verificationRoot.remote, noFollowLinks));
    }

    @Restricted(value={NoExternalUse.class})
    public boolean containsSymlink(FilePath verificationRoot, boolean noFollowLinks) throws IOException, InterruptedException {
        return !this.list(new SymlinkRetainingFileFilter(verificationRoot, noFollowLinks)).isEmpty();
    }

    public void symlinkTo(String target, TaskListener listener) throws IOException, InterruptedException {
        this.act(new SymlinkTo(target, listener));
    }

    public String readLink() throws IOException, InterruptedException {
        return this.act(new ReadLink());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilePath that = (FilePath)o;
        if (!Objects.equals(this.channel, that.channel)) {
            return false;
        }
        return this.remote.equals(that.remote);
    }

    public int hashCode() {
        return 31 * (this.channel != null ? this.channel.hashCode() : 0) + this.remote.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void untarFrom(InputStream _in, TarCompression compression) throws IOException, InterruptedException {
        try {
            RemoteInputStream in = new RemoteInputStream(_in, RemoteInputStream.Flag.GREEDY);
            this.act(new UntarFrom(compression, (InputStream)in));
        }
        finally {
            _in.close();
        }
    }

    public boolean installIfNecessaryFrom(@NonNull URL archive, @CheckForNull TaskListener listener, @NonNull String message) throws IOException, InterruptedException {
        if (listener == null) {
            listener = TaskListener.NULL;
        }
        return this.installIfNecessaryFrom(archive, listener, message, 20);
    }

    private boolean installIfNecessaryFrom(@NonNull URL archive, @NonNull TaskListener listener, @NonNull String message, int maxRedirects) throws InterruptedException, IOException {
        try {
            URLConnection con;
            FilePath timestamp = this.child(".timestamp");
            long lastModified = timestamp.lastModified();
            try {
                con = ProxyConfiguration.open(archive);
                if (lastModified != 0L) {
                    con.setIfModifiedSince(lastModified);
                }
                con.connect();
            }
            catch (IOException x) {
                if (this.exists()) {
                    listener.getLogger().println("Skipping installation of " + archive + " to " + this.remote + ": " + x);
                    return false;
                }
                throw x;
            }
            if (con instanceof HttpURLConnection) {
                HttpURLConnection httpCon = (HttpURLConnection)con;
                int responseCode = httpCon.getResponseCode();
                if (responseCode == 301 || responseCode == 302) {
                    if (maxRedirects > 0) {
                        String location = httpCon.getHeaderField("Location");
                        listener.getLogger().println("Following redirect " + archive.toExternalForm() + " -> " + location);
                        return this.installIfNecessaryFrom(this.getUrlFactory().newURL(location), listener, message, maxRedirects - 1);
                    }
                    listener.getLogger().println("Skipping installation of " + archive + " to " + this.remote + " due to too many redirects.");
                    return false;
                }
                if (lastModified != 0L) {
                    if (responseCode == 304) {
                        return false;
                    }
                    if (responseCode != 200) {
                        listener.getLogger().println("Skipping installation of " + archive + " to " + this.remote + " due to server error: " + responseCode + " " + httpCon.getResponseMessage());
                        return false;
                    }
                }
            }
            long sourceTimestamp = con.getLastModified();
            if (this.exists()) {
                if (lastModified != 0L && sourceTimestamp == lastModified) {
                    return false;
                }
                this.deleteContents();
            } else {
                this.mkdirs();
            }
            listener.getLogger().println(message);
            if (this.isRemote()) {
                try {
                    this.act(new Unpack(archive));
                    timestamp.touch(sourceTimestamp);
                    return true;
                }
                catch (IOException x) {
                    Functions.printStackTrace((Throwable)x, listener.error("Failed to download " + archive + " from agent; will retry from master"));
                }
            }
            InputStream in = archive.getProtocol().startsWith("http") ? ProxyConfiguration.getInputStream(archive) : con.getInputStream();
            CountingInputStream cis = new CountingInputStream(in);
            try {
                if (archive.toExternalForm().endsWith(".zip")) {
                    this.unzipFrom((InputStream)cis);
                } else {
                    this.untarFrom((InputStream)cis, TarCompression.GZIP);
                }
            }
            catch (IOException e) {
                throw new IOException(String.format("Failed to unpack %s (%d bytes read of total %d)", archive, cis.getByteCount(), con.getContentLength()), e);
            }
            timestamp.touch(sourceTimestamp);
            return true;
        }
        catch (IOException e) {
            throw new IOException("Failed to install " + archive + " to " + this.remote, e);
        }
    }

    public void copyFrom(URL url) throws IOException, InterruptedException {
        try (InputStream in = url.openStream();){
            this.copyFrom(in);
        }
    }

    public void copyFrom(InputStream in) throws IOException, InterruptedException {
        try (OutputStream os = this.write();){
            org.apache.commons.io.IOUtils.copy((InputStream)in, (OutputStream)os);
        }
    }

    public void copyFrom(FilePath src) throws IOException, InterruptedException {
        src.copyTo(this);
    }

    public void copyFrom(FileItem file) throws IOException, InterruptedException {
        if (this.channel == null) {
            try {
                file.write(FilePath.writing(new File(this.remote)));
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        try (InputStream i = file.getInputStream();
             OutputStream o = this.write();){
            org.apache.commons.io.IOUtils.copy((InputStream)i, (OutputStream)o);
        }
    }

    public <T> T act(FileCallable<T> callable) throws IOException, InterruptedException {
        return this.act(callable, callable.getClass().getClassLoader());
    }

    private <T> T act(FileCallable<T> callable, ClassLoader cl) throws IOException, InterruptedException {
        if (this.channel != null) {
            try {
                FileCallableWrapper wrapper = new FileCallableWrapper(callable, cl, this);
                for (FileCallableWrapperFactory factory : ExtensionList.lookup(FileCallableWrapperFactory.class)) {
                    wrapper = factory.wrap(wrapper);
                }
                return (T)this.channel.call(wrapper);
            }
            catch (TunneledInterruptedException e) {
                throw (InterruptedException)new InterruptedException(e.getMessage()).initCause(e);
            }
        }
        return callable.invoke(new File(this.remote), (VirtualChannel)localChannel);
    }

    public <T> Future<T> actAsync(FileCallable<T> callable) throws IOException, InterruptedException {
        try {
            FileCallableWrapper<T> wrapper = new FileCallableWrapper<T>(callable, this);
            for (FileCallableWrapperFactory factory : ExtensionList.lookup(FileCallableWrapperFactory.class)) {
                wrapper = factory.wrap(wrapper);
            }
            return (this.channel != null ? this.channel : localChannel).callAsync(wrapper);
        }
        catch (IOException e) {
            throw new IOException("remote file operation failed", e);
        }
    }

    public <V, E extends Throwable> V act(Callable<V, E> callable) throws IOException, InterruptedException, E {
        if (this.channel != null) {
            return (V)this.channel.call(callable);
        }
        return (V)callable.call();
    }

    public <V> Callable<V, IOException> asCallableWith(FileCallable<V> task) {
        return new CallableWith<V>(task);
    }

    public URI toURI() throws IOException, InterruptedException {
        return this.act(new ToURI());
    }

    public VirtualFile toVirtualFile() {
        return VirtualFile.forFilePath(this);
    }

    @CheckForNull
    public Computer toComputer() {
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j != null) {
            for (Computer c : j.getComputers()) {
                if (this.getChannel() != c.getChannel()) continue;
                return c;
            }
        }
        return null;
    }

    public void mkdirs() throws IOException, InterruptedException {
        if (!this.act(new Mkdirs()).booleanValue()) {
            throw new IOException("Failed to mkdirs: " + this.remote);
        }
    }

    public void deleteSuffixesRecursive() throws IOException, InterruptedException {
        this.act(new DeleteSuffixesRecursive());
    }

    private static File[] listParentFiles(File f) {
        File[] files;
        File parentFile = f.getParentFile();
        if (parentFile != null && (files = parentFile.listFiles()) != null) {
            return files;
        }
        return new File[0];
    }

    public void deleteRecursive() throws IOException, InterruptedException {
        this.act(new DeleteRecursive());
    }

    public void deleteContents() throws IOException, InterruptedException {
        this.act(new DeleteContents());
    }

    public String getBaseName() {
        String n = this.getName();
        int idx = n.lastIndexOf(46);
        if (idx < 0) {
            return n;
        }
        return n.substring(0, idx);
    }

    public String getName() {
        char ch;
        int len;
        String r = this.remote;
        if (r.endsWith("\\") || r.endsWith("/")) {
            r = r.substring(0, r.length() - 1);
        }
        for (len = r.length() - 1; len >= 0 && (ch = r.charAt(len)) != '\\' && ch != '/'; --len) {
        }
        return r.substring(len + 1);
    }

    @CheckForNull
    public FilePath sibling(String rel) {
        FilePath parent = this.getParent();
        return parent != null ? parent.child(rel) : null;
    }

    public FilePath withSuffix(String suffix) {
        return new FilePath(this.channel, this.remote + suffix);
    }

    @NonNull
    public FilePath child(String relOrAbsolute) {
        return new FilePath(this, relOrAbsolute);
    }

    @CheckForNull
    public FilePath getParent() {
        char ch;
        int i;
        for (i = this.remote.length() - 2; i >= 0 && (ch = this.remote.charAt(i)) != '\\' && ch != '/'; --i) {
        }
        return i >= 0 ? new FilePath(this.channel, this.remote.substring(0, i + 1)) : null;
    }

    public FilePath createTempFile(String prefix, String suffix) throws IOException, InterruptedException {
        try {
            return new FilePath(this, this.act(new CreateTempFile(prefix, suffix)));
        }
        catch (IOException e) {
            throw new IOException("Failed to create a temp file on " + this.remote, e);
        }
    }

    public FilePath createTextTempFile(String prefix, String suffix, String contents) throws IOException, InterruptedException {
        return this.createTextTempFile(prefix, suffix, contents, true);
    }

    public FilePath createTextTempFile(String prefix, String suffix, String contents, boolean inThisDirectory) throws IOException, InterruptedException {
        try {
            return new FilePath(this.channel, this.act(new CreateTextTempFile(inThisDirectory, prefix, suffix, contents)));
        }
        catch (IOException e) {
            throw new IOException("Failed to create a temp file on " + this.remote, e);
        }
    }

    public FilePath createTempDir(String prefix, String suffix) throws IOException, InterruptedException {
        try {
            Object[] s = StringUtils.isBlank((String)suffix) ? new String[]{prefix, "tmp"} : new String[]{prefix, suffix};
            String name = StringUtils.join((Object[])s, (String)".");
            return new FilePath(this, this.act(new CreateTempDir(name)));
        }
        catch (IOException e) {
            throw new IOException("Failed to create a temp directory on " + this.remote, e);
        }
    }

    public boolean delete() throws IOException, InterruptedException {
        this.act(new Delete());
        return true;
    }

    public boolean exists() throws IOException, InterruptedException {
        return this.act(new Exists());
    }

    public long lastModified() throws IOException, InterruptedException {
        return this.act(new LastModified());
    }

    public void touch(long timestamp) throws IOException, InterruptedException {
        this.act(new Touch(timestamp));
    }

    private void setLastModifiedIfPossible(long timestamp) throws IOException, InterruptedException {
        String message = this.act(new SetLastModified(timestamp));
        if (message != null) {
            LOGGER.warning(message);
        }
    }

    public boolean isDirectory() throws IOException, InterruptedException {
        return this.act(new IsDirectory());
    }

    public long length() throws IOException, InterruptedException {
        return this.act(new Length());
    }

    public long getFreeDiskSpace() throws IOException, InterruptedException {
        return this.act(new GetFreeDiskSpace());
    }

    public long getTotalDiskSpace() throws IOException, InterruptedException {
        return this.act(new GetTotalDiskSpace());
    }

    public long getUsableDiskSpace() throws IOException, InterruptedException {
        return this.act(new GetUsableDiskSpace());
    }

    public void chmod(int mask) throws IOException, InterruptedException {
        if (!this.isUnix() || mask == -1) {
            return;
        }
        this.act(new Chmod(mask));
    }

    private static void _chmod(File f, int mask) throws IOException {
        if (File.pathSeparatorChar == ';') {
            return;
        }
        if (Util.NATIVE_CHMOD_MODE) {
            PosixAPI.jnr().chmod(f.getAbsolutePath(), mask);
        } else {
            Files.setPosixFilePermissions(Util.fileToPath(f), Util.modeToPermissions(mask));
        }
    }

    public int mode() throws IOException, InterruptedException, PosixException {
        if (!this.isUnix()) {
            return -1;
        }
        return this.act(new Mode());
    }

    @NonNull
    public List<FilePath> list() throws IOException, InterruptedException {
        return this.list((FileFilter)null);
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public List<FilePath> list(FilePath verificationRoot, boolean noFollowLinks) throws IOException, InterruptedException {
        return this.list(new SymlinkDiscardingFileFilter(verificationRoot, noFollowLinks));
    }

    @NonNull
    public List<FilePath> listDirectories() throws IOException, InterruptedException {
        return this.list(new DirectoryFilter());
    }

    @NonNull
    public List<FilePath> list(FileFilter filter) throws IOException, InterruptedException {
        if (filter != null && !(filter instanceof Serializable)) {
            throw new IllegalArgumentException("Non-serializable filter of " + filter.getClass());
        }
        return this.act(new ListFilter(filter), (filter != null ? filter : this).getClass().getClassLoader());
    }

    @NonNull
    public FilePath[] list(String includes) throws IOException, InterruptedException {
        return this.list(includes, null);
    }

    @NonNull
    public FilePath[] list(String includes, String excludes) throws IOException, InterruptedException {
        return this.list(includes, excludes, true);
    }

    @NonNull
    public FilePath[] list(String includes, String excludes, boolean defaultExcludes) throws IOException, InterruptedException {
        return this.act(new ListGlob(includes, excludes, defaultExcludes));
    }

    @NonNull
    private static String[] glob(File dir, String includes, String excludes, boolean defaultExcludes) throws IOException {
        DirectoryScanner ds;
        if (FilePath.isAbsolute(includes)) {
            throw new IOException("Expecting Ant GLOB pattern, but saw '" + includes + "'. See http://ant.apache.org/manual/Types/fileset.html for syntax");
        }
        FileSet fs = Util.createFileSet(dir, includes, excludes);
        fs.setDefaultexcludes(defaultExcludes);
        try {
            ds = fs.getDirectoryScanner(new Project());
        }
        catch (BuildException x) {
            throw new IOException(x.getMessage());
        }
        return ds.getIncludedFiles();
    }

    public InputStream read() throws IOException, InterruptedException {
        return this.read(null, false);
    }

    @Restricted(value={NoExternalUse.class})
    public InputStream read(FilePath rootPath, boolean noFollowLinks) throws IOException, InterruptedException {
        String rootPathString;
        String string = rootPathString = rootPath == null ? null : rootPath.remote;
        if (this.channel == null) {
            File file = FilePath.reading(new File(this.remote));
            InputStream inputStream = FilePath.newInputStreamDenyingSymlinkAsNeeded(file, rootPathString, noFollowLinks);
            return inputStream;
        }
        Pipe p = Pipe.createRemoteToLocal();
        this.actAsync(new Read(p, rootPathString, noFollowLinks));
        return p.getIn();
    }

    @Restricted(value={NoExternalUse.class})
    public static InputStream newInputStreamDenyingSymlinkAsNeeded(File file, String verificationRoot, boolean noFollowLinks) throws IOException {
        InputStream inputStream = null;
        try {
            FilePath.denySymlink(file, verificationRoot, noFollowLinks);
            inputStream = noFollowLinks ? Files.newInputStream(Util.fileToPath(file), LinkOption.NOFOLLOW_LINKS) : Files.newInputStream(Util.fileToPath(file), new OpenOption[0]);
            FilePath.denySymlink(file, verificationRoot, noFollowLinks);
        }
        catch (IOException ioe) {
            if (inputStream != null) {
                inputStream.close();
            }
            throw ioe;
        }
        return inputStream;
    }

    private static void denySymlink(File file, String root, boolean noFollowLinks) throws IOException {
        if (FilePath.isSymlink(file, root, noFollowLinks)) {
            throw new IOException("Symlinks are prohibited.");
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static boolean isSymlink(File file, String root, boolean noFollowLinks) {
        if (noFollowLinks) {
            if (Util.isSymlink(file.toPath())) {
                return true;
            }
            return FilePath.isFileAncestorSymlink(file, root);
        }
        return false;
    }

    private static boolean isFileAncestorSymlink(File file, String root) {
        if (root != null) {
            Path rootPath = Paths.get(root, new String[0]);
            Path currPath = file.toPath();
            try {
                while (!FilePath.getRealPath(currPath).equals(FilePath.getRealPath(rootPath))) {
                    if (Util.isSymlink(currPath)) {
                        return true;
                    }
                    if ((currPath = currPath.getParent()) != null) continue;
                    return false;
                }
            }
            catch (IOException ioe) {
                return false;
            }
        }
        return false;
    }

    public InputStream readFromOffset(long offset) throws IOException, InterruptedException {
        if (this.channel == null) {
            final RandomAccessFile raf = new RandomAccessFile(new File(this.remote), "r");
            try {
                raf.seek(offset);
            }
            catch (IOException e) {
                try {
                    raf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw e;
            }
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    return raf.read();
                }

                @Override
                public void close() throws IOException {
                    raf.close();
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    return raf.read(b, off, len);
                }

                @Override
                public int read(byte[] b) throws IOException {
                    return raf.read(b);
                }
            };
        }
        Pipe p = Pipe.createRemoteToLocal();
        this.actAsync(new OffsetPipeSecureFileCallable(p, offset));
        return new GZIPInputStream(p.getIn());
    }

    public String readToString() throws IOException, InterruptedException {
        return this.act(new ReadToString());
    }

    public OutputStream write() throws IOException, InterruptedException {
        if (this.channel == null) {
            File f = new File(this.remote).getAbsoluteFile();
            FilePath.mkdirs(f.getParentFile());
            return Files.newOutputStream(Util.fileToPath(FilePath.writing(f)), new OpenOption[0]);
        }
        return this.act(new WritePipe());
    }

    public void write(String content, String encoding) throws IOException, InterruptedException {
        this.act(new Write(encoding, content));
    }

    public String digest() throws IOException, InterruptedException {
        return this.act(new Digest());
    }

    public void renameTo(FilePath target) throws IOException, InterruptedException {
        if (this.channel != target.channel) {
            throw new IOException("renameTo target must be on the same host");
        }
        this.act(new RenameTo(target));
    }

    public void moveAllChildrenTo(FilePath target) throws IOException, InterruptedException {
        if (this.channel != target.channel) {
            throw new IOException("pullUpTo target must be on the same host");
        }
        this.act(new MoveAllChildrenTo(target));
    }

    public void copyTo(FilePath target) throws IOException, InterruptedException {
        try (OutputStream out = target.write();){
            this.copyTo(out);
        }
        catch (IOException e) {
            throw new IOException("Failed to copy " + this + " to " + target, e);
        }
    }

    public void copyToWithPermission(FilePath target) throws IOException, InterruptedException {
        if (this.channel == target.channel) {
            this.act(new CopyToWithPermission(target));
            return;
        }
        this.copyTo(target);
        target.chmod(this.mode());
        target.setLastModifiedIfPossible(this.lastModified());
    }

    public void copyTo(OutputStream os) throws IOException, InterruptedException {
        RemoteOutputStream out = new RemoteOutputStream(os);
        this.act(new CopyTo((OutputStream)out));
        this.syncIO();
    }

    private void syncIO() throws InterruptedException {
        try {
            if (this.channel != null) {
                this.channel.syncLocalIO();
            }
        }
        catch (AbstractMethodError e) {
            try {
                LOGGER.log(Level.WARNING, "Looks like an old agent.jar. Please update " + Which.jarFile(Channel.class) + " to the new version", e);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void _syncIO() throws InterruptedException {
        this.channel.syncLocalIO();
    }

    public int copyRecursiveTo(FilePath target) throws IOException, InterruptedException {
        return this.copyRecursiveTo("**/*", target);
    }

    public int copyRecursiveTo(String fileMask, FilePath target) throws IOException, InterruptedException {
        return this.copyRecursiveTo(fileMask, null, target);
    }

    public int copyRecursiveTo(String fileMask, String excludes, FilePath target) throws IOException, InterruptedException {
        return this.copyRecursiveTo(new DirScanner.Glob(fileMask, excludes), target, fileMask);
    }

    public int copyRecursiveTo(DirScanner scanner, FilePath target, String description) throws IOException, InterruptedException {
        return this.copyRecursiveTo(scanner, target, description, TarCompression.GZIP);
    }

    public int copyRecursiveTo(DirScanner scanner, FilePath target, String description, @NonNull TarCompression compression) throws IOException, InterruptedException {
        if (this.channel == target.channel) {
            return this.act(new CopyRecursiveLocal(target, scanner));
        }
        if (this.channel == null) {
            Pipe pipe = Pipe.createLocalToRemote();
            Future<Void> future = target.actAsync(new ReadFromTar(target, pipe, description, compression));
            Future<Integer> future2 = this.actAsync(new WriteToTar(scanner, pipe, compression));
            try {
                future.get();
                return (Integer)future2.get();
            }
            catch (ExecutionException e) {
                throw this.ioWithCause(e);
            }
        }
        Pipe pipe = Pipe.createRemoteToLocal();
        Future<Integer> future = this.actAsync(new CopyRecursiveRemoteToLocal(pipe, scanner, compression));
        try {
            FilePath.readFromTar(this.remote + '/' + description, new File(target.remote), compression.extract(pipe.getIn()));
        }
        catch (IOException e) {
            try {
                future.get(3L, TimeUnit.SECONDS);
                throw e;
            }
            catch (ExecutionException x) {
                e.addSuppressed(x);
                throw e;
            }
            catch (TimeoutException ignored) {
                throw e;
            }
        }
        try {
            return (Integer)future.get();
        }
        catch (ExecutionException e) {
            throw this.ioWithCause(e);
        }
    }

    private IOException ioWithCause(ExecutionException e) {
        Throwable cause = e.getCause();
        if (cause == null) {
            cause = e;
        }
        return cause instanceof IOException ? (IOException)cause : new IOException(cause);
    }

    public int tar(OutputStream out, String glob) throws IOException, InterruptedException {
        return this.archive(ArchiverFactory.TAR, out, glob);
    }

    public int tar(OutputStream out, FileFilter filter) throws IOException, InterruptedException {
        return this.archive(ArchiverFactory.TAR, out, filter);
    }

    public int tar(OutputStream out, DirScanner scanner) throws IOException, InterruptedException {
        return this.archive(ArchiverFactory.TAR, out, scanner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Integer writeToTar(File baseDir, DirScanner scanner, OutputStream out) throws IOException {
        try (Archiver tw = ArchiverFactory.TAR.create(out);){
            scanner.scan(baseDir, FilePath.reading(tw));
        }
        return tw.countEntries();
    }

    private static void readFromTar(String name, File baseDir, InputStream in) throws IOException {
        baseDir = baseDir.getCanonicalFile();
        try (TarArchiveInputStream t = new TarArchiveInputStream(in);){
            TarArchiveEntry te;
            while ((te = t.getNextTarEntry()) != null) {
                File f = new File(baseDir, te.getName()).getCanonicalFile();
                if (!f.toPath().startsWith(baseDir.toPath())) {
                    throw new IOException("Tar " + name + " contains illegal file name that breaks out of the target directory: " + te.getName());
                }
                if (te.isDirectory()) {
                    FilePath.mkdirs(f);
                    continue;
                }
                File parent = f.getParentFile();
                if (parent != null) {
                    FilePath.mkdirs(parent);
                }
                if (te.isSymbolicLink()) {
                    new FilePath(FilePath.symlinking(f)).symlinkTo(te.getLinkName(), TaskListener.NULL);
                    continue;
                }
                IOUtils.copy((InputStream)t, FilePath.writing(f));
                f.setLastModified(te.getModTime().getTime());
                int mode = te.getMode() & 0x1FF;
                if (mode == 0 || Functions.isWindows()) continue;
                FilePath._chmod(f, mode);
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to extract " + name, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Failed to extract " + name, e);
        }
    }

    public Launcher createLauncher(TaskListener listener) throws IOException, InterruptedException {
        if (this.channel == null) {
            return new Launcher.LocalLauncher(listener);
        }
        return new Launcher.RemoteLauncher(listener, this.channel, (Boolean)this.channel.call((Callable)new IsUnix()));
    }

    @Deprecated
    public String validateAntFileMask(String fileMasks) throws IOException, InterruptedException {
        return this.validateAntFileMask(fileMasks, Integer.MAX_VALUE);
    }

    public String validateAntFileMask(String fileMasks, int bound) throws IOException, InterruptedException {
        return this.validateAntFileMask(fileMasks, bound, true);
    }

    @CheckForNull
    public String validateAntFileMask(String fileMasks, int bound, boolean caseSensitive) throws IOException, InterruptedException {
        return this.act(new ValidateAntFileMask(fileMasks, caseSensitive, bound));
    }

    @Restricted(value={NoExternalUse.class})
    @VisibleForTesting
    void setUrlFactory(UrlFactory urlFactory) {
        this.urlFactory = urlFactory;
    }

    private UrlFactory getUrlFactory() {
        if (this.urlFactory != null) {
            return this.urlFactory;
        }
        return DEFAULT_URL_FACTORY;
    }

    public static FormValidation validateFileMask(@CheckForNull FilePath path, String value) throws IOException {
        return FilePath.validateFileMask(path, value, true);
    }

    public static FormValidation validateFileMask(@CheckForNull FilePath path, String value, boolean caseSensitive) throws IOException {
        if (path == null) {
            return FormValidation.ok();
        }
        return path.validateFileMask(value, true, caseSensitive);
    }

    public FormValidation validateFileMask(String value) throws IOException {
        return this.validateFileMask(value, true, true);
    }

    public FormValidation validateFileMask(String value, boolean errorIfNotExist) throws IOException {
        return this.validateFileMask(value, errorIfNotExist, true);
    }

    public FormValidation validateFileMask(String value, boolean errorIfNotExist, boolean caseSensitive) throws IOException {
        FilePath.checkPermissionForValidate();
        value = Util.fixEmpty(value);
        if (value == null) {
            return FormValidation.ok();
        }
        try {
            if (!this.exists()) {
                return FormValidation.ok();
            }
            String msg = this.validateAntFileMask(value, VALIDATE_ANT_FILE_MASK_BOUND, caseSensitive);
            if (errorIfNotExist) {
                return FormValidation.error(msg);
            }
            return FormValidation.warning(msg);
        }
        catch (InterruptedException e) {
            return FormValidation.ok(Messages.FilePath_did_not_manage_to_validate_may_be_too_sl(value));
        }
    }

    public FormValidation validateRelativePath(String value, boolean errorIfNotExist, boolean expectingFile) throws IOException {
        FilePath.checkPermissionForValidate();
        value = Util.fixEmpty(value);
        if (value == null) {
            return FormValidation.ok();
        }
        if (value.contains("*")) {
            return FormValidation.error(Messages.FilePath_validateRelativePath_wildcardNotAllowed());
        }
        try {
            String msg;
            if (!this.exists()) {
                return FormValidation.ok();
            }
            FilePath path = this.child(value);
            if (path.exists()) {
                if (expectingFile) {
                    if (!path.isDirectory()) {
                        return FormValidation.ok();
                    }
                    return FormValidation.error(Messages.FilePath_validateRelativePath_notFile(value));
                }
                if (path.isDirectory()) {
                    return FormValidation.ok();
                }
                return FormValidation.error(Messages.FilePath_validateRelativePath_notDirectory(value));
            }
            String string = msg = expectingFile ? Messages.FilePath_validateRelativePath_noSuchFile(value) : Messages.FilePath_validateRelativePath_noSuchDirectory(value);
            if (errorIfNotExist) {
                return FormValidation.error(msg);
            }
            return FormValidation.warning(msg);
        }
        catch (InterruptedException e) {
            return FormValidation.ok();
        }
    }

    private static void checkPermissionForValidate() {
        AccessControlled subject = (AccessControlled)Stapler.getCurrentRequest().findAncestorObject(AbstractProject.class);
        if (subject == null) {
            Jenkins.get().checkPermission(Jenkins.MANAGE);
        } else {
            subject.checkPermission(Item.CONFIGURE);
        }
    }

    public FormValidation validateRelativeDirectory(String value, boolean errorIfNotExist) throws IOException {
        return this.validateRelativePath(value, errorIfNotExist, false);
    }

    public FormValidation validateRelativeDirectory(String value) throws IOException {
        return this.validateRelativeDirectory(value, true);
    }

    @Deprecated
    public String toString() {
        return this.remote;
    }

    public VirtualChannel getChannel() {
        if (this.channel != null) {
            return this.channel;
        }
        return localChannel;
    }

    public boolean isRemote() {
        return this.channel != null;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        Channel target = this._getChannelForSerialization();
        if (this.channel != null && this.channel != target) {
            throw new IllegalStateException("Can't send a remote FilePath to a different remote channel (current=" + this.channel + ", target=" + target + ")");
        }
        oos.defaultWriteObject();
        oos.writeBoolean(this.channel == null);
    }

    private Channel _getChannelForSerialization() {
        try {
            return this.getChannelForSerialization();
        }
        catch (NotSerializableException x) {
            LOGGER.log(Level.WARNING, "A FilePath object is being serialized when it should not be, indicating a bug in a plugin. See https://www.jenkins.io/redirect/filepath-serialization for details.", x);
            return null;
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Channel channel = this._getChannelForSerialization();
        ois.defaultReadObject();
        this.channel = ois.readBoolean() ? channel : null;
    }

    public static FilePath getHomeDirectory(VirtualChannel ch) throws InterruptedException, IOException {
        return (FilePath)ch.call((Callable)new GetHomeDirectory());
    }

    @NonNull
    private static SoloFilePathFilter filterNonNull() {
        SoloFilePathFilter filter = SoloFilePathFilter.wrap(FilePathFilter.current());
        return filter != null ? filter : UNRESTRICTED;
    }

    private static FileVisitor reading(final FileVisitor v) {
        final SoloFilePathFilter filter = SoloFilePathFilter.wrap(FilePathFilter.current());
        if (filter == null) {
            return v;
        }
        return new FileVisitor(){

            @Override
            public void visit(File f, String relativePath) throws IOException {
                filter.read(f);
                v.visit(f, relativePath);
            }

            @Override
            public void visitSymlink(File link, String target, String relativePath) throws IOException {
                filter.read(link);
                v.visitSymlink(link, target, relativePath);
            }

            @Override
            public boolean understandsSymlink() {
                return v.understandsSymlink();
            }
        };
    }

    @Restricted(value={NoExternalUse.class})
    public static FileVisitor ignoringSymlinks(final FileVisitor v, final String verificationRoot, final boolean noFollowLinks) {
        if (noFollowLinks) {
            return new FileVisitor(){

                @Override
                public void visit(File f, String relativePath) throws IOException {
                    if (verificationRoot == null || !FilePath.isSymlink(f, verificationRoot, noFollowLinks)) {
                        v.visit(f, relativePath);
                    }
                }

                @Override
                public boolean understandsSymlink() {
                    return false;
                }
            };
        }
        return v;
    }

    private static File reading(File f) {
        FilePath.filterNonNull().read(f);
        return f;
    }

    private static File stating(File f) {
        FilePath.filterNonNull().stat(f);
        return f;
    }

    private static File creating(File f) {
        FilePath.filterNonNull().create(f);
        return f;
    }

    private static File writing(File f) {
        SoloFilePathFilter filter = FilePath.filterNonNull();
        if (!f.exists()) {
            ((FilePathFilter)filter).create(f);
        }
        ((FilePathFilter)filter).write(f);
        return f;
    }

    private static File symlinking(File f) {
        SoloFilePathFilter filter = FilePath.filterNonNull();
        if (!f.exists()) {
            ((FilePathFilter)filter).create(f);
        }
        ((FilePathFilter)filter).symlink(f);
        return f;
    }

    private static File deleting(File f) {
        FilePath.filterNonNull().delete(f);
        return f;
    }

    private static File mkdirsing(File f) {
        FilePath.filterNonNull().mkdirs(f);
        return f;
    }

    private static boolean mkdirs(File dir) throws IOException {
        if (dir.exists()) {
            return false;
        }
        for (File reference = dir; reference != null && !reference.exists(); reference = reference.getParentFile()) {
            FilePath.filterNonNull().mkdirs(reference);
        }
        Files.createDirectories(Util.fileToPath(dir), new FileAttribute[0]);
        return true;
    }

    private static File mkdirsE(File dir) throws IOException {
        if (dir.exists()) {
            return dir;
        }
        for (File reference = dir; reference != null && !reference.exists(); reference = reference.getParentFile()) {
            FilePath.filterNonNull().mkdirs(reference);
        }
        return IOUtils.mkdirs(dir);
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isDescendant(@NonNull String potentialChildRelativePath) throws IOException, InterruptedException {
        return this.act(new IsDescendant(potentialChildRelativePath));
    }

    private static Path getRealPath(Path path) throws IOException {
        return Functions.isWindows() ? FilePath.windowsToRealPath(path) : path.toRealPath(new LinkOption[0]);
    }

    @NonNull
    private static Path windowsToRealPath(@NonNull Path path) throws IOException {
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, String.format("relaxedToRealPath cannot use the regular toRealPath on %s, trying with toRealPath(LinkOption.NOFOLLOW_LINKS)", path), e);
            }
            return path.toRealPath(LinkOption.NOFOLLOW_LINKS);
        }
    }

    private static class SymlinkDiscardingFileFilter
    implements FileFilter,
    Serializable {
        private final String verificationRoot;
        private final boolean noFollowLinks;
        private static final long serialVersionUID = 1L;

        SymlinkDiscardingFileFilter(FilePath verificationRoot, boolean noFollowLinks) {
            this.verificationRoot = verificationRoot == null ? null : verificationRoot.remote;
            this.noFollowLinks = noFollowLinks;
        }

        @Override
        public boolean accept(File file) {
            return !FilePath.isSymlink(file, this.verificationRoot, this.noFollowLinks);
        }
    }

    private static class IsDescendant
    extends SecureFileCallable<Boolean> {
        private static final long serialVersionUID = 1L;
        private String potentialChildRelativePath;

        private IsDescendant(@NonNull String potentialChildRelativePath) {
            this.potentialChildRelativePath = potentialChildRelativePath;
        }

        @Override
        public Boolean invoke(@NonNull File parentFile, @NonNull VirtualChannel channel) throws IOException, InterruptedException {
            Path parentRealPath;
            if (new File(this.potentialChildRelativePath).isAbsolute()) {
                throw new IllegalArgumentException("Only a relative path is supported, the given path is absolute: " + this.potentialChildRelativePath);
            }
            Path parentAbsolutePath = Util.fileToPath(FilePath.stating(parentFile).getAbsoluteFile());
            try {
                parentRealPath = Functions.isWindows() ? this.windowsToRealPath(parentAbsolutePath) : parentAbsolutePath.toRealPath(new LinkOption[0]);
            }
            catch (NoSuchFileException e) {
                LOGGER.log(Level.FINE, String.format("Cannot find the real path to the parentFile: %s", parentAbsolutePath), e);
                return false;
            }
            String remainingPath = this.potentialChildRelativePath;
            Path currentFilePath = parentFile.toPath();
            while (!remainingPath.isEmpty()) {
                Path directChild = this.getDirectChild(currentFilePath, remainingPath);
                Path childUsingFullPath = currentFilePath.resolve(remainingPath);
                String childUsingFullPathAbs = childUsingFullPath.toAbsolutePath().toString();
                String directChildAbs = directChild.toAbsolutePath().toString();
                remainingPath = childUsingFullPathAbs.length() == directChildAbs.length() ? "" : childUsingFullPathAbs.substring(directChildAbs.length() + 1);
                File childFileSymbolic = Util.resolveSymlinkToFile(directChild.toFile());
                currentFilePath = childFileSymbolic == null ? directChild : childFileSymbolic.toPath();
                Path currentFileAbsolutePath = currentFilePath.toAbsolutePath();
                try {
                    Path child = currentFileAbsolutePath.toRealPath(new LinkOption[0]);
                    if (child.startsWith(parentRealPath)) continue;
                    LOGGER.log(Level.FINE, "Child [{0}] does not start with parent [{1}] => not descendant", new Object[]{child, parentRealPath});
                    return false;
                }
                catch (NoSuchFileException e) {
                    Path child = currentFileAbsolutePath.normalize();
                    Path parent = parentAbsolutePath.normalize();
                    return child.startsWith(parent);
                }
                catch (FileSystemException e) {
                    LOGGER.log(Level.WARNING, String.format("Problem during call to the method toRealPath on %s", currentFileAbsolutePath), e);
                    return false;
                }
            }
            return true;
        }

        @CheckForNull
        private Path getDirectChild(Path parentPath, String childPath) {
            Path current;
            for (current = parentPath.resolve(childPath); current != null && !parentPath.equals(current.getParent()); current = current.getParent()) {
            }
            return current;
        }

        @NonNull
        private Path windowsToRealPath(@NonNull Path path) throws IOException {
            try {
                return path.toRealPath(new LinkOption[0]);
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, String.format("relaxedToRealPath cannot use the regular toRealPath on %s, trying with toRealPath(LinkOption.NOFOLLOW_LINKS)", path), e);
                }
                return path.toRealPath(LinkOption.NOFOLLOW_LINKS);
            }
        }
    }

    public static final class ExplicitlySpecifiedDirScanner
    extends DirScanner {
        private static final long serialVersionUID = 1L;
        private final Map<String, String> files;

        public ExplicitlySpecifiedDirScanner(Map<String, String> files) {
            this.files = files;
        }

        @Override
        public void scan(File dir, FileVisitor visitor) throws IOException {
            for (Map.Entry<String, String> entry : this.files.entrySet()) {
                String archivedPath = entry.getKey();
                assert (archivedPath.indexOf(92) == -1);
                String workspacePath = entry.getValue();
                assert (workspacePath.indexOf(92) == -1);
                this.scanSingle(new File(dir, workspacePath), archivedPath, visitor);
            }
        }
    }

    private static class GetHomeDirectory
    extends MasterToSlaveCallable<FilePath, IOException> {
        private GetHomeDirectory() {
        }

        public FilePath call() throws IOException {
            return new FilePath(new File(System.getProperty("user.home")));
        }
    }

    private static class TunneledInterruptedException
    extends IOException {
        private static final long serialVersionUID = 1L;

        private TunneledInterruptedException(InterruptedException cause) {
            super(cause);
        }
    }

    private static class FileCallableWrapper<T>
    implements DelegatingCallable<T, IOException> {
        private final FileCallable<T> callable;
        private transient ClassLoader classLoader;
        private final FilePath filePath;
        private static final long serialVersionUID = 1L;

        FileCallableWrapper(FileCallable<T> callable, FilePath filePath) {
            this.callable = callable;
            this.classLoader = callable.getClass().getClassLoader();
            this.filePath = filePath;
        }

        private FileCallableWrapper(FileCallable<T> callable, ClassLoader classLoader, FilePath filePath) {
            this.callable = callable;
            this.classLoader = classLoader;
            this.filePath = filePath;
        }

        public T call() throws IOException {
            try {
                return this.callable.invoke(new File(this.filePath.remote), this.filePath.channel);
            }
            catch (InterruptedException e) {
                throw new TunneledInterruptedException(e);
            }
        }

        public void checkRoles(RoleChecker checker) throws SecurityException {
            this.callable.checkRoles(checker);
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public String toString() {
            return this.callable.toString();
        }
    }

    @Restricted(value={NoExternalUse.class})
    static class UrlFactory {
        UrlFactory() {
        }

        public URL newURL(String location) throws MalformedURLException {
            return new URL(location);
        }
    }

    private class ValidateAntFileMask
    extends MasterToSlaveFileCallable<String> {
        private final String fileMasks;
        private final boolean caseSensitive;
        private final int bound;
        private static final long serialVersionUID = 1L;

        ValidateAntFileMask(String fileMasks, boolean caseSensitive, int bound) {
            this.fileMasks = fileMasks;
            this.caseSensitive = caseSensitive;
            this.bound = bound;
        }

        @Override
        public String invoke(File dir, VirtualChannel channel) throws IOException, InterruptedException {
            if (this.fileMasks.startsWith("~")) {
                return Messages.FilePath_TildaDoesntWork();
            }
            StringTokenizer tokens = new StringTokenizer(this.fileMasks, ",");
            while (tokens.hasMoreTokens()) {
                int idx;
                String fileMask = tokens.nextToken().trim();
                if (this.hasMatch(dir, fileMask, this.caseSensitive)) continue;
                if (this.caseSensitive && this.hasMatch(dir, fileMask, false)) {
                    return Messages.FilePath_validateAntFileMask_matchWithCaseInsensitive(fileMask);
                }
                if (fileMask.contains(" ")) {
                    boolean matched = true;
                    for (String token : Util.tokenize(fileMask)) {
                        matched &= this.hasMatch(dir, token, this.caseSensitive);
                    }
                    if (matched) {
                        return Messages.FilePath_validateAntFileMask_whitespaceSeparator();
                    }
                }
                String f = fileMask;
                while ((idx = this.findSeparator(f)) != -1) {
                    if (!this.hasMatch(dir, f = f.substring(idx + 1), this.caseSensitive)) continue;
                    return Messages.FilePath_validateAntFileMask_doesntMatchAndSuggest(fileMask, f);
                }
                FileSet fs = Util.createFileSet(FilePath.reading(dir), "**/" + fileMask);
                fs.setCaseSensitive(this.caseSensitive);
                DirectoryScanner ds = fs.getDirectoryScanner(new Project());
                if (ds.getIncludedFilesCount() != 0) {
                    String[] names = ds.getIncludedFiles();
                    Arrays.sort(names, SHORTER_STRING_FIRST);
                    for (String f2 : names) {
                        int idx2;
                        StringBuilder prefix = new StringBuilder();
                        while ((idx2 = this.findSeparator(f2)) != -1) {
                            prefix.append(f2, 0, idx2).append('/');
                            f2 = f2.substring(idx2 + 1);
                            if (!this.hasMatch(dir, prefix + fileMask, this.caseSensitive)) continue;
                            return Messages.FilePath_validateAntFileMask_doesntMatchAndSuggest(fileMask, prefix + fileMask);
                        }
                    }
                }
                String previous = null;
                String pattern = fileMask;
                while (true) {
                    if (this.hasMatch(dir, pattern, this.caseSensitive)) {
                        if (previous == null) {
                            return Messages.FilePath_validateAntFileMask_portionMatchAndSuggest(fileMask, pattern);
                        }
                        return Messages.FilePath_validateAntFileMask_portionMatchButPreviousNotMatchAndSuggest(fileMask, pattern, previous);
                    }
                    int idx3 = this.findSeparator(pattern);
                    if (idx3 < 0) {
                        if (pattern.equals(fileMask)) {
                            return Messages.FilePath_validateAntFileMask_doesntMatchAnything(fileMask);
                        }
                        return Messages.FilePath_validateAntFileMask_doesntMatchAnythingAndSuggest(fileMask, pattern);
                    }
                    previous = pattern;
                    pattern = pattern.substring(0, idx3);
                }
            }
            return null;
        }

        private boolean hasMatch(File dir, String pattern, boolean bCaseSensitive) throws InterruptedException {
            class Cancel
            extends RuntimeException {
                Cancel() {
                }
            }
            DirectoryScanner ds = this.bound == Integer.MAX_VALUE ? new DirectoryScanner() : new DirectoryScanner(){
                int ticks;
                long start = System.currentTimeMillis();

                public synchronized boolean isCaseSensitive() {
                    if (!this.filesIncluded.isEmpty() || !this.dirsIncluded.isEmpty() || this.ticks++ > ValidateAntFileMask.this.bound || System.currentTimeMillis() - this.start > 5000L) {
                        throw new Cancel();
                    }
                    this.filesNotIncluded.clear();
                    this.dirsNotIncluded.clear();
                    return super.isCaseSensitive();
                }
            };
            ds.setBasedir(FilePath.reading(dir));
            ds.setIncludes(new String[]{pattern});
            ds.setCaseSensitive(bCaseSensitive);
            try {
                ds.scan();
            }
            catch (Cancel c) {
                if (ds.getIncludedFilesCount() != 0 || ds.getIncludedDirsCount() != 0) {
                    return true;
                }
                throw new InterruptedException("no matches found within " + this.bound);
            }
            return ds.getIncludedFilesCount() != 0 || ds.getIncludedDirsCount() != 0;
        }

        private int findSeparator(String pattern) {
            int idx1 = pattern.indexOf(92);
            int idx2 = pattern.indexOf(47);
            if (idx1 == -1) {
                return idx2;
            }
            if (idx2 == -1) {
                return idx1;
            }
            return Math.min(idx1, idx2);
        }
    }

    private static final class IsUnix
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;

        private IsUnix() {
        }

        @NonNull
        public Boolean call() throws IOException {
            return File.pathSeparatorChar == ':';
        }
    }

    private static class CopyRecursiveRemoteToLocal
    extends SecureFileCallable<Integer> {
        private static final long serialVersionUID = 1L;
        private final Pipe pipe;
        private final DirScanner scanner;
        private final TarCompression compression;

        CopyRecursiveRemoteToLocal(Pipe pipe, DirScanner scanner, @NonNull TarCompression compression) {
            this.pipe = pipe;
            this.scanner = scanner;
            this.compression = compression;
        }

        @Override
        public Integer invoke(File f, VirtualChannel channel) throws IOException {
            try (OutputStream out = this.pipe.getOut();){
                Integer n = FilePath.writeToTar(FilePath.reading(f), this.scanner, this.compression.compress(out));
                return n;
            }
        }
    }

    private static class WriteToTar
    extends SecureFileCallable<Integer> {
        private final DirScanner scanner;
        private final Pipe pipe;
        private final TarCompression compression;
        private static final long serialVersionUID = 1L;

        WriteToTar(DirScanner scanner, Pipe pipe, @NonNull TarCompression compression) {
            this.scanner = scanner;
            this.pipe = pipe;
            this.compression = compression;
        }

        @Override
        public Integer invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            return FilePath.writeToTar(FilePath.reading(f), this.scanner, this.compression.compress(this.pipe.getOut()));
        }
    }

    private static class ReadFromTar
    extends SecureFileCallable<Void> {
        private final Pipe pipe;
        private final String description;
        private final TarCompression compression;
        private final FilePath target;
        private static final long serialVersionUID = 1L;

        ReadFromTar(FilePath target, Pipe pipe, String description, @NonNull TarCompression compression) {
            this.target = target;
            this.pipe = pipe;
            this.description = description;
            this.compression = compression;
        }

        @Override
        public Void invoke(File f, VirtualChannel channel) throws IOException {
            try (InputStream in = this.pipe.getIn();){
                FilePath.readFromTar(this.target.remote + '/' + this.description, f, this.compression.extract(in));
                Void void_ = null;
                return void_;
            }
        }
    }

    private static class CopyRecursiveLocal
    extends SecureFileCallable<Integer> {
        private final FilePath target;
        private final DirScanner scanner;
        private static final long serialVersionUID = 1L;

        CopyRecursiveLocal(FilePath target, DirScanner scanner) {
            this.target = target;
            this.scanner = scanner;
        }

        @Override
        public Integer invoke(File base, VirtualChannel channel) throws IOException {
            if (!base.exists()) {
                return 0;
            }
            if (this.target.channel != null) {
                throw new IllegalStateException("Expected null channel for " + this.target);
            }
            final File dest = new File(this.target.remote);
            final AtomicInteger count = new AtomicInteger();
            this.scanner.scan(base, FilePath.reading(new FileVisitor(){
                private boolean exceptionEncountered;
                private boolean logMessageShown;

                @Override
                public void visit(File f, String relativePath) throws IOException {
                    if (f.isFile()) {
                        File target = new File(dest, relativePath);
                        FilePath.mkdirsE(target.getParentFile());
                        Path targetPath = Util.fileToPath(FilePath.writing(target));
                        boolean bl = this.exceptionEncountered = this.exceptionEncountered || !this.tryCopyWithAttributes(f, targetPath);
                        if (this.exceptionEncountered) {
                            Files.copy(Util.fileToPath(f), targetPath, StandardCopyOption.REPLACE_EXISTING);
                            if (!this.logMessageShown) {
                                LOGGER.log(Level.INFO, "JENKINS-52325: Jenkins failed to retain attributes when copying to {0}, so proceeding without attributes.", dest.getAbsolutePath());
                                this.logMessageShown = true;
                            }
                        }
                        count.incrementAndGet();
                    }
                }

                private boolean tryCopyWithAttributes(File f, Path targetPath) {
                    try {
                        Files.copy(Util.fileToPath(f), targetPath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.FINE, "Unable to copy: {0}", e.getMessage());
                        return false;
                    }
                    return true;
                }

                @Override
                public boolean understandsSymlink() {
                    return true;
                }

                @Override
                public void visitSymlink(File link, String target, String relativePath) throws IOException {
                    try {
                        FilePath.mkdirsE(new File(dest, relativePath).getParentFile());
                        FilePath.writing(new File(dest, target));
                        Util.createSymlink(dest, target, relativePath, TaskListener.NULL);
                    }
                    catch (InterruptedException x) {
                        throw new IOException(x);
                    }
                    count.incrementAndGet();
                }
            }));
            return count.get();
        }
    }

    static interface RemoteCopier {
        public void open(String var1) throws IOException;

        public void write(byte[] var1, int var2) throws IOException;

        public void close() throws IOException;
    }

    private static class CopyTo
    extends SecureFileCallable<Void> {
        private static final long serialVersionUID = 4088559042349254141L;
        private final OutputStream out;

        CopyTo(OutputStream out) {
            this.out = out;
        }

        /*
         * Loose catch block
         */
        @Override
        public Void invoke(File f, VirtualChannel channel) throws IOException {
            try {
                try (InputStream fis = Files.newInputStream(Util.fileToPath(FilePath.reading(f)), new OpenOption[0]);){
                    org.apache.commons.io.IOUtils.copy((InputStream)fis, (OutputStream)this.out);
                    Void void_ = null;
                    return void_;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.out.close();
            }
        }
    }

    private static class CopyToWithPermission
    extends SecureFileCallable<Void> {
        private final FilePath target;

        CopyToWithPermission(FilePath target) {
            this.target = target;
        }

        @Override
        public Void invoke(File f, VirtualChannel channel) throws IOException {
            File targetFile = new File(this.target.remote);
            File targetDir = targetFile.getParentFile();
            FilePath.filterNonNull().mkdirs(targetDir);
            Files.createDirectories(Util.fileToPath(targetDir), new FileAttribute[0]);
            Files.copy(Util.fileToPath(FilePath.reading(f)), Util.fileToPath(FilePath.writing(targetFile)), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            return null;
        }
    }

    private static class MoveAllChildrenTo
    extends SecureFileCallable<Void> {
        private final FilePath target;
        private static final long serialVersionUID = 1L;

        MoveAllChildrenTo(FilePath target) {
            this.target = target;
        }

        @Override
        public Void invoke(File f, VirtualChannel channel) throws IOException {
            File tmp = new File(f.getAbsolutePath() + ".__rename");
            if (!FilePath.deleting(f).renameTo(FilePath.creating(tmp))) {
                throw new IOException("Failed to rename " + f + " to " + tmp);
            }
            File t = new File(this.target.getRemote());
            for (File child : FilePath.reading(tmp).listFiles()) {
                File target = new File(t, child.getName());
                if (FilePath.deleting(FilePath.reading(child)).renameTo(FilePath.writing(FilePath.creating(target)))) continue;
                throw new IOException("Failed to rename " + child + " to " + target);
            }
            FilePath.deleting(tmp).delete();
            return null;
        }
    }

    private static class RenameTo
    extends SecureFileCallable<Void> {
        private final FilePath target;
        private static final long serialVersionUID = 1L;

        RenameTo(FilePath target) {
            this.target = target;
        }

        @Override
        public Void invoke(File f, VirtualChannel channel) throws IOException {
            Files.move(Util.fileToPath(FilePath.deleting(FilePath.reading(f))), Util.fileToPath(FilePath.writing(FilePath.creating(new File(this.target.remote)))), LinkOption.NOFOLLOW_LINKS);
            return null;
        }
    }

    private static class Digest
    extends SecureFileCallable<String> {
        private static final long serialVersionUID = 1L;

        private Digest() {
        }

        @Override
        public String invoke(File f, VirtualChannel channel) throws IOException {
            return Util.getDigestOf(FilePath.reading(f));
        }
    }

    private static class Write
    extends SecureFileCallable<Void> {
        private static final long serialVersionUID = 1L;
        private final String encoding;
        private final String content;

        Write(String encoding, String content) {
            this.encoding = encoding;
            this.content = content;
        }

        @Override
        public Void invoke(File f, VirtualChannel channel) throws IOException {
            FilePath.mkdirs(f.getParentFile());
            try (OutputStream fos = Files.newOutputStream(Util.fileToPath(FilePath.writing(f)), new OpenOption[0]);
                 OutputStreamWriter w = this.encoding != null ? new OutputStreamWriter(fos, this.encoding) : new OutputStreamWriter(fos);){
                w.write(this.content);
            }
            return null;
        }
    }

    private static class WritePipe
    extends SecureFileCallable<OutputStream> {
        private static final long serialVersionUID = 1L;

        private WritePipe() {
        }

        @Override
        public OutputStream invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            f = f.getAbsoluteFile();
            FilePath.mkdirs(f.getParentFile());
            return new RemoteOutputStream(Files.newOutputStream(Util.fileToPath(FilePath.writing(f)), new OpenOption[0]));
        }
    }

    private static class ReadToString
    extends SecureFileCallable<String> {
        private static final long serialVersionUID = 1L;

        private ReadToString() {
        }

        @Override
        public String invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            return new String(Files.readAllBytes(Util.fileToPath(FilePath.reading(f))));
        }
    }

    private static class OffsetPipeSecureFileCallable
    extends SecureFileCallable<Void> {
        private static final long serialVersionUID = 1L;
        private Pipe p;
        private long offset;

        private OffsetPipeSecureFileCallable(Pipe p, long offset) {
            this.p = p;
            this.offset = offset;
        }

        /*
         * Exception decompiling
         */
        @Override
        public Void invoke(File f, VirtualChannel channel) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static class Read
    extends SecureFileCallable<Void> {
        private static final long serialVersionUID = 1L;
        private final Pipe p;
        private String verificationRoot;
        private boolean noFollowLinks;

        Read(Pipe p, String verificationRoot, boolean noFollowLinks) {
            this.p = p;
            this.verificationRoot = verificationRoot;
            this.noFollowLinks = noFollowLinks;
        }

        @Override
        public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            try (InputStream fis = FilePath.newInputStreamDenyingSymlinkAsNeeded(FilePath.reading(f), this.verificationRoot, this.noFollowLinks);
                 OutputStream out = this.p.getOut();){
                org.apache.commons.io.IOUtils.copy((InputStream)fis, (OutputStream)out);
            }
            catch (Exception x) {
                this.p.error((Throwable)x);
            }
            return null;
        }
    }

    private static class ListGlob
    extends SecureFileCallable<FilePath[]> {
        private final String includes;
        private final String excludes;
        private final boolean defaultExcludes;
        private static final long serialVersionUID = 1L;

        ListGlob(String includes, String excludes, boolean defaultExcludes) {
            this.includes = includes;
            this.excludes = excludes;
            this.defaultExcludes = defaultExcludes;
        }

        @Override
        public FilePath[] invoke(File f, VirtualChannel channel) throws IOException {
            String[] files = FilePath.glob(FilePath.reading(f), this.includes, this.excludes, this.defaultExcludes);
            FilePath[] r = new FilePath[files.length];
            for (int i = 0; i < r.length; ++i) {
                r[i] = new FilePath(FilePath.stating(new File(f, files[i])));
            }
            return r;
        }
    }

    private static class ListFilter
    extends SecureFileCallable<List<FilePath>> {
        private final FileFilter filter;
        private static final long serialVersionUID = 1L;

        ListFilter(FileFilter filter) {
            this.filter = filter;
        }

        @Override
        public List<FilePath> invoke(File f, VirtualChannel channel) throws IOException {
            File[] children = FilePath.reading(f).listFiles(this.filter);
            if (children == null) {
                return Collections.emptyList();
            }
            ArrayList<FilePath> r = new ArrayList<FilePath>(children.length);
            for (File child : children) {
                r.add(new FilePath(child));
            }
            return r;
        }
    }

    private static final class DirectoryFilter
    implements FileFilter,
    Serializable {
        private static final long serialVersionUID = 1L;

        private DirectoryFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory();
        }
    }

    private static class Mode
    extends SecureFileCallable<Integer> {
        private static final long serialVersionUID = 1L;

        private Mode() {
        }

        @Override
        public Integer invoke(File f, VirtualChannel channel) throws IOException {
            return IOUtils.mode(FilePath.stating(f));
        }
    }

    private static class Chmod
    extends SecureFileCallable<Void> {
        private static final long serialVersionUID = 1L;
        private final int mask;

        Chmod(int mask) {
            this.mask = mask;
        }

        @Override
        public Void invoke(File f, VirtualChannel channel) throws IOException {
            FilePath._chmod(FilePath.writing(f), this.mask);
            return null;
        }
    }

    private static class GetUsableDiskSpace
    extends MasterToSlaveFileCallable<Long> {
        private static final long serialVersionUID = 1L;

        private GetUsableDiskSpace() {
        }

        @Override
        public Long invoke(File f, VirtualChannel channel) throws IOException {
            return f.getUsableSpace();
        }
    }

    private static class GetTotalDiskSpace
    extends MasterToSlaveFileCallable<Long> {
        private static final long serialVersionUID = 1L;

        private GetTotalDiskSpace() {
        }

        @Override
        public Long invoke(File f, VirtualChannel channel) throws IOException {
            return f.getTotalSpace();
        }
    }

    private static class GetFreeDiskSpace
    extends MasterToSlaveFileCallable<Long> {
        private static final long serialVersionUID = 1L;

        private GetFreeDiskSpace() {
        }

        @Override
        public Long invoke(File f, VirtualChannel channel) throws IOException {
            return f.getFreeSpace();
        }
    }

    private static class Length
    extends SecureFileCallable<Long> {
        private static final long serialVersionUID = 1L;

        private Length() {
        }

        @Override
        public Long invoke(File f, VirtualChannel channel) throws IOException {
            return FilePath.stating(f).length();
        }
    }

    private static class IsDirectory
    extends SecureFileCallable<Boolean> {
        private static final long serialVersionUID = 1L;

        private IsDirectory() {
        }

        @Override
        public Boolean invoke(File f, VirtualChannel channel) throws IOException {
            return FilePath.stating(f).isDirectory();
        }
    }

    private static class SetLastModified
    extends SecureFileCallable<String> {
        private final long timestamp;
        private static final long serialVersionUID = -828220335793641630L;

        SetLastModified(long timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public String invoke(File f, VirtualChannel channel) throws IOException {
            if (!FilePath.writing(f).setLastModified(this.timestamp)) {
                if (Functions.isWindows()) {
                    return "Failed to set the timestamp of " + f + " to " + this.timestamp;
                }
                throw new IOException("Failed to set the timestamp of " + f + " to " + this.timestamp);
            }
            return null;
        }
    }

    private static class Touch
    extends SecureFileCallable<Void> {
        private final long timestamp;
        private static final long serialVersionUID = -5094638816500738429L;

        Touch(long timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public Void invoke(File f, VirtualChannel channel) throws IOException {
            if (!f.exists()) {
                Files.newOutputStream(Util.fileToPath(FilePath.creating(f)), new OpenOption[0]).close();
            }
            if (!FilePath.stating(f).setLastModified(this.timestamp)) {
                throw new IOException("Failed to set the timestamp of " + f + " to " + this.timestamp);
            }
            return null;
        }
    }

    private static class LastModified
    extends SecureFileCallable<Long> {
        private static final long serialVersionUID = 1L;

        private LastModified() {
        }

        @Override
        public Long invoke(File f, VirtualChannel channel) throws IOException {
            return FilePath.stating(f).lastModified();
        }
    }

    private static class Exists
    extends SecureFileCallable<Boolean> {
        private static final long serialVersionUID = 1L;

        private Exists() {
        }

        @Override
        public Boolean invoke(File f, VirtualChannel channel) throws IOException {
            return FilePath.stating(f).exists();
        }
    }

    private static class Delete
    extends SecureFileCallable<Void> {
        private static final long serialVersionUID = 1L;

        private Delete() {
        }

        @Override
        public Void invoke(File f, VirtualChannel channel) throws IOException {
            Util.deleteFile(FilePath.deleting(f));
            return null;
        }
    }

    private static class CreateTempDir
    extends SecureFileCallable<String> {
        private final String name;
        private static final long serialVersionUID = 1L;

        CreateTempDir(String name) {
            this.name = name;
        }

        @Override
        public String invoke(File dir, VirtualChannel channel) throws IOException {
            FilePath.mkdirsing(new File(dir, this.name + "-security-test"));
            boolean isPosix = FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
            Path tempPath = isPosix ? Files.createTempDirectory(Util.fileToPath(dir), this.name, PosixFilePermissions.asFileAttribute(EnumSet.allOf(PosixFilePermission.class))) : Files.createTempDirectory(Util.fileToPath(dir), this.name, new FileAttribute[0]);
            if (FilePath.mkdirsing(tempPath.toFile()) == null) {
                throw new IOException("Failed to obtain file from path " + dir);
            }
            return tempPath.toFile().getName();
        }
    }

    private static class CreateTextTempFile
    extends SecureFileCallable<String> {
        private static final long serialVersionUID = 1L;
        private final boolean inThisDirectory;
        private final String prefix;
        private final String suffix;
        private final String contents;

        CreateTextTempFile(boolean inThisDirectory, String prefix, String suffix, String contents) {
            this.inThisDirectory = inThisDirectory;
            this.prefix = prefix;
            this.suffix = suffix;
            this.contents = contents;
        }

        @Override
        public String invoke(File dir, VirtualChannel channel) throws IOException {
            File f;
            if (!this.inThisDirectory) {
                dir = new File(System.getProperty("java.io.tmpdir"));
            } else {
                FilePath.mkdirs(dir);
            }
            try {
                FilePath.creating(new File(dir, this.prefix + "-security-check-dummy-" + this.suffix));
                f = FilePath.creating(File.createTempFile(this.prefix, this.suffix, dir));
            }
            catch (IOException e) {
                throw new IOException("Failed to create a temporary directory in " + dir, e);
            }
            try (FileWriter w = new FileWriter(FilePath.writing(f));){
                w.write(this.contents);
            }
            return f.getAbsolutePath();
        }
    }

    private static class CreateTempFile
    extends SecureFileCallable<String> {
        private final String prefix;
        private final String suffix;
        private static final long serialVersionUID = 1L;

        CreateTempFile(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }

        @Override
        public String invoke(File dir, VirtualChannel channel) throws IOException {
            FilePath.creating(new File(dir, this.prefix + "-security-check-dummy-" + this.suffix));
            File f = FilePath.creating(File.createTempFile(this.prefix, this.suffix, dir));
            return f.getName();
        }
    }

    private static class DeleteContents
    extends SecureFileCallable<Void> {
        private static final long serialVersionUID = 1L;

        private DeleteContents() {
        }

        @Override
        public Void invoke(File f, VirtualChannel channel) throws IOException {
            Util.deleteContentsRecursive(Util.fileToPath(f), path -> FilePath.deleting(path.toFile()));
            return null;
        }
    }

    private static class DeleteRecursive
    extends SecureFileCallable<Void> {
        private static final long serialVersionUID = 1L;

        private DeleteRecursive() {
        }

        @Override
        public Void invoke(File f, VirtualChannel channel) throws IOException {
            Util.deleteRecursive(Util.fileToPath(f), path -> FilePath.deleting(path.toFile()));
            return null;
        }
    }

    private static class DeleteSuffixesRecursive
    extends SecureFileCallable<Void> {
        private static final long serialVersionUID = 1L;

        private DeleteSuffixesRecursive() {
        }

        @Override
        public Void invoke(File f, VirtualChannel channel) throws IOException {
            for (File file : FilePath.listParentFiles(f)) {
                if (!file.getName().startsWith(f.getName() + WorkspaceList.COMBINATOR)) continue;
                Util.deleteRecursive(file.toPath(), path -> FilePath.deleting(path.toFile()));
            }
            return null;
        }
    }

    private static class Mkdirs
    extends SecureFileCallable<Boolean> {
        private static final long serialVersionUID = 1L;

        private Mkdirs() {
        }

        @Override
        public Boolean invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            if (FilePath.mkdirs(f) || f.exists()) {
                return true;
            }
            Thread.sleep(10L);
            return FilePath.mkdirs(f) || f.exists();
        }
    }

    private static class ToURI
    extends SecureFileCallable<URI> {
        private static final long serialVersionUID = 1L;

        private ToURI() {
        }

        @Override
        public URI invoke(File f, VirtualChannel channel) {
            return FilePath.stating(f).toURI();
        }
    }

    private class CallableWith<V>
    implements Callable<V, IOException> {
        private final FileCallable<V> task;
        private static final long serialVersionUID = 1L;

        CallableWith(FileCallable<V> task) {
            this.task = task;
        }

        public V call() throws IOException {
            try {
                return FilePath.this.act(this.task);
            }
            catch (InterruptedException e) {
                throw (IOException)new InterruptedIOException().initCause(e);
            }
        }

        public void checkRoles(RoleChecker checker) throws SecurityException {
            this.task.checkRoles(checker);
        }
    }

    public static abstract class AbstractInterceptorCallableWrapper<T>
    implements DelegatingCallable<T, IOException> {
        private static final long serialVersionUID = 1L;
        private final DelegatingCallable<T, IOException> callable;

        public AbstractInterceptorCallableWrapper(DelegatingCallable<T, IOException> callable) {
            this.callable = callable;
        }

        public final ClassLoader getClassLoader() {
            return this.callable.getClassLoader();
        }

        public final T call() throws IOException {
            this.before();
            try {
                Object object = this.callable.call();
                return (T)object;
            }
            finally {
                this.after();
            }
        }

        protected void before() {
        }

        protected void after() {
        }
    }

    public static abstract class FileCallableWrapperFactory
    implements ExtensionPoint {
        public abstract <T> DelegatingCallable<T, IOException> wrap(DelegatingCallable<T, IOException> var1);
    }

    static abstract class SecureFileCallable<T>
    extends SlaveToMasterFileCallable<T> {
        SecureFileCallable() {
        }
    }

    public static interface FileCallable<T>
    extends Serializable,
    RoleSensitive {
        public T invoke(File var1, VirtualChannel var2) throws IOException, InterruptedException;
    }

    private final class Unpack
    extends MasterToSlaveFileCallable<Void> {
        private final URL archive;

        Unpack(URL archive) {
            this.archive = archive;
        }

        @Override
        public Void invoke(File dir, VirtualChannel channel) throws IOException, InterruptedException {
            try (InputStream in = this.archive.openStream();){
                CountingInputStream cis = new CountingInputStream(in);
                try {
                    if (this.archive.toExternalForm().endsWith(".zip")) {
                        FilePath.unzip(dir, (InputStream)cis);
                    } else {
                        FilePath.readFromTar("input stream", dir, TarCompression.GZIP.extract((InputStream)cis));
                    }
                }
                catch (IOException x) {
                    throw new IOException(String.format("Failed to unpack %s (%d bytes read)", this.archive, cis.getByteCount()), x);
                }
            }
            return null;
        }
    }

    private static class UntarFrom
    extends SecureFileCallable<Void> {
        private final TarCompression compression;
        private final InputStream in;
        private static final long serialVersionUID = 1L;

        UntarFrom(TarCompression compression, InputStream in) {
            this.compression = compression;
            this.in = in;
        }

        @Override
        public Void invoke(File dir, VirtualChannel channel) throws IOException {
            FilePath.readFromTar("input stream", dir, this.compression.extract(this.in));
            return null;
        }
    }

    public static enum TarCompression {
        NONE{

            @Override
            public InputStream extract(InputStream in) {
                return new BufferedInputStream(in);
            }

            @Override
            public OutputStream compress(OutputStream out) {
                return new BufferedOutputStream(out);
            }
        }
        ,
        GZIP{

            @Override
            public InputStream extract(InputStream _in) throws IOException {
                HeadBufferingStream in = new HeadBufferingStream(_in, SIDE_BUFFER_SIZE);
                try {
                    return new com.jcraft.jzlib.GZIPInputStream((InputStream)in, 8192, true);
                }
                catch (IOException e) {
                    in.fillSide();
                    throw new IOException(e.getMessage() + "\nstream=" + Util.toHexString(in.getSideBuffer()), e);
                }
            }

            @Override
            public OutputStream compress(OutputStream out) throws IOException {
                return new GZIPOutputStream((OutputStream)new BufferedOutputStream(out));
            }
        };


        public abstract InputStream extract(InputStream var1) throws IOException;

        public abstract OutputStream compress(OutputStream var1) throws IOException;
    }

    private static class ReadLink
    extends SecureFileCallable<String> {
        private static final long serialVersionUID = 1L;

        private ReadLink() {
        }

        @Override
        public String invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            return Util.resolveSymlink(FilePath.reading(f));
        }
    }

    private static class SymlinkTo
    extends SecureFileCallable<Void> {
        private final String target;
        private final TaskListener listener;
        private static final long serialVersionUID = 1L;

        SymlinkTo(String target, TaskListener listener) {
            this.target = target;
            this.listener = listener;
        }

        @Override
        public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            Util.createSymlink(FilePath.symlinking(f).getParentFile(), this.target, f.getName(), this.listener);
            return null;
        }
    }

    private static class SymlinkRetainingFileFilter
    implements FileFilter,
    Serializable {
        private final String verificationRoot;
        private final boolean noFollowLinks;
        private static final long serialVersionUID = 1L;

        SymlinkRetainingFileFilter(FilePath verificationRoot, boolean noFollowLinks) {
            this.verificationRoot = verificationRoot == null ? null : verificationRoot.remote;
            this.noFollowLinks = noFollowLinks;
        }

        @Override
        public boolean accept(File file) {
            return FilePath.isSymlink(file, this.verificationRoot, this.noFollowLinks);
        }
    }

    private static class HasSymlink
    extends SecureFileCallable<Boolean> {
        private static final long serialVersionUID = 1L;
        private final String verificationRoot;
        private final boolean noFollowLinks;

        HasSymlink(String verificationRoot, boolean noFollowLinks) {
            this.verificationRoot = verificationRoot;
            this.noFollowLinks = noFollowLinks;
        }

        @Override
        public Boolean invoke(File f, VirtualChannel channel) throws IOException {
            return FilePath.isSymlink(FilePath.stating(f), this.verificationRoot, this.noFollowLinks);
        }
    }

    private static class Absolutize
    extends SecureFileCallable<String> {
        private static final long serialVersionUID = 1L;

        private Absolutize() {
        }

        @Override
        public String invoke(File f, VirtualChannel channel) throws IOException {
            return FilePath.stating(f).getAbsolutePath();
        }
    }

    private static class UnzipFrom
    extends SecureFileCallable<Void> {
        private final InputStream in;
        private static final long serialVersionUID = 1L;

        UnzipFrom(InputStream in) {
            this.in = in;
        }

        @Override
        public Void invoke(File dir, VirtualChannel channel) throws IOException {
            FilePath.unzip(dir, this.in);
            return null;
        }
    }

    private static class UntarLocal
    extends SecureFileCallable<Void> {
        private final TarCompression compression;
        private final FilePath filePath;
        private static final long serialVersionUID = 1L;

        UntarLocal(FilePath source, TarCompression compression) {
            this.filePath = source;
            this.compression = compression;
        }

        @Override
        public Void invoke(File dir, VirtualChannel channel) throws IOException, InterruptedException {
            FilePath.readFromTar(this.filePath.getName(), dir, this.compression.extract(this.filePath.read()));
            return null;
        }
    }

    private static class UntarRemote
    extends SecureFileCallable<Void> {
        private final TarCompression compression;
        private final RemoteInputStream in;
        private final String name;
        private static final long serialVersionUID = 1L;

        UntarRemote(String name, TarCompression compression, RemoteInputStream in) {
            this.compression = compression;
            this.in = in;
            this.name = name;
        }

        @Override
        public Void invoke(File dir, VirtualChannel channel) throws IOException, InterruptedException {
            FilePath.readFromTar(this.name, dir, this.compression.extract((InputStream)this.in));
            return null;
        }
    }

    private static class UnzipLocal
    extends SecureFileCallable<Void> {
        private final FilePath filePath;
        private static final long serialVersionUID = 1L;

        private UnzipLocal(FilePath filePath) {
            this.filePath = filePath;
        }

        @Override
        public Void invoke(File dir, VirtualChannel channel) throws IOException, InterruptedException {
            if (this.filePath.isRemote()) {
                throw new IllegalStateException("Expected local path for file: " + this.filePath);
            }
            FilePath.unzip(dir, FilePath.reading(new File(this.filePath.getRemote())));
            return null;
        }
    }

    private static class UnzipRemote
    extends SecureFileCallable<Void> {
        private final RemoteInputStream in;
        private static final long serialVersionUID = 1L;

        UnzipRemote(RemoteInputStream in) {
            this.in = in;
        }

        @Override
        public Void invoke(File dir, VirtualChannel channel) throws IOException, InterruptedException {
            FilePath.unzip(dir, (InputStream)this.in);
            return null;
        }
    }

    private static class Archive
    extends SecureFileCallable<Integer> {
        private final ArchiverFactory factory;
        private final OutputStream out;
        private final DirScanner scanner;
        private final String verificationRoot;
        private final boolean noFollowLinks;
        private static final long serialVersionUID = 1L;

        Archive(ArchiverFactory factory, OutputStream out, DirScanner scanner, String verificationRoot, boolean noFollowLinks) {
            this.factory = factory;
            this.out = out;
            this.scanner = scanner;
            this.verificationRoot = verificationRoot;
            this.noFollowLinks = noFollowLinks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer invoke(File f, VirtualChannel channel) throws IOException {
            try (Archiver a = this.factory.create(this.out);){
                this.scanner.scan(f, FilePath.ignoringSymlinks(FilePath.reading(a), this.verificationRoot, this.noFollowLinks));
            }
            return a.countEntries();
        }
    }
}

