/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli.declarative;

import hudson.cli.CLICommand;
import hudson.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.FieldSetter;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Setter;

class MethodBinder {
    private final CLICommand command;
    private final Method method;
    private final Object[] arguments;

    MethodBinder(Method method, CLICommand command, CmdLineParser parser) {
        this.method = method;
        this.command = command;
        List<ReflectionUtils.Parameter> params = ReflectionUtils.getParameters(method);
        this.arguments = new Object[params.size()];
        int bias = parser.getArguments().size();
        for (final ReflectionUtils.Parameter p : params) {
            Argument arg;
            final int index = p.index();
            Setter setter = new Setter(){

                public void addValue(Object value) throws CmdLineException {
                    ((MethodBinder)MethodBinder.this).arguments[index] = value;
                }

                public Class getType() {
                    return p.type();
                }

                public boolean isMultiValued() {
                    return false;
                }

                public FieldSetter asFieldSetter() {
                    return null;
                }

                public AnnotatedElement asAnnotatedElement() {
                    return p;
                }
            };
            Option option = p.annotation(Option.class);
            if (option != null) {
                parser.addOption(setter, option);
            }
            if ((arg = p.annotation(Argument.class)) != null) {
                if (bias > 0) {
                    arg = new ArgumentImpl(arg, bias);
                }
                parser.addArgument(setter, arg);
            }
            if (p.type() == CLICommand.class) {
                this.arguments[index] = command;
            }
            if (!p.type().isPrimitive()) continue;
            this.arguments[index] = ReflectionUtils.getVmDefaultValueForPrimitiveType(p.type());
        }
    }

    public Object call(Object instance) throws Exception {
        try {
            return this.method.invoke(instance, this.arguments);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw e;
        }
    }

    private static final class ArgumentImpl
    implements Argument {
        private final Argument base;
        private final int bias;

        private ArgumentImpl(Argument base, int bias) {
            this.base = base;
            this.bias = bias;
        }

        public String usage() {
            return this.base.usage();
        }

        public String metaVar() {
            return this.base.metaVar();
        }

        public boolean required() {
            return this.base.required();
        }

        public Class<? extends OptionHandler> handler() {
            return this.base.handler();
        }

        public int index() {
            return this.base.index() + this.bias;
        }

        public boolean multiValued() {
            return this.base.multiValued();
        }

        public Class<? extends Annotation> annotationType() {
            return this.base.annotationType();
        }

        public boolean hidden() {
            return this.base.hidden();
        }
    }
}

