/*
 * Decompiled with CFR 0.152.
 */
package hudson.console;

import com.jcraft.jzlib.GZIPInputStream;
import com.jcraft.jzlib.GZIPOutputStream;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.console.ConsoleAnnotationOutputStream;
import hudson.console.ConsoleAnnotator;
import hudson.console.PlainTextConsoleOutputStream;
import hudson.remoting.ObjectInputStreamEx;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import jenkins.model.Jenkins;
import jenkins.security.CryptoConfidentialKey;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.jenkinsci.remoting.util.AnonymousClassWarnings;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.framework.io.ByteBuffer;
import org.kohsuke.stapler.framework.io.LargeText;

public class AnnotatedLargeText<T>
extends LargeText {
    private T context;
    private static final CryptoConfidentialKey PASSING_ANNOTATOR = new CryptoConfidentialKey(AnnotatedLargeText.class, "consoleAnnotator");

    public AnnotatedLargeText(File file, Charset charset, boolean completed, T context) {
        super(file, charset, completed, true);
        this.context = context;
    }

    public AnnotatedLargeText(ByteBuffer memory, Charset charset, boolean completed, T context) {
        super(memory, charset, completed);
        this.context = context;
    }

    public void doProgressiveHtml(StaplerRequest req, StaplerResponse rsp) throws IOException {
        req.setAttribute("html", (Object)true);
        this.doProgressText(req, rsp);
    }

    public void doProgressiveText(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.doProgressText(req, rsp);
    }

    private boolean isHtml() {
        StaplerRequest req = Stapler.getCurrentRequest();
        return req != null && req.getAttribute("html") != null;
    }

    protected void setContentType(StaplerResponse rsp) {
        rsp.setContentType(this.isHtml() ? "text/html;charset=UTF-8" : "text/plain;charset=UTF-8");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConsoleAnnotator<T> createAnnotator(StaplerRequest req) throws IOException {
        try {
            String base64 = req != null ? req.getHeader("X-ConsoleAnnotator") : null;
            if (base64 == null) return ConsoleAnnotator.initial(this.context);
            Cipher sym = PASSING_ANNOTATOR.decrypt();
            try (ObjectInputStreamEx ois = new ObjectInputStreamEx((InputStream)new GZIPInputStream((InputStream)new CipherInputStream(new ByteArrayInputStream(Base64.getDecoder().decode(base64.getBytes(StandardCharsets.UTF_8))), sym)), Jenkins.get().pluginManager.uberClassLoader);){
                long timestamp = ois.readLong();
                if (TimeUnit.HOURS.toMillis(1L) <= Math.abs(System.currentTimeMillis() - timestamp)) return ConsoleAnnotator.initial(this.context);
                ConsoleAnnotator consoleAnnotator = this.getConsoleAnnotator((ObjectInputStream)ois);
                return consoleAnnotator;
            }
            catch (RuntimeException ex) {
                throw new IOException("Could not decode input", ex);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    @SuppressFBWarnings(value={"OBJECT_DESERIALIZATION"}, justification="Deserialization is protected by logic.")
    private ConsoleAnnotator getConsoleAnnotator(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        return (ConsoleAnnotator)ois.readObject();
    }

    @CheckReturnValue
    public long writeLogTo(long start, Writer w) throws IOException {
        if (this.isHtml()) {
            return this.writeHtmlTo(start, w);
        }
        return super.writeLogTo(start, w);
    }

    @CheckReturnValue
    public long writeLogTo(long start, OutputStream out) throws IOException {
        return super.writeLogTo(start, (OutputStream)new PlainTextConsoleOutputStream(out));
    }

    @CheckReturnValue
    public long writeRawLogTo(long start, OutputStream out) throws IOException {
        return super.writeLogTo(start, out);
    }

    @CheckReturnValue
    public long writeHtmlTo(long start, Writer w) throws IOException {
        ConsoleAnnotationOutputStream<T> caw = new ConsoleAnnotationOutputStream<T>(w, this.createAnnotator(Stapler.getCurrentRequest()), this.context, this.charset);
        long r = super.writeLogTo(start, caw);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Cipher sym = PASSING_ANNOTATOR.encrypt();
        ObjectOutputStream oos = AnonymousClassWarnings.checkingObjectOutputStream((OutputStream)new GZIPOutputStream((OutputStream)new CipherOutputStream((OutputStream)baos, sym)));
        oos.writeLong(System.currentTimeMillis());
        oos.writeObject(caw.getConsoleAnnotator());
        oos.close();
        StaplerResponse rsp = Stapler.getCurrentResponse();
        if (rsp != null) {
            rsp.setHeader("X-ConsoleAnnotator", new String(Base64.getEncoder().encode(baos.toByteArray())));
        }
        return r;
    }
}

