/*
 * Decompiled with CFR 0.152.
 */
package hudson.init;

import com.google.inject.Injector;
import hudson.model.Hudson;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jvnet.hudson.annotation_indexer.Index;
import org.jvnet.hudson.reactor.Milestone;
import org.jvnet.hudson.reactor.MilestoneImpl;
import org.jvnet.hudson.reactor.Reactor;
import org.jvnet.hudson.reactor.Task;
import org.jvnet.hudson.reactor.TaskBuilder;
import org.jvnet.localizer.ResourceBundleHolder;

abstract class TaskMethodFinder<T extends Annotation>
extends TaskBuilder {
    private static final Logger LOGGER = Logger.getLogger(TaskMethodFinder.class.getName());
    protected final ClassLoader cl;
    private final Set<Method> discovered = new HashSet<Method>();
    private final Class<T> type;
    private final Class<? extends Enum> milestoneType;

    TaskMethodFinder(Class<T> type, Class<? extends Enum> milestoneType, ClassLoader cl) {
        this.type = type;
        this.milestoneType = milestoneType;
        this.cl = cl;
    }

    protected abstract String displayNameOf(T var1);

    protected abstract String[] requiresOf(T var1);

    protected abstract String[] attainsOf(T var1);

    protected abstract Milestone afterOf(T var1);

    protected abstract Milestone beforeOf(T var1);

    protected abstract boolean fatalOf(T var1);

    public Collection<Task> discoverTasks(Reactor session) throws IOException {
        ArrayList<Task> result = new ArrayList<Task>();
        for (Method e : Index.list(this.type, (ClassLoader)this.cl, Method.class)) {
            T i;
            if (this.filter(e) || (i = e.getAnnotation(this.type)) == null) continue;
            result.add(new TaskImpl(this, (Annotation)i, e));
        }
        return result;
    }

    protected boolean filter(Method e) {
        return !this.discovered.add(e);
    }

    protected String getDisplayNameOf(Method e, T i) {
        Class<?> c = e.getDeclaringClass();
        String key = this.displayNameOf(i);
        if (key.length() == 0) {
            return c.getSimpleName() + "." + e.getName();
        }
        try {
            ResourceBundleHolder rb = ResourceBundleHolder.get(c.getClassLoader().loadClass(c.getPackage().getName() + ".Messages"));
            return rb.format(key, new Object[0]);
        }
        catch (ClassNotFoundException x) {
            LOGGER.log(Level.WARNING, "Failed to load " + x.getMessage() + " for " + e, x);
            return key;
        }
        catch (MissingResourceException x) {
            LOGGER.log(Level.WARNING, "Could not find key '" + key + "' in " + c.getPackage().getName() + ".Messages", x);
            return key;
        }
    }

    protected void invoke(Method e) {
        try {
            Class<?>[] pt = e.getParameterTypes();
            Object[] args = new Object[pt.length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.lookUp(pt[i]);
            }
            e.invoke(Modifier.isStatic(e.getModifiers()) ? null : this.lookUp(e.getDeclaringClass()), args);
        }
        catch (IllegalAccessException x) {
            throw (Error)new IllegalAccessError().initCause(x);
        }
        catch (InvocationTargetException x) {
            throw new Error(x);
        }
    }

    private Object lookUp(Class<?> type) {
        Jenkins j = Jenkins.get();
        assert (j != null) : "This method is only invoked after the Jenkins singleton instance has been set";
        if (type == Jenkins.class || type == Hudson.class) {
            return j;
        }
        Injector i = j.getInjector();
        if (i != null) {
            return i.getInstance(type);
        }
        throw new IllegalArgumentException("Unable to inject " + type);
    }

    public static class TaskImpl
    implements Task {
        final Collection<Milestone> requires;
        final Collection<Milestone> attains;
        private final T i;
        private final Method e;
        final /* synthetic */ TaskMethodFinder this$0;

        private TaskImpl(T i, Method e) {
            this.this$0 = this$0;
            this.i = i;
            this.e = e;
            this.requires = this.toMilestones(this$0.requiresOf(i), this$0.afterOf(i));
            this.attains = this.toMilestones(this$0.attainsOf(i), this$0.beforeOf(i));
        }

        public T getAnnotation() {
            return this.i;
        }

        public Method getMethod() {
            return this.e;
        }

        public Collection<Milestone> requires() {
            return this.requires;
        }

        public Collection<Milestone> attains() {
            return this.attains;
        }

        public String getDisplayName() {
            return this.this$0.getDisplayNameOf(this.e, this.i);
        }

        public boolean failureIsFatal() {
            return this.this$0.fatalOf(this.i);
        }

        public void run(Reactor session) {
            this.this$0.invoke(this.e);
        }

        public String toString() {
            return this.e.toString();
        }

        private Collection<Milestone> toMilestones(String[] tokens, Milestone m) {
            ArrayList<Milestone> r = new ArrayList<Milestone>();
            for (String s : tokens) {
                try {
                    r.add((Milestone)Enum.valueOf(this.this$0.milestoneType, s));
                }
                catch (IllegalArgumentException x) {
                    r.add((Milestone)new MilestoneImpl(s));
                }
            }
            r.add(m);
            return r;
        }
    }
}

