/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Messages;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.SimpleParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

public class ChoiceParameterDefinition
extends SimpleParameterDefinition {
    public static final String CHOICES_DELIMITER = "\\r?\\n";
    @Deprecated
    public static final String CHOICES_DELIMETER = "\\r?\\n";
    private List<String> choices;
    private final String defaultValue;

    public static boolean areValidChoices(String choices) {
        String strippedChoices = choices.trim();
        return !StringUtils.isEmpty((String)strippedChoices) && strippedChoices.split("\\r?\\n").length > 0;
    }

    public ChoiceParameterDefinition(@NonNull String name, @NonNull String choices, String description) {
        super(name, description);
        this.setChoicesText(choices);
        this.defaultValue = null;
    }

    public ChoiceParameterDefinition(@NonNull String name, @NonNull String[] choices, String description) {
        super(name, description);
        this.choices = Stream.of(choices).map(Util::fixNull).collect(Collectors.toCollection(ArrayList::new));
        this.defaultValue = null;
    }

    private ChoiceParameterDefinition(@NonNull String name, @NonNull List<String> choices, String defaultValue, String description) {
        super(name, description);
        this.choices = choices;
        this.defaultValue = defaultValue;
    }

    @DataBoundConstructor
    @Restricted(value={NoExternalUse.class})
    public ChoiceParameterDefinition(String name, String description) {
        super(name, description);
        this.choices = new ArrayList<String>();
        this.defaultValue = null;
    }

    @DataBoundSetter
    @Restricted(value={NoExternalUse.class})
    public void setChoices(Object choices) {
        if (choices instanceof String) {
            this.setChoicesText((String)choices);
            return;
        }
        if (choices instanceof List) {
            ArrayList<String> newChoices = new ArrayList<String>();
            for (Object o : (List)choices) {
                if (o == null) continue;
                newChoices.add(o.toString());
            }
            this.choices = newChoices;
            return;
        }
        throw new IllegalArgumentException("expected String or List, but got " + choices.getClass().getName());
    }

    private void setChoicesText(String choices) {
        this.choices = Arrays.asList(choices.split("\\r?\\n"));
    }

    @Override
    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValue) {
        if (defaultValue instanceof StringParameterValue) {
            StringParameterValue value = (StringParameterValue)defaultValue;
            return new ChoiceParameterDefinition(this.getName(), this.choices, value.value, this.getDescription());
        }
        return this;
    }

    @Exported
    public List<String> getChoices() {
        return this.choices;
    }

    public String getChoicesText() {
        return StringUtils.join(this.choices, (String)"\n");
    }

    @Override
    @CheckForNull
    public StringParameterValue getDefaultParameterValue() {
        if (this.defaultValue == null) {
            if (this.choices.isEmpty()) {
                return null;
            }
            return new StringParameterValue(this.getName(), this.choices.get(0), this.getDescription());
        }
        return new StringParameterValue(this.getName(), this.defaultValue, this.getDescription());
    }

    @Override
    public boolean isValid(ParameterValue value) {
        return this.choices.contains(((StringParameterValue)value).getValue());
    }

    @Override
    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        StringParameterValue value = (StringParameterValue)req.bindJSON(StringParameterValue.class, jo);
        value.setDescription(this.getDescription());
        this.checkValue(value, value.getValue());
        return value;
    }

    private void checkValue(StringParameterValue value, String value2) {
        if (!this.isValid(value)) {
            throw new IllegalArgumentException("Illegal choice for parameter " + this.getName() + ": " + value2);
        }
    }

    @Override
    public StringParameterValue createValue(String value) {
        StringParameterValue parameterValue = new StringParameterValue(this.getName(), value, this.getDescription());
        this.checkValue(parameterValue, value);
        return parameterValue;
    }

    @Override
    public int hashCode() {
        if (ChoiceParameterDefinition.class != this.getClass()) {
            return super.hashCode();
        }
        return Objects.hash(this.getName(), this.getDescription(), this.choices, this.defaultValue);
    }

    @Override
    public boolean equals(Object obj) {
        if (ChoiceParameterDefinition.class != this.getClass()) {
            return super.equals(obj);
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChoiceParameterDefinition other = (ChoiceParameterDefinition)obj;
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(this.getDescription(), other.getDescription())) {
            return false;
        }
        if (!Objects.equals(this.choices, other.choices)) {
            return false;
        }
        return Objects.equals(this.defaultValue, other.defaultValue);
    }

    @Extension
    @Symbol(value={"choice", "choiceParam"})
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        @Override
        public String getDisplayName() {
            return Messages.ChoiceParameterDefinition_DisplayName();
        }

        @Override
        public String getHelpFile() {
            return "/help/parameter/choice.html";
        }

        @Override
        public ParameterDefinition newInstance(@Nullable StaplerRequest req, @NonNull JSONObject formData) throws Descriptor.FormException {
            String name = formData.getString("name");
            String desc = formData.getString("description");
            String choiceText = formData.getString("choices");
            return new ChoiceParameterDefinition(name, choiceText, desc);
        }

        public FormValidation doCheckChoices(@QueryParameter String value) {
            if (ChoiceParameterDefinition.areValidChoices(value)) {
                return FormValidation.ok();
            }
            return FormValidation.error(Messages.ChoiceParameterDefinition_MissingChoices());
        }
    }
}

