/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.basic.DateConverter;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.BulkChange;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.listeners.ItemListener;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.HexBinaryConverter;
import hudson.util.Iterators;
import hudson.util.PersistedList;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.fingerprints.FileFingerprintStorage;
import jenkins.fingerprints.FingerprintStorage;
import jenkins.model.FingerprintFacet;
import jenkins.model.Jenkins;
import jenkins.model.TransientFingerprintFacetFactory;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;

@ExportedBean
public class Fingerprint
implements ModelObject,
Saveable {
    private static final DateConverter DATE_CONVERTER = new DateConverter();
    @NonNull
    private final Date timestamp;
    @CheckForNull
    private final BuildPtr original;
    private final byte[] md5sum;
    private final String fileName;
    private Hashtable<String, RangeSet> usages = new Hashtable();
    PersistedList<FingerprintFacet> facets = new PersistedList(this);
    private volatile transient List<FingerprintFacet> transientFacets = null;
    private static final XStream2 XSTREAM = new XStream2();
    private static final Logger logger;

    public Fingerprint(@CheckForNull Run build, @NonNull String fileName, @NonNull byte[] md5sum) throws IOException {
        this(build == null ? null : new BuildPtr(build), fileName, md5sum);
        this.save();
    }

    Fingerprint(@CheckForNull BuildPtr original, @NonNull String fileName, @NonNull byte[] md5sum) {
        this.original = original;
        this.md5sum = md5sum;
        this.fileName = fileName;
        this.timestamp = new Date();
    }

    @Exported
    @CheckForNull
    public BuildPtr getOriginal() {
        if (this.original != null && this.original.hasPermissionToDiscoverBuild()) {
            return this.original;
        }
        return null;
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return this.fileName;
    }

    @Exported
    @NonNull
    public String getFileName() {
        return this.fileName;
    }

    @Exported(name="hash")
    @NonNull
    public String getHashString() {
        return Util.toHexString(this.md5sum);
    }

    @Exported
    @NonNull
    public Date getTimestamp() {
        return this.timestamp;
    }

    @NonNull
    public String getTimestampString() {
        long duration = System.currentTimeMillis() - this.timestamp.getTime();
        return Util.getTimeSpanString(duration);
    }

    @NonNull
    public RangeSet getRangeSet(String jobFullName) {
        RangeSet r = this.usages.get(jobFullName);
        if (r == null) {
            r = new RangeSet();
        }
        return r;
    }

    public RangeSet getRangeSet(Job job) {
        return this.getRangeSet(job.getFullName());
    }

    @NonNull
    public List<String> getJobs() {
        ArrayList<String> r = new ArrayList<String>(this.usages.keySet());
        Collections.sort(r);
        return r;
    }

    @CheckForNull
    public Hashtable<String, RangeSet> getUsages() {
        return this.usages;
    }

    @Exported(name="usage")
    @NonNull
    public List<RangeItem> _getUsages() {
        ArrayList<RangeItem> r = new ArrayList<RangeItem>();
        Jenkins instance = Jenkins.get();
        for (Map.Entry<String, RangeSet> e : this.usages.entrySet()) {
            String itemName = e.getKey();
            if (!instance.hasPermission(Jenkins.ADMINISTER) && !Fingerprint.canDiscoverItem(itemName)) continue;
            r.add(new RangeItem(itemName, e.getValue()));
        }
        return r;
    }

    @Deprecated
    public void add(@NonNull AbstractBuild b) throws IOException {
        this.addFor(b);
    }

    public void addFor(@NonNull Run b) throws IOException {
        this.add(((AbstractItem)b.getParent()).getFullName(), b.getNumber());
    }

    public synchronized void add(@NonNull String jobFullName, int n) throws IOException {
        this.addWithoutSaving(jobFullName, n);
        this.save();
    }

    protected Object readResolve() {
        if (this.usages == null) {
            this.usages = new Hashtable();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWithoutSaving(@NonNull String jobFullName, int n) {
        Hashtable<String, RangeSet> hashtable = this.usages;
        synchronized (hashtable) {
            RangeSet r = this.usages.get(jobFullName);
            if (r == null) {
                r = new RangeSet();
                this.usages.put(jobFullName, r);
            }
            r.add(n);
        }
    }

    public synchronized boolean isAlive() {
        if (this.original != null && this.original.isAlive()) {
            return true;
        }
        for (Map.Entry<String, RangeSet> e : this.usages.entrySet()) {
            Object firstBuild;
            Job j = Jenkins.get().getItemByFullName(e.getKey(), Job.class);
            if (j == null || (firstBuild = j.getFirstBuild()) == null) continue;
            int oldest = ((Run)firstBuild).getNumber();
            if (e.getValue().isSmallerThan(oldest)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean trim() throws IOException {
        boolean modified = false;
        for (Map.Entry<String, RangeSet> e : new Hashtable<String, RangeSet>(this.usages).entrySet()) {
            Object r;
            Job j = Jenkins.get().getItemByFullName(e.getKey(), Job.class);
            if (j == null) {
                modified = true;
                this.usages.remove(e.getKey());
                continue;
            }
            Object firstBuild = j.getFirstBuild();
            if (firstBuild == null) {
                modified = true;
                this.usages.remove(e.getKey());
                continue;
            }
            RangeSet cur = e.getValue();
            RangeSet kept = new RangeSet();
            for (r = firstBuild; r != null && ((Run)r).isKeepLog(); r = ((Run)r).getNextBuild()) {
                kept.add(((Run)r).getNumber());
            }
            if (r == null) {
                modified |= cur.retainAll(kept);
            } else {
                RangeSet discarding = new RangeSet(new Range(-1, ((Run)r).getNumber()));
                discarding.removeAll(kept);
                modified |= cur.removeAll(discarding);
            }
            if (!cur.isEmpty()) continue;
            this.usages.remove(e.getKey());
            modified = true;
        }
        if (modified) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Saving trimmed Fingerprint ", (Object)this.md5sum);
            }
            this.save();
        }
        return modified;
    }

    @NonNull
    public Collection<FingerprintFacet> getFacets() {
        if (this.transientFacets == null) {
            ArrayList<FingerprintFacet> transientFacets = new ArrayList<FingerprintFacet>();
            for (TransientFingerprintFacetFactory fff : TransientFingerprintFacetFactory.all()) {
                fff.createFor(this, transientFacets);
            }
            this.transientFacets = Collections.unmodifiableList(transientFacets);
        }
        return new AbstractCollection<FingerprintFacet>(){

            @Override
            public Iterator<FingerprintFacet> iterator() {
                return Iterators.sequence(Fingerprint.this.facets.iterator(), Fingerprint.this.transientFacets.iterator());
            }

            @Override
            public boolean add(FingerprintFacet e) {
                Fingerprint.this.facets.add(e);
                return true;
            }

            @Override
            public boolean remove(Object o) {
                return Fingerprint.this.facets.remove(o);
            }

            @Override
            public boolean contains(Object o) {
                return Fingerprint.this.facets.contains(o) || Fingerprint.this.transientFacets.contains(o);
            }

            @Override
            public int size() {
                return Fingerprint.this.facets.size() + Fingerprint.this.transientFacets.size();
            }
        };
    }

    @NonNull
    public final PersistedList<FingerprintFacet> getPersistedFacets() {
        return this.facets;
    }

    @NonNull
    public Collection<FingerprintFacet> getSortedFacets() {
        ArrayList<FingerprintFacet> r = new ArrayList<FingerprintFacet>(this.getFacets());
        r.sort(new Comparator<FingerprintFacet>(){

            @Override
            public int compare(FingerprintFacet o1, FingerprintFacet o2) {
                long a = o1.getTimestamp();
                long b = o2.getTimestamp();
                return Long.compare(a, b);
            }
        });
        return r;
    }

    @CheckForNull
    public <T extends FingerprintFacet> T getFacet(Class<T> type) {
        for (FingerprintFacet f : this.getFacets()) {
            if (!type.isInstance(f)) continue;
            return (T)((FingerprintFacet)type.cast(f));
        }
        return null;
    }

    @NonNull
    public List<Action> getActions() {
        ArrayList<Action> r = new ArrayList<Action>();
        for (FingerprintFacet ff : this.getFacets()) {
            ff.createActions(r);
        }
        return Collections.unmodifiableList(r);
    }

    @Override
    public synchronized void save() throws IOException {
        if (BulkChange.contains(this)) {
            return;
        }
        long start = 0L;
        if (logger.isLoggable(Level.FINE)) {
            start = System.currentTimeMillis();
        }
        FingerprintStorage configuredFingerprintStorage = FingerprintStorage.get();
        FingerprintStorage fileFingerprintStorage = FingerprintStorage.getFileFingerprintStorage();
        configuredFingerprintStorage.save(this);
        if (!(configuredFingerprintStorage instanceof FileFingerprintStorage) && fileFingerprintStorage.isReady()) {
            fileFingerprintStorage.delete(this.getHashString());
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Saving fingerprint " + this.getHashString() + " took " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    @Deprecated
    void save(File file) throws IOException {
        FileFingerprintStorage.save(this, file);
    }

    @CheckForNull
    public FingerprintFacet getFacetBlockingDeletion() {
        for (FingerprintFacet facet : this.facets) {
            if (!facet.isFingerprintDeletionBlocked()) continue;
            return facet;
        }
        return null;
    }

    public synchronized void rename(String oldName, String newName) throws IOException {
        RangeSet r;
        boolean touched = false;
        if (this.original != null && this.original.getName().equals(oldName)) {
            this.original.setName(newName);
            touched = true;
        }
        if (this.usages != null && (r = this.usages.get(oldName)) != null) {
            this.usages.put(newName, r);
            this.usages.remove(oldName);
            touched = true;
        }
        if (touched) {
            this.save();
        }
    }

    public Api getApi() {
        return new Api(this);
    }

    @CheckForNull
    public static Fingerprint load(@NonNull String id) throws IOException {
        long start = 0L;
        if (logger.isLoggable(Level.FINE)) {
            start = System.currentTimeMillis();
        }
        FingerprintStorage configuredFingerprintStorage = FingerprintStorage.get();
        FingerprintStorage fileFingerprintStorage = FingerprintStorage.getFileFingerprintStorage();
        Fingerprint loaded = configuredFingerprintStorage.load(id);
        if (loaded == null && !(configuredFingerprintStorage instanceof FileFingerprintStorage) && fileFingerprintStorage.isReady()) {
            loaded = fileFingerprintStorage.load(id);
            if (loaded != null) {
                Fingerprint.initFacets(loaded);
                configuredFingerprintStorage.save(loaded);
                fileFingerprintStorage.delete(id);
            }
        } else {
            Fingerprint.initFacets(loaded);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loading fingerprint took " + (System.currentTimeMillis() - start) + "ms");
        }
        return loaded;
    }

    @Deprecated
    @CheckForNull
    static Fingerprint load(@NonNull byte[] md5sum) throws IOException {
        return Fingerprint.load(Util.toHexString(md5sum));
    }

    @Deprecated
    @CheckForNull
    static Fingerprint load(@NonNull File file) throws IOException {
        Fingerprint fingerprint = FileFingerprintStorage.load(file);
        Fingerprint.initFacets(fingerprint);
        return fingerprint;
    }

    public static void delete(@NonNull String id) throws IOException {
        FingerprintStorage configuredFingerprintStorage = FingerprintStorage.get();
        FingerprintStorage fileFingerprintStorage = FingerprintStorage.getFileFingerprintStorage();
        configuredFingerprintStorage.delete(id);
        if (!(configuredFingerprintStorage instanceof FileFingerprintStorage) && fileFingerprintStorage.isReady()) {
            fileFingerprintStorage.delete(id);
        }
    }

    private static void initFacets(@CheckForNull Fingerprint fingerprint) {
        if (fingerprint == null) {
            return;
        }
        for (FingerprintFacet facet : fingerprint.facets) {
            facet._setOwner(fingerprint);
        }
    }

    public String toString() {
        return "Fingerprint[original=" + this.original + ",hash=" + this.getHashString() + ",fileName=" + this.fileName + ",timestamp=" + DATE_CONVERTER.toString((Object)this.timestamp) + ",usages=" + (this.usages == null ? "null" : new TreeMap<String, RangeSet>(this.getUsages())) + ",facets=" + this.facets + "]";
    }

    private static boolean canDiscoverItem(@NonNull String fullName) {
        Jenkins jenkins = Jenkins.get();
        Item item = null;
        try {
            item = jenkins.getItemByFullName(fullName);
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        if (item != null) {
            return true;
        }
        Authentication userAuth = Jenkins.getAuthentication2();
        try (ACLContext acl = ACL.as2(ACL.SYSTEM2);){
            Item itemBySystemUser = jenkins.getItemByFullName(fullName);
            if (itemBySystemUser == null) {
                boolean bl = false;
                return bl;
            }
            boolean canDiscoverTheItem = itemBySystemUser.hasPermission2(userAuth, Item.DISCOVER);
            if (canDiscoverTheItem) {
                ItemGroup<? extends Item> current = itemBySystemUser.getParent();
                do {
                    if (current instanceof Item) {
                        Item i = (Item)((Object)current);
                        current = i.getParent();
                        if (i.hasPermission2(userAuth, Item.READ)) continue;
                        canDiscoverTheItem = false;
                        continue;
                    }
                    current = null;
                } while (canDiscoverTheItem && current != null);
            }
            boolean bl = canDiscoverTheItem;
            return bl;
        }
    }

    @NonNull
    public static XStream2 getXStream() {
        return XSTREAM;
    }

    static {
        XSTREAM.alias("fingerprint", Fingerprint.class);
        XSTREAM.alias("range", Range.class);
        XSTREAM.alias("ranges", RangeSet.class);
        XSTREAM.registerConverter(new HexBinaryConverter(), 10);
        XSTREAM.registerConverter(new RangeSet.ConverterImpl((Converter)new CollectionConverter(XSTREAM.getMapper()){

            protected Object createCollection(Class type) {
                return new ArrayList();
            }
        }), 10);
        logger = Logger.getLogger(Fingerprint.class.getName());
    }

    @ExportedBean(defaultVisibility=2)
    public static final class RangeItem {
        @Exported
        public final String name;
        @Exported
        public final RangeSet ranges;

        public RangeItem(String name, RangeSet ranges) {
            this.name = name;
            this.ranges = ranges;
        }
    }

    @Extension
    public static final class ProjectRenameListener
    extends ItemListener {
        @Override
        public void onLocationChanged(Item item, String oldName, String newName) {
            try (ACLContext acl = ACL.as2(ACL.SYSTEM2);){
                this.locationChanged(item, oldName, newName);
            }
        }

        private void locationChanged(Item item, String oldName, String newName) {
            Job p;
            if (item instanceof Job && (p = Jenkins.get().getItemByFullName(newName, Job.class)) != null) {
                List builds = p.getBuilds();
                for (Run build : builds) {
                    Collection<Fingerprint> fingerprints = build.getBuildFingerprints();
                    for (Fingerprint f : fingerprints) {
                        try {
                            f.rename(oldName, newName);
                        }
                        catch (IOException e) {
                            logger.log(Level.WARNING, "Failed to update fingerprint record " + f.getFileName() + " when " + oldName + " was renamed to " + newName, e);
                        }
                    }
                }
            }
        }
    }

    @ExportedBean(defaultVisibility=3)
    public static final class RangeSet {
        private final List<Range> ranges;

        public RangeSet() {
            this(new ArrayList<Range>());
        }

        private RangeSet(List<Range> data) {
            this.ranges = data;
        }

        private RangeSet(Range initial) {
            this();
            this.ranges.add(initial);
        }

        public Iterable<Integer> listNumbers() {
            final List<Range> ranges = this.getRanges();
            return new Iterable<Integer>(){

                @Override
                public Iterator<Integer> iterator() {
                    return new Iterators.FlattenIterator<Integer, Range>((Iterable)ranges){

                        @Override
                        protected Iterator<Integer> expand(Range range) {
                            return Iterators.sequence(range.start, range.end).iterator();
                        }
                    };
                }
            };
        }

        public Iterable<Integer> listNumbersReverse() {
            final List<Range> ranges = this.getRanges();
            return new Iterable<Integer>(){

                @Override
                public Iterator<Integer> iterator() {
                    return new Iterators.FlattenIterator<Integer, Range>(Iterators.reverse(ranges)){

                        @Override
                        protected Iterator<Integer> expand(Range range) {
                            return Iterators.reverseSequence(range.start, range.end).iterator();
                        }
                    };
                }
            };
        }

        @Exported
        public synchronized List<Range> getRanges() {
            return new ArrayList<Range>(this.ranges);
        }

        public synchronized void add(int n) {
            for (int i = 0; i < this.ranges.size(); ++i) {
                Range r = this.ranges.get(i);
                if (r.includes(n)) {
                    return;
                }
                if (r.end == n) {
                    this.ranges.set(i, r.expandRight());
                    this.checkCollapse(i);
                    return;
                }
                if (r.start == n + 1) {
                    this.ranges.set(i, r.expandLeft());
                    this.checkCollapse(i - 1);
                    return;
                }
                if (!r.isBiggerThan(n)) continue;
                this.ranges.add(i, new Range(n, n + 1));
                return;
            }
            this.ranges.add(new Range(n, n + 1));
        }

        public synchronized void addAll(int ... n) {
            for (int i : n) {
                this.add(i);
            }
        }

        private void checkCollapse(int i) {
            Range rhs;
            if (i < 0 || i == this.ranges.size() - 1) {
                return;
            }
            Range lhs = this.ranges.get(i);
            if (lhs.isAdjacentTo(rhs = this.ranges.get(i + 1))) {
                Range r = new Range(lhs.start, rhs.end);
                this.ranges.set(i, r);
                this.ranges.remove(i + 1);
            }
        }

        public synchronized boolean includes(int i) {
            for (Range r : this.ranges) {
                if (!r.includes(i)) continue;
                return true;
            }
            return false;
        }

        public synchronized void add(RangeSet that) {
            int lhs = 0;
            int rhs = 0;
            while (lhs < this.ranges.size() && rhs < that.ranges.size()) {
                Range lr = this.ranges.get(lhs);
                Range rr = that.ranges.get(rhs);
                if (lr.end < rr.start) {
                    ++lhs;
                    continue;
                }
                if (rr.end < lr.start) {
                    this.ranges.add(lhs, rr);
                    ++lhs;
                    ++rhs;
                    continue;
                }
                Range m = lr.combine(rr);
                ++rhs;
                while (lhs + 1 < this.ranges.size() && !m.isIndependent(this.ranges.get(lhs + 1))) {
                    m = m.combine(this.ranges.get(lhs + 1));
                    this.ranges.remove(lhs + 1);
                }
                this.ranges.set(lhs, m);
            }
            this.ranges.addAll(that.ranges.subList(rhs, that.ranges.size()));
        }

        public synchronized boolean retainAll(RangeSet that) {
            ArrayList<Range> intersection = new ArrayList<Range>();
            int lhs = 0;
            int rhs = 0;
            while (lhs < this.ranges.size() && rhs < that.ranges.size()) {
                Range lr = this.ranges.get(lhs);
                Range rr = that.ranges.get(rhs);
                if (lr.end <= rr.start) {
                    ++lhs;
                    continue;
                }
                if (rr.end <= lr.start) {
                    ++rhs;
                    continue;
                }
                Range v = lr.intersect(rr);
                intersection.add(v);
                if (lr.end < rr.end) {
                    ++lhs;
                    continue;
                }
                ++rhs;
            }
            boolean same = this.ranges.equals(intersection);
            if (!same) {
                this.ranges.clear();
                this.ranges.addAll(intersection);
                return true;
            }
            return false;
        }

        public synchronized boolean removeAll(RangeSet that) {
            boolean modified = false;
            ArrayList<Range> sub = new ArrayList<Range>();
            int lhs = 0;
            int rhs = 0;
            while (lhs < this.ranges.size() && rhs < that.ranges.size()) {
                Range lr = this.ranges.get(lhs);
                Range rr = that.ranges.get(rhs);
                if (lr.end <= rr.start) {
                    sub.add(lr);
                    ++lhs;
                    continue;
                }
                if (rr.end <= lr.start) {
                    ++rhs;
                    continue;
                }
                assert (!lr.isDisjoint(rr));
                modified = true;
                if (rr.contains(lr)) {
                    ++lhs;
                    continue;
                }
                if (lr.start < rr.start) {
                    Range a = new Range(lr.start, rr.start);
                    sub.add(a);
                }
                if (rr.end < lr.end) {
                    this.ranges.set(lhs, new Range(rr.end, lr.end));
                    ++rhs;
                    continue;
                }
                ++lhs;
            }
            if (!modified) {
                return false;
            }
            sub.addAll(this.ranges.subList(lhs, this.ranges.size()));
            this.ranges.clear();
            this.ranges.addAll(sub);
            return true;
        }

        public synchronized String toString() {
            StringBuilder buf = new StringBuilder();
            for (Range r : this.ranges) {
                if (buf.length() > 0) {
                    buf.append(',');
                }
                buf.append(r);
            }
            return buf.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.ranges.equals(((RangeSet)o).ranges);
        }

        public int hashCode() {
            return this.ranges.hashCode();
        }

        public synchronized boolean isEmpty() {
            return this.ranges.isEmpty();
        }

        public synchronized int min() {
            return this.ranges.get((int)0).start;
        }

        public synchronized int max() {
            return this.ranges.get((int)(this.ranges.size() - 1)).end;
        }

        public synchronized boolean isSmallerThan(int n) {
            if (this.ranges.isEmpty()) {
                return true;
            }
            return this.ranges.get(this.ranges.size() - 1).isSmallerThan(n);
        }

        public static RangeSet fromString(String list, boolean skipError) {
            RangeSet rs = new RangeSet();
            if (list.contains("--") || list.contains(",,")) {
                if (!skipError) {
                    throw new IllegalArgumentException(String.format("Unable to parse '%s', expected correct notation M,N or M-N", list));
                }
                return rs;
            }
            String[] items = Util.tokenize(list, ",");
            if (items.length > 1 && items.length <= StringUtils.countMatches((String)list, (String)",")) {
                if (!skipError) {
                    throw new IllegalArgumentException(String.format("Unable to parse '%s', expected correct notation M,N or M-N", list));
                }
                return rs;
            }
            for (String s : items) {
                s = s.trim();
                try {
                    if (s.isEmpty()) {
                        if (skipError) continue;
                        throw new IllegalArgumentException(String.format("Unable to parse '%s', expected number", list));
                    }
                    if (s.contains("-")) {
                        if (StringUtils.countMatches((String)s, (String)"-") > 1) {
                            if (skipError) continue;
                            throw new IllegalArgumentException(String.format("Unable to parse '%s', expected correct notation M,N or M-N", list));
                        }
                        String[] tokens = Util.tokenize(s, "-");
                        if (tokens.length == 2) {
                            int left = Integer.parseInt(tokens[0]);
                            int right = Integer.parseInt(tokens[1]);
                            if (left < 0 || right < 0) {
                                if (skipError) continue;
                                throw new IllegalArgumentException(String.format("Unable to parse '%s', expected number above zero", list));
                            }
                            if (left > right) {
                                if (skipError) continue;
                                throw new IllegalArgumentException(String.format("Unable to parse '%s', expected string with a range M-N where M<N", list));
                            }
                            rs.ranges.add(new Range(left, right + 1));
                            continue;
                        }
                        if (skipError) continue;
                        throw new IllegalArgumentException(String.format("Unable to parse '%s', expected string with a range M-N", list));
                    }
                    int n = Integer.parseInt(s);
                    rs.ranges.add(new Range(n, n + 1));
                }
                catch (NumberFormatException e) {
                    if (skipError) continue;
                    throw new IllegalArgumentException(String.format("Unable to parse '%s', expected number", list));
                }
            }
            return rs;
        }

        public static final class ConverterImpl
        implements Converter {
            private final Converter collectionConv;

            public ConverterImpl(Converter collectionConv) {
                this.collectionConv = collectionConv;
            }

            public boolean canConvert(Class type) {
                return type == RangeSet.class;
            }

            public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                RangeSet src = (RangeSet)source;
                writer.setValue(ConverterImpl.serialize(src));
            }

            public static String serialize(RangeSet src) {
                StringBuilder buf = new StringBuilder(src.ranges.size() * 10);
                for (Range r : src.ranges) {
                    if (buf.length() > 0) {
                        buf.append(',');
                    }
                    if (r.isSingle()) {
                        buf.append(r.start);
                        continue;
                    }
                    buf.append(r.start).append('-').append(r.end - 1);
                }
                return buf.toString();
            }

            public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                if (reader.hasMoreChildren()) {
                    return new RangeSet((List)this.collectionConv.unmarshal(reader, context));
                }
                return RangeSet.fromString(reader.getValue(), true);
            }
        }
    }

    @ExportedBean(defaultVisibility=4)
    public static final class Range {
        final int start;
        final int end;

        public Range(int start, int end) {
            assert (start < end);
            this.start = start;
            this.end = end;
        }

        @Exported
        public int getStart() {
            return this.start;
        }

        @Exported
        public int getEnd() {
            return this.end;
        }

        public boolean isSmallerThan(int i) {
            return this.end <= i;
        }

        public boolean isBiggerThan(int i) {
            return i < this.start;
        }

        public boolean includes(int i) {
            return this.start <= i && i < this.end;
        }

        public Range expandRight() {
            return new Range(this.start, this.end + 1);
        }

        public Range expandLeft() {
            return new Range(this.start - 1, this.end);
        }

        public boolean isAdjacentTo(Range that) {
            return this.end == that.start;
        }

        public String toString() {
            return "[" + this.start + "," + this.end + ")";
        }

        public boolean isIndependent(Range that) {
            return this.end < that.start || that.end < this.start;
        }

        public boolean isDisjoint(Range that) {
            return this.end <= that.start || that.end <= this.start;
        }

        public boolean isSingle() {
            return this.end - 1 == this.start;
        }

        public boolean contains(Range that) {
            return this.start <= that.start && that.end <= this.end;
        }

        public Range combine(Range that) {
            assert (!this.isIndependent(that));
            return new Range(Math.min(this.start, that.start), Math.max(this.end, that.end));
        }

        public Range intersect(Range that) {
            assert (!this.isDisjoint(that));
            return new Range(Math.max(this.start, that.start), Math.min(this.end, that.end));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Range that = (Range)o;
            return this.start == that.start && this.end == that.end;
        }

        public int hashCode() {
            return 31 * this.start + this.end;
        }
    }

    @ExportedBean(defaultVisibility=2)
    @BridgeMethodsAdded
    public static class BuildPtr {
        String name;
        final int number;

        public BuildPtr(String name, int number) {
            this.name = name;
            this.number = number;
        }

        public BuildPtr(Run run) {
            this(((AbstractItem)run.getParent()).getFullName(), run.getNumber());
        }

        @Exported
        @NonNull
        public String getName() {
            return this.name;
        }

        private boolean hasPermissionToDiscoverBuild() {
            Jenkins instance = Jenkins.get();
            if (instance.hasPermission(Jenkins.ADMINISTER)) {
                return true;
            }
            return Fingerprint.canDiscoverItem(this.name);
        }

        void setName(String newName) {
            this.name = newName;
        }

        @WithBridgeMethods(value={AbstractProject.class}, castRequired=true)
        public Job<?, ?> getJob() {
            return Jenkins.get().getItemByFullName(this.name, Job.class);
        }

        @Exported
        @NonNull
        public int getNumber() {
            return this.number;
        }

        public Run getRun() {
            Job<?, ?> j = this.getJob();
            if (j == null) {
                return null;
            }
            return j.getBuildByNumber(this.number);
        }

        private boolean isAlive() {
            return this.getRun() != null;
        }

        public boolean is(Run r) {
            return r.getNumber() == this.number && ((AbstractItem)r.getParent()).getFullName().equals(this.name);
        }

        public boolean is(Job job) {
            return job.getFullName().equals(this.name);
        }

        public boolean belongsTo(Job job) {
            Item p = Jenkins.get().getItemByFullName(this.name);
            while (p != null) {
                if (p == job) {
                    return true;
                }
                ItemGroup<? extends Item> parent = p.getParent();
                if (!(parent instanceof Item)) {
                    return false;
                }
                p = (Item)((Object)parent);
            }
            return false;
        }

        public String toString() {
            return this.name + " #" + this.number;
        }
    }
}

