/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.Util;
import hudson.diagnosis.OldDataMonitor;
import hudson.model.Descriptor;
import hudson.model.DirectlyModifiableView;
import hudson.model.Failure;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Messages;
import hudson.model.ModifiableItemGroup;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewDescriptor;
import hudson.model.ViewGroup;
import hudson.model.listeners.ItemListener;
import hudson.search.SearchIndexBuilder;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.CaseInsensitiveComparator;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import hudson.views.ListViewColumn;
import hudson.views.StatusFilter;
import hudson.views.ViewJobFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.jcip.annotations.GuardedBy;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.POST;
import org.springframework.security.access.AccessDeniedException;

public class ListView
extends View
implements DirectlyModifiableView {
    @GuardedBy(value="this")
    SortedSet<String> jobNames = new TreeSet<String>(CaseInsensitiveComparator.INSTANCE);
    private DescribableList<ViewJobFilter, Descriptor<ViewJobFilter>> jobFilters;
    private DescribableList<ListViewColumn, Descriptor<ListViewColumn>> columns;
    private String includeRegex;
    private boolean recurse;
    private transient Pattern includePattern;
    @Deprecated
    private transient Boolean statusFilter;

    @DataBoundConstructor
    public ListView(String name) {
        super(name);
        this.initColumns();
        this.initJobFilters();
    }

    public ListView(String name, ViewGroup owner) {
        this(name);
        this.owner = owner;
    }

    @DataBoundSetter
    public void setColumns(List<ListViewColumn> columns) throws IOException {
        this.columns.replaceBy(columns);
    }

    @DataBoundSetter
    public void setJobFilters(List<ViewJobFilter> jobFilters) throws IOException {
        this.jobFilters.replaceBy(jobFilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object readResolve() {
        if (this.includeRegex != null) {
            try {
                this.includePattern = Pattern.compile(this.includeRegex);
            }
            catch (PatternSyntaxException x) {
                this.includeRegex = null;
                OldDataMonitor.report((Saveable)this, Collections.singleton(x));
            }
        }
        ListView listView = this;
        synchronized (listView) {
            if (this.jobNames == null) {
                this.jobNames = new TreeSet<String>(CaseInsensitiveComparator.INSTANCE);
            }
        }
        this.initColumns();
        this.initJobFilters();
        if (this.statusFilter != null) {
            this.jobFilters.add(new StatusFilter(this.statusFilter));
        }
        return this;
    }

    protected void initColumns() {
        if (this.columns == null) {
            this.columns = new DescribableList(this, ListViewColumn.createDefaultInitialColumnList(this.getClass()));
        }
    }

    protected void initJobFilters() {
        if (this.jobFilters == null) {
            this.jobFilters = new DescribableList(this);
        }
    }

    public boolean hasJobFilterExtensions() {
        return !ViewJobFilter.all().isEmpty();
    }

    public DescribableList<ViewJobFilter, Descriptor<ViewJobFilter>> getJobFilters() {
        return this.jobFilters;
    }

    public DescribableList<ListViewColumn, Descriptor<ListViewColumn>> getColumns() {
        return this.columns;
    }

    public Set<String> getJobNames() {
        return Collections.unmodifiableSet(this.jobNames);
    }

    public List<TopLevelItem> getItems() {
        return this.getItems(this.recurse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TopLevelItem> getItems(boolean recurse) {
        DescribableList<ViewJobFilter, Descriptor<ViewJobFilter>> jobFilters;
        TreeSet<String> names;
        List<TopLevelItem> items = new ArrayList<TopLevelItem>();
        ListView listView = this;
        synchronized (listView) {
            names = new TreeSet<String>(this.jobNames);
        }
        ItemGroup<? extends TopLevelItem> parent = this.getOwner().getItemGroup();
        if (recurse) {
            if (!names.isEmpty() || this.includePattern != null) {
                items.addAll(parent.getAllItems(TopLevelItem.class, item -> {
                    String itemName = item.getRelativeNameFrom(parent);
                    if (names.contains(itemName)) {
                        return true;
                    }
                    if (this.includePattern != null) {
                        return this.includePattern.matcher(itemName).matches();
                    }
                    return false;
                }));
            }
        } else {
            for (String name : names) {
                try {
                    TopLevelItem i = parent.getItem(name);
                    if (i == null) continue;
                    items.add(i);
                }
                catch (AccessDeniedException accessDeniedException) {}
            }
            if (this.includePattern != null) {
                items.addAll(parent.getItems(item -> {
                    String itemName = item.getRelativeNameFrom(parent);
                    return this.includePattern.matcher(itemName).matches();
                }));
            }
        }
        if (!(jobFilters = this.getJobFilters()).isEmpty()) {
            ArrayList<TopLevelItem> candidates = recurse ? parent.getAllItems(TopLevelItem.class) : new ArrayList<TopLevelItem>(parent.getItems());
            for (ViewJobFilter jobFilter : jobFilters) {
                items = jobFilter.filter(items, candidates, this);
            }
        }
        items = new ArrayList(new LinkedHashSet(items));
        return items;
    }

    @Override
    public SearchIndexBuilder makeSearchIndex() {
        SearchIndexBuilder sib = new SearchIndexBuilder().addAllAnnotations(this);
        this.makeSearchIndex(sib);
        this.addDisplayNamesToSearchIndex(sib, this.getItems(true));
        return sib;
    }

    @Override
    public boolean contains(TopLevelItem item) {
        return this.getItems().contains(item);
    }

    public synchronized boolean jobNamesContains(TopLevelItem item) {
        if (item == null) {
            return false;
        }
        return this.jobNames.contains(item.getRelativeNameFrom(this.getOwner().getItemGroup()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(TopLevelItem item) throws IOException {
        ListView listView = this;
        synchronized (listView) {
            this.jobNames.add(item.getRelativeNameFrom(this.getOwner().getItemGroup()));
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(TopLevelItem item) throws IOException {
        ListView listView = this;
        synchronized (listView) {
            String name = item.getRelativeNameFrom(this.getOwner().getItemGroup());
            if (!this.jobNames.remove(name)) {
                return false;
            }
        }
        this.save();
        return true;
    }

    public String getIncludeRegex() {
        return this.includeRegex;
    }

    public boolean isRecurse() {
        return this.recurse;
    }

    @DataBoundSetter
    public void setRecurse(boolean recurse) {
        this.recurse = recurse;
    }

    @Deprecated
    public Boolean getStatusFilter() {
        return this.statusFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restricted(value={NoExternalUse.class})
    public boolean isAddToCurrentView() {
        ListView listView = this;
        synchronized (listView) {
            return !this.jobNames.isEmpty() || this.jobFilters.isEmpty() && this.includePattern == null;
        }
    }

    private boolean needToAddToCurrentView(StaplerRequest req) throws ServletException {
        String json = req.getParameter("json");
        if (json != null && json.length() > 0) {
            JSONObject form = req.getSubmittedForm();
            return form.has("addToCurrentView") && form.getBoolean("addToCurrentView");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @POST
    public Item doCreateItem(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        ItemGroup<? extends TopLevelItem> ig = this.getOwner().getItemGroup();
        if (ig instanceof ModifiableItemGroup) {
            TopLevelItem item = (TopLevelItem)((ModifiableItemGroup)ig).doCreateItem(req, rsp);
            if (item != null && this.needToAddToCurrentView(req)) {
                ListView listView = this;
                synchronized (listView) {
                    this.jobNames.add(item.getRelativeNameFrom(this.getOwner().getItemGroup()));
                }
                this.owner.save();
            }
            return item;
        }
        return null;
    }

    @Override
    @RequirePOST
    public HttpResponse doAddJobToView(@QueryParameter String name) throws IOException, ServletException {
        this.checkPermission(View.CONFIGURE);
        if (name == null) {
            throw new Failure("Query parameter 'name' is required");
        }
        TopLevelItem item = this.resolveName(name);
        if (item == null) {
            throw new Failure("Query parameter 'name' does not correspond to a known item");
        }
        if (this.contains(item)) {
            return HttpResponses.ok();
        }
        this.add(item);
        this.owner.save();
        return HttpResponses.ok();
    }

    @Override
    @RequirePOST
    public HttpResponse doRemoveJobFromView(@QueryParameter String name) throws IOException, ServletException {
        this.checkPermission(View.CONFIGURE);
        if (name == null) {
            throw new Failure("Query parameter 'name' is required");
        }
        TopLevelItem item = this.resolveName(name);
        if (item == null) {
            throw new Failure("Query parameter 'name' does not correspond to a known and readable item");
        }
        if (this.remove(item)) {
            this.owner.save();
        }
        return HttpResponses.ok();
    }

    @CheckForNull
    private TopLevelItem resolveName(String name) {
        TopLevelItem item = this.getOwner().getItemGroup().getItem(name);
        if (item == null) {
            name = Items.getCanonicalName(this.getOwner().getItemGroup(), name);
            item = Jenkins.get().getItemByFullName(name, TopLevelItem.class);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void submit(StaplerRequest req) throws ServletException, Descriptor.FormException, IOException {
        JSONObject json = req.getSubmittedForm();
        ListView listView = this;
        synchronized (listView) {
            this.recurse = json.optBoolean("recurse", true);
            this.jobNames.clear();
            Collection<? extends TopLevelItem> items = this.recurse ? this.getOwner().getItemGroup().getAllItems(TopLevelItem.class) : this.getOwner().getItemGroup().getItems();
            for (TopLevelItem topLevelItem : items) {
                String relativeNameFrom = topLevelItem.getRelativeNameFrom(this.getOwner().getItemGroup());
                if (req.getParameter(relativeNameFrom) == null) continue;
                this.jobNames.add(relativeNameFrom);
            }
        }
        this.setIncludeRegex(req.getParameter("useincluderegex") != null ? req.getParameter("includeRegex") : null);
        if (this.columns == null) {
            this.columns = new DescribableList(this);
        }
        this.columns.rebuildHetero(req, json, ListViewColumn.all(), "columns");
        if (this.jobFilters == null) {
            this.jobFilters = new DescribableList(this);
        }
        this.jobFilters.rebuildHetero(req, json, ViewJobFilter.all(), "jobFilters");
        String filter = Util.fixEmpty(req.getParameter("statusFilter"));
        this.statusFilter = filter != null ? Boolean.valueOf("1".equals(filter)) : null;
    }

    @DataBoundSetter
    public void setIncludeRegex(String includeRegex) {
        this.includeRegex = Util.nullify(includeRegex);
        this.includePattern = this.includeRegex == null ? null : Pattern.compile(includeRegex);
    }

    @DataBoundSetter
    public synchronized void setJobNames(Set<String> jobNames) {
        this.jobNames = new TreeSet<String>(jobNames);
    }

    @Deprecated
    @DataBoundSetter
    public void setStatusFilter(Boolean statusFilter) {
        this.statusFilter = statusFilter;
    }

    @Deprecated
    public static List<ListViewColumn> getDefaultColumns() {
        return ListViewColumn.createDefaultInitialColumnList(ListView.class);
    }

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static final class Listener
    extends ItemListener {
        @Override
        public void onLocationChanged(Item item, String oldFullName, String newFullName) {
            try (ACLContext acl = ACL.as2(ACL.SYSTEM2);){
                this.locationChanged(oldFullName, newFullName);
            }
        }

        private void locationChanged(String oldFullName, String newFullName) {
            Jenkins jenkins = Jenkins.get();
            this.locationChanged(jenkins, oldFullName, newFullName);
            for (Item g : jenkins.allItems()) {
                if (!(g instanceof ViewGroup)) continue;
                this.locationChanged((ViewGroup)((Object)g), oldFullName, newFullName);
            }
        }

        private void locationChanged(ViewGroup vg, String oldFullName, String newFullName) {
            for (View v : vg.getViews()) {
                if (v instanceof ListView) {
                    this.renameViewItem(oldFullName, newFullName, vg, (ListView)v);
                }
                if (!(v instanceof ViewGroup)) continue;
                this.locationChanged((ViewGroup)((Object)v), oldFullName, newFullName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void renameViewItem(String oldFullName, String newFullName, ViewGroup vg, ListView lv) {
            boolean needsSave;
            ListView listView = lv;
            synchronized (listView) {
                HashSet<String> oldJobNames = new HashSet<String>(lv.jobNames);
                lv.jobNames.clear();
                for (String oldName : oldJobNames) {
                    lv.jobNames.add(Items.computeRelativeNamesAfterRenaming(oldFullName, newFullName, oldName, vg.getItemGroup()));
                }
                needsSave = !oldJobNames.equals(lv.jobNames);
            }
            if (needsSave) {
                try {
                    lv.save();
                }
                catch (IOException x) {
                    Logger.getLogger(ListView.class.getName()).log(Level.WARNING, null, x);
                }
            }
        }

        @Override
        public void onDeleted(Item item) {
            try (ACLContext acl = ACL.as2(ACL.SYSTEM2);){
                this.deleted(item);
            }
        }

        private void deleted(Item item) {
            Jenkins jenkins = Jenkins.get();
            this.deleted(jenkins, item);
            for (Item g : jenkins.allItems()) {
                if (!(g instanceof ViewGroup)) continue;
                this.deleted((ViewGroup)((Object)g), item);
            }
        }

        private void deleted(ViewGroup vg, Item item) {
            for (View v : vg.getViews()) {
                if (v instanceof ListView) {
                    this.deleteViewItem(item, vg, (ListView)v);
                }
                if (!(v instanceof ViewGroup)) continue;
                this.deleted((ViewGroup)((Object)v), item);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteViewItem(Item item, ViewGroup vg, ListView lv) {
            boolean needsSave;
            ListView listView = lv;
            synchronized (listView) {
                needsSave = lv.jobNames.remove(item.getRelativeNameFrom(vg.getItemGroup()));
            }
            if (needsSave) {
                try {
                    lv.save();
                }
                catch (IOException x) {
                    Logger.getLogger(ListView.class.getName()).log(Level.WARNING, null, x);
                }
            }
        }
    }

    @Extension
    @Symbol(value={"list"})
    public static class DescriptorImpl
    extends ViewDescriptor {
        @Override
        public String getDisplayName() {
            return Messages.ListView_DisplayName();
        }

        public FormValidation doCheckIncludeRegex(@QueryParameter String value) throws IOException, ServletException, InterruptedException {
            String v = Util.fixEmpty(value);
            if (v != null) {
                try {
                    Pattern.compile(v);
                }
                catch (PatternSyntaxException pse) {
                    return FormValidation.error(pse.getMessage());
                }
            }
            return FormValidation.ok();
        }
    }
}

